/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.aggregation;

import com.yahoo.searchlib.aggregation.AggregationResult;
import com.yahoo.searchlib.expression.FloatResultNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;

public class StandardDeviationAggregationResult
extends AggregationResult {
    public static final int classId = StandardDeviationAggregationResult.registerClass((int)16473, StandardDeviationAggregationResult.class, StandardDeviationAggregationResult::new);
    private long count;
    private double sum;
    private double sumOfSquared;

    public StandardDeviationAggregationResult() {
        this(0L, 0.0, 0.0);
    }

    public StandardDeviationAggregationResult(long count, double sum, double sumOfSquared) {
        this.count = count;
        this.sum = sum;
        this.sumOfSquared = sumOfSquared;
    }

    public double getStandardDeviation() {
        if (this.count == 0L) {
            return 0.0;
        }
        double variance = (this.sumOfSquared - this.sum * this.sum / (double)this.count) / (double)this.count;
        return Math.sqrt(variance);
    }

    @Override
    public ResultNode getRank() {
        return new FloatResultNode(this.getStandardDeviation());
    }

    @Override
    protected void onMerge(AggregationResult obj) {
        StandardDeviationAggregationResult other = (StandardDeviationAggregationResult)obj;
        this.count += other.count;
        this.sum += other.sum;
        this.sumOfSquared += other.sumOfSquared;
    }

    @Override
    protected boolean equalsAggregation(AggregationResult obj) {
        StandardDeviationAggregationResult other = (StandardDeviationAggregationResult)obj;
        return this.count == other.count && this.sum == other.sum && this.sumOfSquared == other.sumOfSquared;
    }

    @Override
    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        buf.putLong(null, this.count);
        buf.putDouble(null, this.sum);
        buf.putDouble(null, this.sumOfSquared);
    }

    @Override
    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        this.count = buf.getLong(null);
        this.sum = buf.getDouble(null);
        this.sumOfSquared = buf.getDouble(null);
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    @Override
    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("count", (Object)this.count);
        visitor.visit("sum", (Object)this.sum);
        visitor.visit("sumOfSquared", (Object)this.sumOfSquared);
    }
}

