/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.predicate;

import com.yahoo.document.predicate.BooleanPredicate;
import com.yahoo.document.predicate.Conjunction;
import com.yahoo.document.predicate.Disjunction;
import com.yahoo.document.predicate.FeatureRange;
import com.yahoo.document.predicate.FeatureSet;
import com.yahoo.document.predicate.Negation;
import com.yahoo.document.predicate.Predicate;

public class Predicates {
    public static Conjunction and(Predicate ... operands) {
        return new Conjunction(operands);
    }

    public static Disjunction or(Predicate ... operands) {
        return new Disjunction(operands);
    }

    public static Negation not(Predicate operand) {
        return new Negation(operand);
    }

    public static BooleanPredicate value(boolean value) {
        return new BooleanPredicate(value);
    }

    public static FeatureBuilder feature(String key) {
        return new FeatureBuilder(key);
    }

    public static class FeatureBuilder {
        private final String key;

        public FeatureBuilder(String key) {
            this.key = key;
        }

        public FeatureRange lessThan(long toExclusive) {
            return new FeatureRange(this.key, null, toExclusive - 1L);
        }

        public FeatureRange lessThanOrEqualTo(long toInclusive) {
            return new FeatureRange(this.key, null, toInclusive);
        }

        public FeatureRange greaterThan(long fromExclusive) {
            return new FeatureRange(this.key, fromExclusive + 1L, null);
        }

        public FeatureRange greaterThanOrEqualTo(long fromInclusive) {
            return new FeatureRange(this.key, fromInclusive, null);
        }

        public FeatureRange inRange(long fromInclusive, long toInclusive) {
            return new FeatureRange(this.key, fromInclusive, toInclusive);
        }

        public Negation notInRange(long fromInclusive, long toInclusive) {
            return new Negation(new FeatureRange(this.key, fromInclusive, toInclusive));
        }

        public FeatureSet inSet(String ... values) {
            return new FeatureSet(this.key, values);
        }

        public Negation notInSet(String ... values) {
            return new Negation(new FeatureSet(this.key, values));
        }
    }
}

