/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.predicate;

import com.yahoo.document.predicate.PredicateValue;

public class RangePartition
extends PredicateValue {
    private String label;

    public RangePartition(String label) {
        this.label = label;
    }

    public RangePartition(String key, long fromInclusive, long toInclusive, boolean isNeg) {
        this(RangePartition.makeLabel(key, fromInclusive, toInclusive, isNeg));
    }

    private static String makeLabel(String key, long fromInclusive, long toInclusive, boolean isNeg) {
        if (isNeg) {
            return key + "=" + (toInclusive == Long.MIN_VALUE ? "" : "-") + toInclusive + "-" + fromInclusive;
        }
        return key + "=" + fromInclusive + (toInclusive == Long.MIN_VALUE ? "" : "-") + toInclusive;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public RangePartition clone() throws CloneNotSupportedException {
        return (RangePartition)super.clone();
    }

    public int hashCode() {
        return this.label.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RangePartition)) {
            return false;
        }
        return this.label.equals(((RangePartition)obj).getLabel());
    }

    @Override
    protected void appendTo(StringBuilder out) {
        int i = this.label.lastIndexOf(61);
        RangePartition.appendQuotedTo(this.label.substring(0, i), out);
        if (out.charAt(out.length() - 1) == '\'') {
            out.deleteCharAt(out.length() - 1);
            out.append(this.label.substring(i));
            out.append('\'');
        } else {
            out.append(this.label.substring(i));
        }
    }
}

