/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.modelintegration.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Optional;
import net.jpountz.xxhash.StreamingXXHash64;
import net.jpountz.xxhash.XXHashFactory;

public record ModelPathOrData(Optional<String> path, Optional<byte[]> data) {
    public ModelPathOrData {
        if (path.isEmpty() == data.isEmpty()) {
            throw new IllegalArgumentException("Either path or data must be non-empty");
        }
    }

    public static ModelPathOrData of(String path) {
        return new ModelPathOrData(Optional.of(path), Optional.empty());
    }

    public static ModelPathOrData of(byte[] data) {
        return new ModelPathOrData(Optional.empty(), Optional.of(data));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public long calculateHash() {
        if (this.path.isPresent()) {
            try (StreamingXXHash64 hasher = XXHashFactory.fastestInstance().newStreamingHash64(0L);){
                long l;
                block16: {
                    InputStream in = Files.newInputStream(Paths.get(this.path.get(), new String[0]), new OpenOption[0]);
                    try {
                        int bytesRead;
                        byte[] buffer = new byte[8192];
                        while ((bytesRead = in.read(buffer)) != -1) {
                            hasher.update(buffer, 0, bytesRead);
                        }
                        l = hasher.getValue();
                        if (in == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    in.close();
                }
                return l;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return XXHashFactory.fastestInstance().hash64().hash(this.data.get(), 0, this.data.get().length, 0L);
    }
}

