/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.operations;

import ai.vespa.rankingexpression.importer.DimensionRenamer;
import ai.vespa.rankingexpression.importer.OrderedTensorType;
import ai.vespa.rankingexpression.importer.operations.IntermediateOperation;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.tensor.evaluation.VariableTensor;
import com.yahoo.tensor.functions.Rename;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.List;

public final class Argument
extends IntermediateOperation {
    private final OrderedTensorType standardNamingType;

    public Argument(String modelName, String nodeName, OrderedTensorType type) {
        super(modelName, nodeName, List.of());
        this.type = type.rename(this.vespaName() + "_");
        this.standardNamingType = OrderedTensorType.standardType(type);
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        return this.type;
    }

    @Override
    protected TensorFunction<Reference> lazyGetFunction() {
        VariableTensor output = new VariableTensor(this.vespaName(), this.standardNamingType.type());
        if (!this.standardNamingType.equals(this.type)) {
            List<String> renameFrom = this.standardNamingType.dimensionNames();
            List<String> renameTo = this.type.dimensionNames();
            output = new Rename((TensorFunction)output, renameFrom, renameTo);
        }
        return output;
    }

    @Override
    public void addDimensionNameConstraints(DimensionRenamer renamer) {
        for (int i = 0; i < this.type.dimensions().size(); ++i) {
            renamer.addDimension(this.type.dimensions().get(i).name());
            for (int j = i + 1; j < this.type.dimensions().size(); ++j) {
                renamer.addConstraint(this.type.dimensions().get(i).name(), this.type.dimensions().get(j).name(), DimensionRenamer.Constraint.lessThan(false), this);
            }
        }
    }

    @Override
    public boolean isInput() {
        return true;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public Argument withInputs(List<IntermediateOperation> inputs) {
        if (!inputs.isEmpty()) {
            throw new IllegalArgumentException("Argument cannot take inputs");
        }
        return new Argument(this.modelName(), this.name(), this.type);
    }

    @Override
    public String operationName() {
        return "Argument";
    }

    @Override
    public String toString() {
        return "Argument(" + String.valueOf(this.standardNamingType) + ")";
    }

    @Override
    public String toFullString() {
        return "\t" + String.valueOf(this.type) + ":\tArgument(" + String.valueOf(this.standardNamingType) + ")";
    }
}

