/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.modelintegration.evaluator;

import ai.onnxruntime.NodeInfo;
import ai.onnxruntime.OnnxTensor;
import ai.onnxruntime.OnnxValue;
import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtSession;
import ai.vespa.modelintegration.evaluator.EmbeddedOnnxRuntime;
import ai.vespa.modelintegration.evaluator.OnnxEvaluator;
import ai.vespa.modelintegration.evaluator.OnnxEvaluatorOptions;
import ai.vespa.modelintegration.evaluator.TensorConverter;
import ai.vespa.modelintegration.evaluator.UncheckedOrtException;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class EmbeddedOnnxEvaluator
implements OnnxEvaluator {
    private static final Logger LOG = Logger.getLogger(EmbeddedOnnxEvaluator.class.getName());
    private final EmbeddedOnnxRuntime.ReferencedOrtSession session;

    EmbeddedOnnxEvaluator(String modelPath, OnnxEvaluatorOptions options, EmbeddedOnnxRuntime runtime) {
        this.session = EmbeddedOnnxEvaluator.createSession(EmbeddedOnnxRuntime.ModelPathOrData.of(modelPath), runtime, options, true);
    }

    EmbeddedOnnxEvaluator(byte[] data, OnnxEvaluatorOptions options, EmbeddedOnnxRuntime runtime) {
        this.session = EmbeddedOnnxEvaluator.createSession(EmbeddedOnnxRuntime.ModelPathOrData.of(data), runtime, options, true);
    }

    @Override
    public Tensor evaluate(Map<String, Tensor> inputs, String output) {
        Map<String, OnnxTensor> onnxInputs = null;
        try {
            Tensor tensor;
            block12: {
                output = this.mapToInternalName(output);
                onnxInputs = TensorConverter.toOnnxTensors(inputs, EmbeddedOnnxRuntime.ortEnvironment(), this.session.instance());
                OrtSession.Result result = this.session.instance().run(onnxInputs, Collections.singleton(output));
                try {
                    tensor = TensorConverter.toVespaTensor(result.get(0));
                    if (result == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (result != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (OrtException e) {
                        throw new RuntimeException("ONNX Runtime exception", e);
                    }
                }
                result.close();
            }
            return tensor;
        }
        finally {
            if (onnxInputs != null) {
                onnxInputs.values().forEach(OnnxTensor::close);
            }
        }
    }

    @Override
    public Map<String, Tensor> evaluate(Map<String, Tensor> inputs) {
        Map<String, OnnxTensor> onnxInputs = null;
        try {
            HashMap<String, Tensor> hashMap;
            block13: {
                onnxInputs = TensorConverter.toOnnxTensors(inputs, EmbeddedOnnxRuntime.ortEnvironment(), this.session.instance());
                HashMap<String, Tensor> outputs = new HashMap<String, Tensor>();
                OrtSession.Result result = this.session.instance().run(onnxInputs);
                try {
                    for (Map.Entry output : result) {
                        String mapped = TensorConverter.asValidName((String)output.getKey());
                        outputs.put(mapped, TensorConverter.toVespaTensor((OnnxValue)output.getValue()));
                    }
                    hashMap = outputs;
                    if (result == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (result != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (OrtException e) {
                        throw new RuntimeException("ONNX Runtime exception", e);
                    }
                }
                result.close();
            }
            return hashMap;
        }
        finally {
            if (onnxInputs != null) {
                onnxInputs.values().forEach(OnnxTensor::close);
            }
        }
    }

    private Map<String, OnnxEvaluator.IdAndType> toSpecMap(Map<String, NodeInfo> infoMap) {
        HashMap<String, OnnxEvaluator.IdAndType> result = new HashMap<String, OnnxEvaluator.IdAndType>();
        for (Map.Entry<String, NodeInfo> info : infoMap.entrySet()) {
            String name = info.getKey();
            String ident = TensorConverter.asValidName(name);
            TensorType t = TensorConverter.toVespaType(info.getValue().getInfo());
            result.put(name, new OnnxEvaluator.IdAndType(ident, t));
        }
        return result;
    }

    @Override
    public Map<String, OnnxEvaluator.IdAndType> getInputs() {
        try {
            return this.toSpecMap(this.session.instance().getInputInfo());
        }
        catch (OrtException e) {
            throw new RuntimeException("ONNX Runtime exception", e);
        }
    }

    @Override
    public Map<String, OnnxEvaluator.IdAndType> getOutputs() {
        try {
            return this.toSpecMap(this.session.instance().getOutputInfo());
        }
        catch (OrtException e) {
            throw new RuntimeException("ONNX Runtime exception", e);
        }
    }

    @Override
    public Map<String, TensorType> getInputInfo() {
        try {
            return TensorConverter.toVespaTypes(this.session.instance().getInputInfo());
        }
        catch (OrtException e) {
            throw new RuntimeException("ONNX Runtime exception", e);
        }
    }

    @Override
    public Map<String, TensorType> getOutputInfo() {
        try {
            return TensorConverter.toVespaTypes(this.session.instance().getOutputInfo());
        }
        catch (OrtException e) {
            throw new RuntimeException("ONNX Runtime exception", e);
        }
    }

    @Override
    public void close() throws IllegalStateException {
        try {
            this.session.close();
        }
        catch (UncheckedOrtException e) {
            throw new IllegalStateException("Failed to close ONNX session", e);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("Already closed", e);
        }
    }

    private static EmbeddedOnnxRuntime.ReferencedOrtSession createSession(EmbeddedOnnxRuntime.ModelPathOrData model, EmbeddedOnnxRuntime runtime, OnnxEvaluatorOptions options, boolean tryCuda) {
        if (options == null) {
            options = OnnxEvaluatorOptions.createDefault();
        }
        try {
            boolean loadCuda = tryCuda && options.requestingGpu();
            EmbeddedOnnxRuntime.ReferencedOrtSession session = runtime.acquireSession(model, options, loadCuda);
            if (loadCuda) {
                LOG.log(Level.INFO, "Created session with CUDA using GPU device " + options.gpuDeviceNumber());
            }
            return session;
        }
        catch (OrtException e) {
            if (e.getCode() == OrtException.OrtErrorCode.ORT_NO_SUCHFILE) {
                throw new IllegalArgumentException("No such file: " + model.path().get());
            }
            if (tryCuda && EmbeddedOnnxRuntime.isCudaError(e) && !options.gpuDeviceRequired()) {
                LOG.log(Level.INFO, "Failed to create session with CUDA using GPU device " + options.gpuDeviceNumber() + ". Falling back to CPU. Reason: " + e.getMessage());
                return EmbeddedOnnxEvaluator.createSession(model, runtime, options, false);
            }
            if (EmbeddedOnnxRuntime.isCudaError(e)) {
                throw new IllegalArgumentException("GPU device is required, but CUDA initialization failed", e);
            }
            throw new RuntimeException("ONNX Runtime exception", e);
        }
    }

    OrtSession ortSession() {
        return this.session.instance();
    }

    private String mapToInternalName(String outputName) throws OrtException {
        Map info = this.session.instance().getOutputInfo();
        Set internalNames = info.keySet();
        for (String name : internalNames) {
            if (!name.equals(outputName)) continue;
            return name;
        }
        for (String name : internalNames) {
            String mapped = TensorConverter.asValidName(name);
            if (!mapped.equals(outputName)) continue;
            return name;
        }
        return outputName;
    }
}

