// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.metrics;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of metricsmanager
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class MetricsmanagerConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "ea7f889d45f793408ebcd4d946050902";
  public final static String CONFIG_DEF_NAME = "metricsmanager";
  public final static String CONFIG_DEF_NAMESPACE = "metrics";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=metrics",
    "snapshot.periods[] int restart",
    "consumer[].name string restart",
    "consumer[].tags[] string restart",
    "consumer[].removedtags[] string restart",
    "consumer[].addedmetrics[] string restart",
    "consumer[].removedmetrics[] string restart"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public Snapshot.Builder snapshot = new Snapshot.Builder();
    public List<Consumer.Builder> consumer = new ArrayList<>();

    public Builder() { }

    public Builder(MetricsmanagerConfig config) {
      snapshot(new Snapshot.Builder(config.snapshot()));
      for (Consumer c : config.consumer()) {
        consumer(new Consumer.Builder(c));
      }
    }

    private Builder override(Builder __superior) {
      snapshot(snapshot.override(__superior.snapshot));
      if (!__superior.consumer.isEmpty())
        consumer.addAll(__superior.consumer);
      return this;
    }

    public Builder snapshot(Snapshot.Builder __builder) {
      snapshot = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder snapshot(java.util.function.Consumer<Snapshot.Builder> __func) {
      Snapshot.Builder __inner = new Snapshot.Builder();
      __func.accept(__inner);
      snapshot = __inner;
      return this;
    }

    /**
     * Add the given builder to this builder's list of Consumer builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder consumer(Consumer.Builder __builder) {
      consumer.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder consumer(java.util.function.Consumer<Consumer.Builder> __func) {
      Consumer.Builder __inner = new Consumer.Builder();
      __func.accept(__inner);
      consumer.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Consumer builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder consumer(List<Consumer.Builder> __builders) {
      consumer = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public MetricsmanagerConfig build() {
      return new MetricsmanagerConfig(this);
    }

  }

  private final Snapshot snapshot;
  private final InnerNodeVector<Consumer> consumer;

  public MetricsmanagerConfig(Builder builder) {
    this(builder, true);
  }

  private MetricsmanagerConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "metricsmanager must be initialized: " + builder.__uninitialized);

    snapshot = new Snapshot(builder.snapshot, throwIfUninitialized);
    consumer = Consumer.createVector(builder.consumer);
  }

  /**
   * @return metricsmanager.snapshot
   */
  public Snapshot snapshot() {
    return snapshot;
  }

  /**
   * @return metricsmanager.consumer[]
   */
  public List<Consumer> consumer() {
    return consumer;
  }

  /**
   * @param i the index of the value to return
   * @return metricsmanager.consumer[]
   */
  public Consumer consumer(int i) {
    return consumer.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(MetricsmanagerConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("metricsmanager");
      changes.mergeChanges("snapshot", this.snapshot.getChangesRequiringRestart(newConfig.snapshot));
      changes.compareArray(this.consumer, newConfig.consumer, "consumer", "",
                        (a,b) -> ((Consumer)a).getChangesRequiringRestart((Consumer)b));
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return true;
  }

  /**
   * This class represents metricsmanager.snapshot
   */
  public final static class Snapshot extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      public List<Integer> periods = new ArrayList<>();

      public Builder() { }

      public Builder(Snapshot config) {
        periods(config.periods());
      }

      private Builder override(Builder __superior) {
        if (!__superior.periods.isEmpty())
          periods.addAll(__superior.periods);
        return this;
      }

      public Builder periods(Integer __value) {
        periods.add(__value);
        return this;
      }

      public Builder periods(Collection<Integer> __values) {
        periods.addAll(__values);
        return this;
      }

      private Builder periods(String __value) {
        return periods(Integer.valueOf(__value));
      }

      public Snapshot build() {
        return new Snapshot(this);
      }

    }

    // If any snapshot periods is set, these override all the default ones.
    // The array sets the snapshot periods in number of seconds. Note that when
    // sorted in rising time length order, it is required that the snapshot length of
    // the next snapshot is a multiplum of the previous snapshot.
    // restart flag was added automatically and needs to be verified.
    private final LeafNodeVector<Integer, IntegerNode> periods;

    public Snapshot(Builder builder) {
      this(builder, true);
    }

    private Snapshot(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "metricsmanager.snapshot must be initialized: " + builder.__uninitialized);

      periods = new LeafNodeVector<>(builder.periods, new IntegerNode());
    }

    /**
     * @return metricsmanager.snapshot.periods[]
     */
    public List<Integer> periods() {
      return periods.asList();
    }

    /**
     * @param i the index of the value to return
     * @return metricsmanager.snapshot.periods[]
     */
    public int periods(int i) {
      return periods.get(i).value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Snapshot newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("snapshot");
        changes.compareArray(this.periods, newConfig.periods, "periods", "If any snapshot periods is set, these override all the default ones.\nThe array sets the snapshot periods in number of seconds. Note that when\nsorted in rising time length order, it is required that the snapshot length of\nthe next snapshot is a multiplum of the previous snapshot.\nrestart flag was added automatically and needs to be verified.",
                          (a,b) -> new ChangesRequiringRestart("periods").compare(a,b,"","If any snapshot periods is set, these override all the default ones.\nThe array sets the snapshot periods in number of seconds. Note that when\nsorted in rising time length order, it is required that the snapshot length of\nthe next snapshot is a multiplum of the previous snapshot.\nrestart flag was added automatically and needs to be verified."));
      return changes;
    }
  }

  /**
   * This class represents metricsmanager.consumer[]
   */
  public final static class Consumer extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "name"
        ));

      private String name = null;
      public List<String> tags = new ArrayList<>();
      public List<String> removedtags = new ArrayList<>();
      public List<String> addedmetrics = new ArrayList<>();
      public List<String> removedmetrics = new ArrayList<>();

      public Builder() { }

      public Builder(Consumer config) {
        name(config.name());
        tags(config.tags());
        removedtags(config.removedtags());
        addedmetrics(config.addedmetrics());
        removedmetrics(config.removedmetrics());
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (!__superior.tags.isEmpty())
          tags.addAll(__superior.tags);
        if (!__superior.removedtags.isEmpty())
          removedtags.addAll(__superior.removedtags);
        if (!__superior.addedmetrics.isEmpty())
          addedmetrics.addAll(__superior.addedmetrics);
        if (!__superior.removedmetrics.isEmpty())
          removedmetrics.addAll(__superior.removedmetrics);
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder tags(String __value) {
        tags.add(__value);
        return this;
      }

      public Builder tags(Collection<String> __values) {
        tags.addAll(__values);
        return this;
      }

      public Builder removedtags(String __value) {
        removedtags.add(__value);
        return this;
      }

      public Builder removedtags(Collection<String> __values) {
        removedtags.addAll(__values);
        return this;
      }

      public Builder addedmetrics(String __value) {
        addedmetrics.add(__value);
        return this;
      }

      public Builder addedmetrics(Collection<String> __values) {
        addedmetrics.addAll(__values);
        return this;
      }

      public Builder removedmetrics(String __value) {
        removedmetrics.add(__value);
        return this;
      }

      public Builder removedmetrics(Collection<String> __values) {
        removedmetrics.addAll(__values);
        return this;
      }

      public Consumer build() {
        return new Consumer(this);
      }

    }

    // The name of the consumer that should include the given metrics specified.
    // restart flag was added automatically and needs to be verified.
    private final StringNode name;
    // Include metrics that match the given tags.
    //  
    // A tag specification either adds a single tag by given the full tag name, or
    // any tag, by specifying an asterix as wildcard ('*'). An asterix will not match
    // metrics without any tags set, but you can match these by specifying an empty
    // string.
    //  
    // A metric set matched by tags, will also include every metric contained in it
    // regardless of tags.
    // restart flag was added automatically and needs to be verified.
    private final LeafNodeVector<String, StringNode> tags;
    // Do not include metrics that match the specific tags. This has higher
    // presedence than the adding of tags, but lower presedence than name patterns.
    //  
    // Removed tags are specified as added tags, with a small exception. Removing
    // wildcard or untagged metrics does not make sense, as metrics are not added by
    // default. If you don not want to include these metrics, just not specify them
    // as tags to be added. Thus, these are not allowed in remove tags spec.
    //  
    // A metric set matched by remove tag will remove all metrics below that tag.
    // restart flag was added automatically and needs to be verified.
    private final LeafNodeVector<String, StringNode> removedtags;
    // Include all metrics that matches the names given here.
    // Metrics added here have presedence above tag specifications.
    //  
    // Names are specified as a complete dot separated path to metric. Asterix can
    // be used to match any part. An asterix will only match a complete name without
    // a dot. So if you have an average metric called 'queuesize' in your top level
    // metric set called 'myapp', you can add this metric with the spec
    // 'myapp.queuesize'. You can also add non-default average metric entries by
    // specifying which, such as 'myapp.queuesize.last' or 'myapp.queuesize.max'.
    // Patterns can be used, to for instance specify '*.queuesize', 'myapp.*', '*.*',
    // 'myapp.*.max' or similar.
    //  
    // A metric set added with specific name will add all metrics within it.
    // restart flag was added automatically and needs to be verified.
    private final LeafNodeVector<String, StringNode> addedmetrics;
    // Do not include metrics with the below names.
    // This has highest presedence. Metrics removed like this will override any
    // specification otherwise that would include them.
    //  
    // The remove metrics are specified exactly the same as the added metrics.
    //  
    // A metric set removed with specific name will remove all metrics within it.
    // restart flag was added automatically and needs to be verified.
    private final LeafNodeVector<String, StringNode> removedmetrics;

    public Consumer(Builder builder) {
      this(builder, true);
    }

    private Consumer(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "metricsmanager.consumer[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      tags = new LeafNodeVector<>(builder.tags, new StringNode());
      removedtags = new LeafNodeVector<>(builder.removedtags, new StringNode());
      addedmetrics = new LeafNodeVector<>(builder.addedmetrics, new StringNode());
      removedmetrics = new LeafNodeVector<>(builder.removedmetrics, new StringNode());
    }

    /**
     * @return metricsmanager.consumer[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return metricsmanager.consumer[].tags[]
     */
    public List<String> tags() {
      return tags.asList();
    }

    /**
     * @param i the index of the value to return
     * @return metricsmanager.consumer[].tags[]
     */
    public String tags(int i) {
      return tags.get(i).value();
    }

    /**
     * @return metricsmanager.consumer[].removedtags[]
     */
    public List<String> removedtags() {
      return removedtags.asList();
    }

    /**
     * @param i the index of the value to return
     * @return metricsmanager.consumer[].removedtags[]
     */
    public String removedtags(int i) {
      return removedtags.get(i).value();
    }

    /**
     * @return metricsmanager.consumer[].addedmetrics[]
     */
    public List<String> addedmetrics() {
      return addedmetrics.asList();
    }

    /**
     * @param i the index of the value to return
     * @return metricsmanager.consumer[].addedmetrics[]
     */
    public String addedmetrics(int i) {
      return addedmetrics.get(i).value();
    }

    /**
     * @return metricsmanager.consumer[].removedmetrics[]
     */
    public List<String> removedmetrics() {
      return removedmetrics.asList();
    }

    /**
     * @param i the index of the value to return
     * @return metricsmanager.consumer[].removedmetrics[]
     */
    public String removedmetrics(int i) {
      return removedmetrics.get(i).value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Consumer newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("consumer");
        changes.compare(this.name, newConfig.name, "name", "The name of the consumer that should include the given metrics specified.\nrestart flag was added automatically and needs to be verified.");
        changes.compareArray(this.tags, newConfig.tags, "tags", "Include metrics that match the given tags.\n \nA tag specification either adds a single tag by given the full tag name, or\nany tag, by specifying an asterix as wildcard ('*'). An asterix will not match\nmetrics without any tags set, but you can match these by specifying an empty\nstring.\n \nA metric set matched by tags, will also include every metric contained in it\nregardless of tags.\nrestart flag was added automatically and needs to be verified.",
                          (a,b) -> new ChangesRequiringRestart("tags").compare(a,b,"","Include metrics that match the given tags.\n \nA tag specification either adds a single tag by given the full tag name, or\nany tag, by specifying an asterix as wildcard ('*'). An asterix will not match\nmetrics without any tags set, but you can match these by specifying an empty\nstring.\n \nA metric set matched by tags, will also include every metric contained in it\nregardless of tags.\nrestart flag was added automatically and needs to be verified."));
        changes.compareArray(this.removedtags, newConfig.removedtags, "removedtags", "Do not include metrics that match the specific tags. This has higher\npresedence than the adding of tags, but lower presedence than name patterns.\n \nRemoved tags are specified as added tags, with a small exception. Removing\nwildcard or untagged metrics does not make sense, as metrics are not added by\ndefault. If you don not want to include these metrics, just not specify them\nas tags to be added. Thus, these are not allowed in remove tags spec.\n \nA metric set matched by remove tag will remove all metrics below that tag.\nrestart flag was added automatically and needs to be verified.",
                          (a,b) -> new ChangesRequiringRestart("removedtags").compare(a,b,"","Do not include metrics that match the specific tags. This has higher\npresedence than the adding of tags, but lower presedence than name patterns.\n \nRemoved tags are specified as added tags, with a small exception. Removing\nwildcard or untagged metrics does not make sense, as metrics are not added by\ndefault. If you don not want to include these metrics, just not specify them\nas tags to be added. Thus, these are not allowed in remove tags spec.\n \nA metric set matched by remove tag will remove all metrics below that tag.\nrestart flag was added automatically and needs to be verified."));
        changes.compareArray(this.addedmetrics, newConfig.addedmetrics, "addedmetrics", "Include all metrics that matches the names given here.\nMetrics added here have presedence above tag specifications.\n \nNames are specified as a complete dot separated path to metric. Asterix can\nbe used to match any part. An asterix will only match a complete name without\na dot. So if you have an average metric called 'queuesize' in your top level\nmetric set called 'myapp', you can add this metric with the spec\n'myapp.queuesize'. You can also add non-default average metric entries by\nspecifying which, such as 'myapp.queuesize.last' or 'myapp.queuesize.max'.\nPatterns can be used, to for instance specify '*.queuesize', 'myapp.*', '*.*',\n'myapp.*.max' or similar.\n \nA metric set added with specific name will add all metrics within it.\nrestart flag was added automatically and needs to be verified.",
                          (a,b) -> new ChangesRequiringRestart("addedmetrics").compare(a,b,"","Include all metrics that matches the names given here.\nMetrics added here have presedence above tag specifications.\n \nNames are specified as a complete dot separated path to metric. Asterix can\nbe used to match any part. An asterix will only match a complete name without\na dot. So if you have an average metric called 'queuesize' in your top level\nmetric set called 'myapp', you can add this metric with the spec\n'myapp.queuesize'. You can also add non-default average metric entries by\nspecifying which, such as 'myapp.queuesize.last' or 'myapp.queuesize.max'.\nPatterns can be used, to for instance specify '*.queuesize', 'myapp.*', '*.*',\n'myapp.*.max' or similar.\n \nA metric set added with specific name will add all metrics within it.\nrestart flag was added automatically and needs to be verified."));
        changes.compareArray(this.removedmetrics, newConfig.removedmetrics, "removedmetrics", "Do not include metrics with the below names.\nThis has highest presedence. Metrics removed like this will override any\nspecification otherwise that would include them.\n \nThe remove metrics are specified exactly the same as the added metrics.\n \nA metric set removed with specific name will remove all metrics within it.\nrestart flag was added automatically and needs to be verified.",
                          (a,b) -> new ChangesRequiringRestart("removedmetrics").compare(a,b,"","Do not include metrics with the below names.\nThis has highest presedence. Metrics removed like this will override any\nspecification otherwise that would include them.\n \nThe remove metrics are specified exactly the same as the added metrics.\n \nA metric set removed with specific name will remove all metrics within it.\nrestart flag was added automatically and needs to be verified."));
      return changes;
    }

    private static InnerNodeVector<Consumer> createVector(List<Builder> builders) {
        List<Consumer> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Consumer(b));
        }
        return new InnerNodeVector<Consumer>(elems);
    }
  }

}
