/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metrics.set;

import ai.vespa.metrics.ConfigServerMetrics;
import ai.vespa.metrics.ContainerMetrics;
import ai.vespa.metrics.ControllerMetrics;
import ai.vespa.metrics.LogdMetrics;
import ai.vespa.metrics.Suffix;
import ai.vespa.metrics.VespaMetrics;
import ai.vespa.metrics.set.Metric;
import ai.vespa.metrics.set.MetricSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class InfrastructureMetricSet {
    public static final MetricSet infrastructureMetricSet = new MetricSet("infrastructure", InfrastructureMetricSet.getInfrastructureMetrics());

    private static Set<Metric> getInfrastructureMetrics() {
        LinkedHashSet<Metric> metrics = new LinkedHashSet<Metric>();
        metrics.addAll(InfrastructureMetricSet.getConfigServerMetrics());
        metrics.addAll(InfrastructureMetricSet.getControllerMetrics());
        metrics.addAll(InfrastructureMetricSet.getOtherMetrics());
        return Collections.unmodifiableSet(metrics);
    }

    private static Set<Metric> getConfigServerMetrics() {
        LinkedHashSet<Metric> metrics = new LinkedHashSet<Metric>();
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.REQUESTS.count());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.FAILED_REQUESTS.count());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.CACHE_CONFIG_ELEMS.last());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.CACHE_CHECKSUM_ELEMS.last());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.HOSTS.last());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.DELAYED_RESPONSES.count());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.SESSION_CHANGE_ERRORS.count());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.ZK_Z_NODES.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.ZK_MAX_LATENCY, EnumSet.of(Suffix.max, Suffix.average));
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.ZK_CONNECTIONS.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.ZK_CONNECTION_LOST.count());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.ZK_RECONNECTED.count());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.ZK_SUSPENDED.count());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.ZK_OUTSTANDING_REQUESTS.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.NODES_ACTIVE.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.NODES_NON_ACTIVE_FRACTION.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.CLUSTER_COST.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.CLUSTER_LOAD_IDEAL_CPU.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.CLUSTER_LOAD_IDEAL_MEMORY.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.CLUSTER_LOAD_IDEAL_DISK.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.CLUSTER_LOAD_PEAK_CPU.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.CLUSTER_LOAD_PEAK_MEMORY.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.CLUSTER_LOAD_PEAK_DISK.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.NODES_EMPTY_EXCLUSIVE.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.NODES_EXPIRED_DEPROVISIONED.count());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.NODES_EXPIRED_DIRTY.count());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.NODES_EXPIRED_INACTIVE.count());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.NODES_EXPIRED_PROVISIONED.count());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.NODES_EXPIRED_RESERVED.count());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.WANT_TO_REBOOT.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.WANT_TO_RESTART.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.WANT_TO_RETIRE.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.RETIRED.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.WANT_TO_CHANGE_VESPA_VERSION.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.HAS_WIRE_GUARD_KEY.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.WANT_TO_DEPROVISION.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.SUSPENDED.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.SUSPENDED_SECONDS.count());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.ACTIVE_SECONDS.count());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.SOME_SERVICES_DOWN.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.NODE_FAILER_BAD_NODE.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.LOCK_ATTEMPT_LOCKED_LOAD, EnumSet.of(Suffix.max, Suffix.average));
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.HOSTED_VESPA_DOCKER_ALLOCATED_CAPACITY_CPU.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.HOSTED_VESPA_DOCKER_ALLOCATED_CAPACITY_MEM.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.HOSTED_VESPA_DOCKER_ALLOCATED_CAPACITY_DISK.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.HOSTED_VESPA_DOCKER_FREE_CAPACITY_CPU.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.HOSTED_VESPA_DOCKER_FREE_CAPACITY_MEM.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.HOSTED_VESPA_DOCKER_FREE_CAPACITY_DISK.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.HOSTED_VESPA_DOCKER_TOTAL_CAPACITY_CPU.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.HOSTED_VESPA_DOCKER_TOTAL_CAPACITY_DISK.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.HOSTED_VESPA_DOCKER_TOTAL_CAPACITY_MEM.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.HOSTED_VESPA_DOCKER_SKEW.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.HOSTED_VESPA_PENDING_REDEPLOYMENTS.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.HOSTED_VESPA_ACTIVE_HOSTS.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.HOSTED_VESPA_DIRTY_HOSTS.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.HOSTED_VESPA_FAILED_HOSTS.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.HOSTED_VESPA_INACTIVE_HOSTS.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.HOSTED_VESPA_PROVISIONED_HOSTS.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.HOSTED_VESPA_READY_HOSTS.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.HOSTED_VESPA_RESERVED_HOSTS.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.HOSTED_VESPA_PARKED_HOSTS.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.HOSTED_VESPA_ACTIVE_NODES.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.HOSTED_VESPA_FAILED_NODES.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.HOSTED_VESPA_PARKED_NODES.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.RPC_SERVER_WORK_QUEUE_SIZE.average());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.DEPLOYMENT_ACTIVATE_MILLIS.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.DEPLOYMENT_PREPARE_MILLIS.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.LOCK_ATTEMPT_LOCKED_LOAD, EnumSet.of(Suffix.max, Suffix.average));
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.MAINTENANCE_SUCCESS_FACTOR_DEVIATION.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.MAINTENANCE_DURATION.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.MAINTENANCE_DEPLOYMENT_FAILURE.count());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.MAINTENANCE_DEPLOYMENT_TRANSIENT_FAILURE.count());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.OVERCOMMITTED_HOSTS.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.SPARE_HOST_CAPACITY, EnumSet.of(Suffix.min, Suffix.max, Suffix.last));
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.THROTTLED_HOST_FAILURES.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.THROTTLED_NODE_FAILURES.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.NODE_FAIL_THROTTLING.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.CLUSTER_AUTOSCALED.count());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.ORCHESTRATOR_LOCK_ACQUIRE_SUCCESS.count());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.ORCHESTRATOR_LOCK_ACQUIRE_TIMEOUT.count());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.ZONE_WORKING.max());
        InfrastructureMetricSet.addMetric(metrics, ConfigServerMetrics.THROTTLED_HOST_PROVISIONING.max());
        InfrastructureMetricSet.addMetric(metrics, ContainerMetrics.HANDLED_LATENCY.max());
        InfrastructureMetricSet.addMetric(metrics, ContainerMetrics.HANDLED_REQUESTS.count());
        InfrastructureMetricSet.addMetric(metrics, ContainerMetrics.HTTP_STATUS_2XX.count());
        InfrastructureMetricSet.addMetric(metrics, ContainerMetrics.HTTP_STATUS_4XX.count());
        InfrastructureMetricSet.addMetric(metrics, ContainerMetrics.HTTP_STATUS_5XX.count());
        InfrastructureMetricSet.addMetric(metrics, ContainerMetrics.JDISC_GC_MS.max());
        InfrastructureMetricSet.addMetric(metrics, ContainerMetrics.MEM_HEAP_USED.average());
        InfrastructureMetricSet.addMetric(metrics, ContainerMetrics.SERVER_NUM_REQUESTS.count());
        InfrastructureMetricSet.addMetric(metrics, ContainerMetrics.SERVER_STARTED_MILLIS.max());
        InfrastructureMetricSet.addMetric(metrics, ContainerMetrics.SERVER_TOTAL_SUCCESSFUL_RESPONSE_LATENCY.max());
        return metrics;
    }

    private static Set<Metric> getControllerMetrics() {
        LinkedHashSet<Metric> metrics = new LinkedHashSet<Metric>();
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.ATHENZ_REQUEST_ERROR.count());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.ARCHIVE_BUCKET_COUNT.max());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.BILLING_TENANTS.max());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.DEPLOYMENT_JOBS_QUEUED, EnumSet.of(Suffix.count, Suffix.sum));
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.DEPLOYMENT_JOBS_ACTIVE, EnumSet.of(Suffix.count, Suffix.sum));
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.DEPLOYMENT_EXECUTOR_SIZE, EnumSet.of(Suffix.max));
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.DEPLOYMENT_ABORT.count());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.DEPLOYMENT_DURATION.max());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.DEPLOYMENT_AVERAGE_DURATION.max());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.DEPLOYMENT_CONVERGENCE_FAILURE.count());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.DEPLOYMENT_NODE_ALLOCATION_FAILURE.count());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.DEPLOYMENT_DEPLOYMENT_FAILURE.count());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.DEPLOYMENT_ERROR.count());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.DEPLOYMENT_FAILING_UPGRADES.min());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.DEPLOYMENT_FAILURE_PERCENTAGE.max());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.DEPLOYMENT_NODE_COUNT_BY_OS_VERSION.max());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.DEPLOYMENT_OS_CHANGE_DURATION.max());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.DEPLOYMENT_QUOTA_EXCEEDED.count());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.DEPLOYMENT_START.count());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.DEPLOYMENT_SUCCESS.count());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.DEPLOYMENT_TEST_FAILURE.count());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.DEPLOYMENT_WARNINGS.max());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.DEPLOYMENT_ENDPOINT_CERTIFICATE_TIMEOUT.count());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.DEPLOYMENT_BROKEN_SYSTEM_VERSION.max());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.OPERATION_APPLICATION.max());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.OPERATION_CHANGEMANAGEMENT.max());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.OPERATION_CONFIGSERVER.max());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.OPERATION_CONTROLLER.max());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.OPERATION_FLAGS.max());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.OPERATION_OS.max());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.OPERATION_ROUTING.max());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.OPERATION_ZONE.max());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.REMAINING_ROTATIONS, EnumSet.of(Suffix.min, Suffix.max, Suffix.last));
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.DNS_QUEUED_REQUESTS.max());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.CLOUD_QUOTA_USAGE.max());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.ZMS_QUOTA_USAGE.max());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.COREDUMP_PROCESSED.count());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.AUTH0_EXCEPTIONS.count());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.BILLING_CREDITS.last());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.BILLING_CREDITS_GLOBAL.last());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.BILLING_EXCEPTIONS.count());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.BILLING_WEBHOOK_FAILURES.count());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.CERTIFICATE_POOL_AVAILABLE.max());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.CERTIFICATE_COUNT.max());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.CERTIFICATE_NAME_COUNT.max());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.CERTIFICATE_REQUEST_EXCEPTIONS.count());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.METERING_AGE_SECONDS.min());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.METERING_LAST_REPORTED.max());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.MAIL_SENT.count());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.MAIL_FAILED.count());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.MAIL_THROTTLED.count());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.HUBSPOT_EXCEPTIONS.count());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.HUBSPOT_LAST_SUCCESS.last());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.TENANT_CREATED_LAST_SUCCESS.last());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.ATLASSIAN_EXCEPTIONS.count());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.ATLASSIAN_LAST_SUCCESS.last());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.ATLASSIAN_ASSETS.max());
        InfrastructureMetricSet.addMetric(metrics, ControllerMetrics.ATLASSIAN_SERVICEDESK_CUSTOMERS.max());
        return metrics;
    }

    private static Set<Metric> getOtherMetrics() {
        LinkedHashSet<Metric> metrics = new LinkedHashSet<Metric>();
        InfrastructureMetricSet.addMetric(metrics, LogdMetrics.LOGD_PROCESSED_LINES.count());
        return metrics;
    }

    private static void addMetric(Set<Metric> metrics, String nameWithSuffix) {
        metrics.add(new Metric(nameWithSuffix));
    }

    private static void addMetric(Set<Metric> metrics, VespaMetrics metric, EnumSet<Suffix> suffixes) {
        suffixes.forEach(suffix -> metrics.add(new Metric(metric.baseName() + "." + suffix.suffix())));
    }
}

