// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package ai.vespa.metricsproxy.service;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of vespa-services
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class VespaServicesConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "1676493faba7589269977dbffa020ca2";
  public final static String CONFIG_DEF_NAME = "vespa-services";
  public final static String CONFIG_DEF_NAMESPACE = "ai.vespa.metricsproxy.service";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "package=ai.vespa.metricsproxy.service",
    "service[].configId string",
    "service[].name string default=\"\"",
    "service[].port int default=-1",
    "service[].dimension[].key string",
    "service[].dimension[].value string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Service.Builder> service = new ArrayList<>();

    public Builder() { }

    public Builder(VespaServicesConfig config) {
      for (Service s : config.service()) {
        service(new Service.Builder(s));
      }
    }

    private Builder override(Builder __superior) {
      if (!__superior.service.isEmpty())
        service.addAll(__superior.service);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Service builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder service(Service.Builder __builder) {
      service.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder service(java.util.function.Consumer<Service.Builder> __func) {
      Service.Builder __inner = new Service.Builder();
      __func.accept(__inner);
      service.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Service builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder service(List<Service.Builder> __builders) {
      service = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public VespaServicesConfig build() {
      return new VespaServicesConfig(this);
    }

  }

  private final InnerNodeVector<Service> service;

  public VespaServicesConfig(Builder builder) {
    this(builder, true);
  }

  private VespaServicesConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "vespa-services must be initialized: " + builder.__uninitialized);

    service = Service.createVector(builder.service);
  }

  /**
   * @return vespa-services.service[]
   */
  public List<Service> service() {
    return service;
  }

  /**
   * @param i the index of the value to return
   * @return vespa-services.service[]
   */
  public Service service(int i) {
    return service.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(VespaServicesConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("vespa-services");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents vespa-services.service[]
   */
  public final static class Service extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "configId"
        ));

      private String configId = null;
      private String name = null;
      private Integer port = null;
      public List<Dimension.Builder> dimension = new ArrayList<>();

      public Builder() { }

      public Builder(Service config) {
        configId(config.configId());
        name(config.name());
        port(config.port());
        for (Dimension d : config.dimension()) {
          dimension(new Dimension.Builder(d));
        }
      }

      private Builder override(Builder __superior) {
        if (__superior.configId != null)
          configId(__superior.configId);
        if (__superior.name != null)
          name(__superior.name);
        if (__superior.port != null)
          port(__superior.port);
        if (!__superior.dimension.isEmpty())
          dimension.addAll(__superior.dimension);
        return this;
      }

      public Builder configId(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        configId = __value;
        __uninitialized.remove("configId");
        return this;
      }


      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        return this;
      }


      public Builder port(int __value) {
        port = __value;
        return this;
      }

      private Builder port(String __value) {
        return port(Integer.valueOf(__value));
      }

      /**
       * Add the given builder to this builder's list of Dimension builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder dimension(Dimension.Builder __builder) {
        dimension.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder dimension(java.util.function.Consumer<Dimension.Builder> __func) {
        Dimension.Builder __inner = new Dimension.Builder();
        __func.accept(__inner);
        dimension.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Dimension builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder dimension(List<Dimension.Builder> __builders) {
        dimension = __builders;
        return this;
      }

      public Service build() {
        return new Service(this);
      }

    }

    // Services with service id and the http port for the metrics page
    private final StringNode configId;
    private final StringNode name;
    private final IntegerNode port;
    private final InnerNodeVector<Dimension> dimension;

    public Service(Builder builder) {
      this(builder, true);
    }

    private Service(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "vespa-services.service[] must be initialized: " + builder.__uninitialized);

      configId = (builder.configId == null) ?
          new StringNode() : new StringNode(builder.configId);
      name = (builder.name == null) ?
          new StringNode("") : new StringNode(builder.name);
      port = (builder.port == null) ?
          new IntegerNode(-1) : new IntegerNode(builder.port);
      dimension = Dimension.createVector(builder.dimension);
    }

    /**
     * @return vespa-services.service[].configId
     */
    public String configId() {
      return configId.value();
    }

    /**
     * @return vespa-services.service[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return vespa-services.service[].port
     */
    public int port() {
      return port.value();
    }

    /**
     * @return vespa-services.service[].dimension[]
     */
    public List<Dimension> dimension() {
      return dimension;
    }

    /**
     * @param i the index of the value to return
     * @return vespa-services.service[].dimension[]
     */
    public Dimension dimension(int i) {
      return dimension.get(i);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Service newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("service");
      return changes;
    }

    private static InnerNodeVector<Service> createVector(List<Builder> builders) {
        List<Service> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Service(b));
        }
        return new InnerNodeVector<Service>(elems);
    }

    /**
     * This class represents vespa-services.service[].dimension[]
     */
    public final static class Dimension extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "key",
          "value"
          ));

        private String key = null;
        private String value = null;

        public Builder() { }

        public Builder(Dimension config) {
          key(config.key());
          value(config.value());
        }

        private Builder override(Builder __superior) {
          if (__superior.key != null)
            key(__superior.key);
          if (__superior.value != null)
            value(__superior.value);
          return this;
        }

        public Builder key(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          key = __value;
          __uninitialized.remove("key");
          return this;
        }


        public Builder value(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          value = __value;
          __uninitialized.remove("value");
          return this;
        }


        public Dimension build() {
          return new Dimension(this);
        }

      }

      private final StringNode key;
      private final StringNode value;

      public Dimension(Builder builder) {
        this(builder, true);
      }

      private Dimension(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "vespa-services.service[].dimension[] must be initialized: " + builder.__uninitialized);

        key = (builder.key == null) ?
            new StringNode() : new StringNode(builder.key);
        value = (builder.value == null) ?
            new StringNode() : new StringNode(builder.value);
      }

      /**
       * @return vespa-services.service[].dimension[].key
       */
      public String key() {
        return key.value();
      }

      /**
       * @return vespa-services.service[].dimension[].value
       */
      public String value() {
        return value.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Dimension newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("dimension");
        return changes;
      }

      private static InnerNodeVector<Dimension> createVector(List<Builder> builders) {
          List<Dimension> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Dimension(b));
          }
          return new InnerNodeVector<Dimension>(elems);
      }
    }
  }

}
