// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package ai.vespa.metricsproxy.metric.dimensions;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of node-dimensions
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class NodeDimensionsConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "ddefb2a565ec67b60056bd1bd691def6";
  public final static String CONFIG_DEF_NAME = "node-dimensions";
  public final static String CONFIG_DEF_NAMESPACE = "ai.vespa.metricsproxy.metric.dimensions";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "package=ai.vespa.metricsproxy.metric.dimensions",
    "dimensions{} string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public Map<String, String> dimensions = new LinkedHashMap<>();

    public Builder() { }

    public Builder(NodeDimensionsConfig config) {
      dimensions(config.dimensions());
    }

    private Builder override(Builder __superior) {
      dimensions(__superior.dimensions);
      return this;
    }

    public Builder dimensions(String __key, String __value) {
      dimensions.put(__key, __value);
      return this;
    }

    public Builder dimensions(Map<String, String> __values) {
      dimensions.putAll(__values);
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public NodeDimensionsConfig build() {
      return new NodeDimensionsConfig(this);
    }

  }

  // Dimensions based on node properties
  private final Map<String, StringNode> dimensions;

  public NodeDimensionsConfig(Builder builder) {
    this(builder, true);
  }

  private NodeDimensionsConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "node-dimensions must be initialized: " + builder.__uninitialized);

    dimensions = LeafNodeMaps.asNodeMap(builder.dimensions, new StringNode());
  }

  /**
   * @return node-dimensions.dimensions{}
   */
  public Map<String, String> dimensions() {
    return LeafNodeMaps.asValueMap(dimensions);
  }

  /**
   * @param key the key of the value to return
   * @return node-dimensions.dimensions{}
   */
  public String dimensions(String key) {
    return dimensions.get(key).value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(NodeDimensionsConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("node-dimensions");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
