// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package ai.vespa.metricsproxy.http.metrics;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of node-info
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class NodeInfoConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "956ef8ac5275d7d21807356d9a87cc21";
  public final static String CONFIG_DEF_NAME = "node-info";
  public final static String CONFIG_DEF_NAMESPACE = "ai.vespa.metricsproxy.http.metrics";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "package=ai.vespa.metricsproxy.http.metrics",
    "role string",
    "hostname string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>(List.of(
      "role",
      "hostname"
      ));

    private String role = null;
    private String hostname = null;

    public Builder() { }

    public Builder(NodeInfoConfig config) {
      role(config.role());
      hostname(config.hostname());
    }

    private Builder override(Builder __superior) {
      if (__superior.role != null)
        role(__superior.role);
      if (__superior.hostname != null)
        hostname(__superior.hostname);
      return this;
    }

    public Builder role(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      role = __value;
      __uninitialized.remove("role");
      return this;
    }


    public Builder hostname(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      hostname = __value;
      __uninitialized.remove("hostname");
      return this;
    }


    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public NodeInfoConfig build() {
      return new NodeInfoConfig(this);
    }

  }

  private final StringNode role;
  private final StringNode hostname;

  public NodeInfoConfig(Builder builder) {
    this(builder, true);
  }

  private NodeInfoConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "node-info must be initialized: " + builder.__uninitialized);

    role = (builder.role == null) ?
        new StringNode() : new StringNode(builder.role);
    hostname = (builder.hostname == null) ?
        new StringNode() : new StringNode(builder.hostname);
  }

  /**
   * @return node-info.role
   */
  public String role() {
    return role.value();
  }

  /**
   * @return node-info.hostname
   */
  public String hostname() {
    return hostname.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(NodeInfoConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("node-info");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
