// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package ai.vespa.metricsproxy.http.application;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of metrics-nodes
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class MetricsNodesConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "c19dfc9855390a21b7f8c6128b89add0";
  public final static String CONFIG_DEF_NAME = "metrics-nodes";
  public final static String CONFIG_DEF_NAMESPACE = "ai.vespa.metricsproxy.http.application";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "package=ai.vespa.metricsproxy.http.application",
    "node[].nodeId string default=\"\"",
    "node[].hostname string",
    "node[].role string",
    "node[].metricsPort int",
    "node[].metricsPath string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Node.Builder> node = new ArrayList<>();

    public Builder() { }

    public Builder(MetricsNodesConfig config) {
      for (Node n : config.node()) {
        node(new Node.Builder(n));
      }
    }

    private Builder override(Builder __superior) {
      if (!__superior.node.isEmpty())
        node.addAll(__superior.node);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Node builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder node(Node.Builder __builder) {
      node.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder node(java.util.function.Consumer<Node.Builder> __func) {
      Node.Builder __inner = new Node.Builder();
      __func.accept(__inner);
      node.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Node builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder node(List<Node.Builder> __builders) {
      node = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public MetricsNodesConfig build() {
      return new MetricsNodesConfig(this);
    }

  }

  private final InnerNodeVector<Node> node;

  public MetricsNodesConfig(Builder builder) {
    this(builder, true);
  }

  private MetricsNodesConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "metrics-nodes must be initialized: " + builder.__uninitialized);

    node = Node.createVector(builder.node);
  }

  /**
   * @return metrics-nodes.node[]
   */
  public List<Node> node() {
    return node;
  }

  /**
   * @param i the index of the value to return
   * @return metrics-nodes.node[]
   */
  public Node node(int i) {
    return node.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(MetricsNodesConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("metrics-nodes");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents metrics-nodes.node[]
   */
  public final static class Node extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "hostname",
        "role",
        "metricsPort",
        "metricsPath"
        ));

      private String nodeId = null;
      private String hostname = null;
      private String role = null;
      private Integer metricsPort = null;
      private String metricsPath = null;

      public Builder() { }

      public Builder(Node config) {
        nodeId(config.nodeId());
        hostname(config.hostname());
        role(config.role());
        metricsPort(config.metricsPort());
        metricsPath(config.metricsPath());
      }

      private Builder override(Builder __superior) {
        if (__superior.nodeId != null)
          nodeId(__superior.nodeId);
        if (__superior.hostname != null)
          hostname(__superior.hostname);
        if (__superior.role != null)
          role(__superior.role);
        if (__superior.metricsPort != null)
          metricsPort(__superior.metricsPort);
        if (__superior.metricsPath != null)
          metricsPath(__superior.metricsPath);
        return this;
      }

      public Builder nodeId(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        nodeId = __value;
        return this;
      }


      public Builder hostname(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        hostname = __value;
        __uninitialized.remove("hostname");
        return this;
      }


      public Builder role(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        role = __value;
        __uninitialized.remove("role");
        return this;
      }


      public Builder metricsPort(int __value) {
        metricsPort = __value;
        __uninitialized.remove("metricsPort");
        return this;
      }

      private Builder metricsPort(String __value) {
        return metricsPort(Integer.valueOf(__value));
      }

      public Builder metricsPath(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        metricsPath = __value;
        __uninitialized.remove("metricsPath");
        return this;
      }


      public Node build() {
        return new Node(this);
      }

    }

    // TODO: remove, unused
    private final StringNode nodeId;
    private final StringNode hostname;
    private final StringNode role;
    private final IntegerNode metricsPort;
    private final StringNode metricsPath;

    public Node(Builder builder) {
      this(builder, true);
    }

    private Node(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "metrics-nodes.node[] must be initialized: " + builder.__uninitialized);

      nodeId = (builder.nodeId == null) ?
          new StringNode("") : new StringNode(builder.nodeId);
      hostname = (builder.hostname == null) ?
          new StringNode() : new StringNode(builder.hostname);
      role = (builder.role == null) ?
          new StringNode() : new StringNode(builder.role);
      metricsPort = (builder.metricsPort == null) ?
          new IntegerNode() : new IntegerNode(builder.metricsPort);
      metricsPath = (builder.metricsPath == null) ?
          new StringNode() : new StringNode(builder.metricsPath);
    }

    /**
     * @return metrics-nodes.node[].nodeId
     */
    public String nodeId() {
      return nodeId.value();
    }

    /**
     * @return metrics-nodes.node[].hostname
     */
    public String hostname() {
      return hostname.value();
    }

    /**
     * @return metrics-nodes.node[].role
     */
    public String role() {
      return role.value();
    }

    /**
     * @return metrics-nodes.node[].metricsPort
     */
    public int metricsPort() {
      return metricsPort.value();
    }

    /**
     * @return metrics-nodes.node[].metricsPath
     */
    public String metricsPath() {
      return metricsPath.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Node newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("node");
      return changes;
    }

    private static InnerNodeVector<Node> createVector(List<Builder> builders) {
        List<Node> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Node(b));
        }
        return new InnerNodeVector<Node>(elems);
    }
  }

}
