// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package ai.vespa.metricsproxy.core;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of monitoring
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class MonitoringConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "9c855580475bf4ef321a0c444ac39b23";
  public final static String CONFIG_DEF_NAME = "monitoring";
  public final static String CONFIG_DEF_NAMESPACE = "ai.vespa.metricsproxy.core";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "package=ai.vespa.metricsproxy.core",
    "intervalMinutes int default=1",
    "systemName string default=vespa"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Integer intervalMinutes = null;
    private String systemName = null;

    public Builder() { }

    public Builder(MonitoringConfig config) {
      intervalMinutes(config.intervalMinutes());
      systemName(config.systemName());
    }

    private Builder override(Builder __superior) {
      if (__superior.intervalMinutes != null)
        intervalMinutes(__superior.intervalMinutes);
      if (__superior.systemName != null)
        systemName(__superior.systemName);
      return this;
    }

    public Builder intervalMinutes(int __value) {
      intervalMinutes = __value;
      return this;
    }

    private Builder intervalMinutes(String __value) {
      return intervalMinutes(Integer.valueOf(__value));
    }

    public Builder systemName(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      systemName = __value;
      return this;
    }


    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public MonitoringConfig build() {
      return new MonitoringConfig(this);
    }

  }

  // The rate at which metrics are passed to the monitoring system. Currently (Apr 2019) only used by SystemPoller.
  private final IntegerNode intervalMinutes;
  // The name used for this application in the monitoring system
  private final StringNode systemName;

  public MonitoringConfig(Builder builder) {
    this(builder, true);
  }

  private MonitoringConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "monitoring must be initialized: " + builder.__uninitialized);

    intervalMinutes = (builder.intervalMinutes == null) ?
        new IntegerNode(1) : new IntegerNode(builder.intervalMinutes);
    systemName = (builder.systemName == null) ?
        new StringNode("vespa") : new StringNode(builder.systemName);
  }

  /**
   * @return monitoring.intervalMinutes
   */
  public int intervalMinutes() {
    return intervalMinutes.value();
  }

  /**
   * @return monitoring.systemName
   */
  public String systemName() {
    return systemName.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(MonitoringConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("monitoring");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
