// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package ai.vespa.metricsproxy.core;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of consumers
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class ConsumersConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "feca00d6233e1b476872da7a31e42323";
  public final static String CONFIG_DEF_NAME = "consumers";
  public final static String CONFIG_DEF_NAMESPACE = "ai.vespa.metricsproxy.core";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "package=ai.vespa.metricsproxy.core",
    "consumer[].name string default=\"\"",
    "consumer[].metric[].name string",
    "consumer[].metric[].description string default=\"\"",
    "consumer[].metric[].outputname string",
    "consumer[].metric[].dimension[].key string",
    "consumer[].metric[].dimension[].value string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Consumer.Builder> consumer = new ArrayList<>();

    public Builder() { }

    public Builder(ConsumersConfig config) {
      for (Consumer c : config.consumer()) {
        consumer(new Consumer.Builder(c));
      }
    }

    private Builder override(Builder __superior) {
      if (!__superior.consumer.isEmpty())
        consumer.addAll(__superior.consumer);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Consumer builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder consumer(Consumer.Builder __builder) {
      consumer.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder consumer(java.util.function.Consumer<Consumer.Builder> __func) {
      Consumer.Builder __inner = new Consumer.Builder();
      __func.accept(__inner);
      consumer.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Consumer builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder consumer(List<Consumer.Builder> __builders) {
      consumer = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public ConsumersConfig build() {
      return new ConsumersConfig(this);
    }

  }

  private final InnerNodeVector<Consumer> consumer;

  public ConsumersConfig(Builder builder) {
    this(builder, true);
  }

  private ConsumersConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "consumers must be initialized: " + builder.__uninitialized);

    consumer = Consumer.createVector(builder.consumer);
  }

  /**
   * @return consumers.consumer[]
   */
  public List<Consumer> consumer() {
    return consumer;
  }

  /**
   * @param i the index of the value to return
   * @return consumers.consumer[]
   */
  public Consumer consumer(int i) {
    return consumer.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(ConsumersConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("consumers");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents consumers.consumer[]
   */
  public final static class Consumer extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private String name = null;
      public List<Metric.Builder> metric = new ArrayList<>();

      public Builder() { }

      public Builder(Consumer config) {
        name(config.name());
        for (Metric m : config.metric()) {
          metric(new Metric.Builder(m));
        }
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (!__superior.metric.isEmpty())
          metric.addAll(__superior.metric);
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        return this;
      }


      /**
       * Add the given builder to this builder's list of Metric builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder metric(Metric.Builder __builder) {
        metric.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder metric(java.util.function.Consumer<Metric.Builder> __func) {
        Metric.Builder __inner = new Metric.Builder();
        __func.accept(__inner);
        metric.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Metric builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder metric(List<Metric.Builder> __builders) {
        metric = __builders;
        return this;
      }

      public Consumer build() {
        return new Consumer(this);
      }

    }

    // Consumers with metric definitions
    private final StringNode name;
    private final InnerNodeVector<Metric> metric;

    public Consumer(Builder builder) {
      this(builder, true);
    }

    private Consumer(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "consumers.consumer[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode("") : new StringNode(builder.name);
      metric = Metric.createVector(builder.metric);
    }

    /**
     * @return consumers.consumer[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return consumers.consumer[].metric[]
     */
    public List<Metric> metric() {
      return metric;
    }

    /**
     * @param i the index of the value to return
     * @return consumers.consumer[].metric[]
     */
    public Metric metric(int i) {
      return metric.get(i);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Consumer newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("consumer");
      return changes;
    }

    private static InnerNodeVector<Consumer> createVector(List<Builder> builders) {
        List<Consumer> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Consumer(b));
        }
        return new InnerNodeVector<Consumer>(elems);
    }

    /**
     * This class represents consumers.consumer[].metric[]
     */
    public final static class Metric extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "name",
          "outputname"
          ));

        private String name = null;
        private String description = null;
        private String outputname = null;
        public List<Dimension.Builder> dimension = new ArrayList<>();

        public Builder() { }

        public Builder(Metric config) {
          name(config.name());
          description(config.description());
          outputname(config.outputname());
          for (Dimension d : config.dimension()) {
            dimension(new Dimension.Builder(d));
          }
        }

        private Builder override(Builder __superior) {
          if (__superior.name != null)
            name(__superior.name);
          if (__superior.description != null)
            description(__superior.description);
          if (__superior.outputname != null)
            outputname(__superior.outputname);
          if (!__superior.dimension.isEmpty())
            dimension.addAll(__superior.dimension);
          return this;
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Builder description(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          description = __value;
          return this;
        }


        public Builder outputname(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          outputname = __value;
          __uninitialized.remove("outputname");
          return this;
        }


        /**
         * Add the given builder to this builder's list of Dimension builders
         * @param __builder a builder
         * @return this builder
         */
        public Builder dimension(Dimension.Builder __builder) {
          dimension.add(__builder);
          return this;
        }

        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder dimension(java.util.function.Consumer<Dimension.Builder> __func) {
          Dimension.Builder __inner = new Dimension.Builder();
          __func.accept(__inner);
          dimension.add(__inner);
          return this;
        }

        /**
         * Set the given list as this builder's list of Dimension builders
         * @param __builders a list of builders
         * @return this builder
         */
        public Builder dimension(List<Dimension.Builder> __builders) {
          dimension = __builders;
          return this;
        }

        public Metric build() {
          return new Metric(this);
        }

      }

      private final StringNode name;
      private final StringNode description;
      private final StringNode outputname;
      private final InnerNodeVector<Dimension> dimension;

      public Metric(Builder builder) {
        this(builder, true);
      }

      private Metric(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "consumers.consumer[].metric[] must be initialized: " + builder.__uninitialized);

        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
        description = (builder.description == null) ?
            new StringNode("") : new StringNode(builder.description);
        outputname = (builder.outputname == null) ?
            new StringNode() : new StringNode(builder.outputname);
        dimension = Dimension.createVector(builder.dimension);
      }

      /**
       * @return consumers.consumer[].metric[].name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return consumers.consumer[].metric[].description
       */
      public String description() {
        return description.value();
      }

      /**
       * @return consumers.consumer[].metric[].outputname
       */
      public String outputname() {
        return outputname.value();
      }

      /**
       * @return consumers.consumer[].metric[].dimension[]
       */
      public List<Dimension> dimension() {
        return dimension;
      }

      /**
       * @param i the index of the value to return
       * @return consumers.consumer[].metric[].dimension[]
       */
      public Dimension dimension(int i) {
        return dimension.get(i);
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Metric newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("metric");
        return changes;
      }

      private static InnerNodeVector<Metric> createVector(List<Builder> builders) {
          List<Metric> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Metric(b));
          }
          return new InnerNodeVector<Metric>(elems);
      }

      /**
       * This class represents consumers.consumer[].metric[].dimension[]
       */
      public final static class Dimension extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>(List.of(
            "key",
            "value"
            ));

          private String key = null;
          private String value = null;

          public Builder() { }

          public Builder(Dimension config) {
            key(config.key());
            value(config.value());
          }

          private Builder override(Builder __superior) {
            if (__superior.key != null)
              key(__superior.key);
            if (__superior.value != null)
              value(__superior.value);
            return this;
          }

          public Builder key(String __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            key = __value;
            __uninitialized.remove("key");
            return this;
          }


          public Builder value(String __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            value = __value;
            __uninitialized.remove("value");
            return this;
          }


          public Dimension build() {
            return new Dimension(this);
          }

        }

        private final StringNode key;
        private final StringNode value;

        public Dimension(Builder builder) {
          this(builder, true);
        }

        private Dimension(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "consumers.consumer[].metric[].dimension[] must be initialized: " + builder.__uninitialized);

          key = (builder.key == null) ?
              new StringNode() : new StringNode(builder.key);
          value = (builder.value == null) ?
              new StringNode() : new StringNode(builder.value);
        }

        /**
         * @return consumers.consumer[].metric[].dimension[].key
         */
        public String key() {
          return key.value();
        }

        /**
         * @return consumers.consumer[].metric[].dimension[].value
         */
        public String value() {
          return value.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Dimension newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("dimension");
          return changes;
        }

        private static InnerNodeVector<Dimension> createVector(List<Builder> builders) {
            List<Dimension> elems = new ArrayList<>();
            for (Builder b : builders) {
                elems.add(new Dimension(b));
            }
            return new InnerNodeVector<Dimension>(elems);
        }
      }
    }
  }

}
