/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.metric.model;

import ai.vespa.metricsproxy.metric.Metric;
import ai.vespa.metricsproxy.metric.model.ConsumerId;
import ai.vespa.metricsproxy.metric.model.DimensionId;
import ai.vespa.metricsproxy.metric.model.MetricId;
import ai.vespa.metricsproxy.metric.model.ServiceId;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MetricsPacket {
    private final int statusCode;
    private final String statusMessage;
    private final ServiceId service;
    private final Instant timestamp;
    private final Map<MetricId, Number> metrics;
    private final Map<DimensionId, String> dimensions;
    private final Set<ConsumerId> consumers;

    private MetricsPacket(int statusCode, String statusMessage, Instant timestamp, ServiceId service, Map<MetricId, Number> metrics, Map<DimensionId, String> dimensions, Set<ConsumerId> consumers) {
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.timestamp = timestamp;
        this.service = service;
        this.metrics = Collections.unmodifiableMap(metrics);
        this.dimensions = Collections.unmodifiableMap(dimensions);
        this.consumers = Set.copyOf(consumers);
    }

    public Map<MetricId, Number> metrics() {
        return this.metrics;
    }

    public Map<DimensionId, String> dimensions() {
        return this.dimensions;
    }

    public Set<ConsumerId> consumers() {
        return this.consumers;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public ServiceId service() {
        return this.service;
    }

    public int statusCode() {
        return this.statusCode;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public String toString() {
        return "MetricsPacket{statusCode=" + this.statusCode + ", statusMessage='" + this.statusMessage + "', timestamp=" + String.valueOf(this.timestamp) + ", service=" + this.service.id + ", metrics=" + MetricsPacket.idMapToString(this.metrics, id -> id.id) + ", dimensions=" + MetricsPacket.idMapToString(this.dimensions, id -> id.id) + ", consumers=" + this.consumers.stream().map(id -> id.id).collect(Collectors.joining(",", "[", "]")) + "}";
    }

    private static <K, V> String idMapToString(Map<K, V> map, Function<K, String> idMapper) {
        return map.entrySet().stream().map(entry -> (String)idMapper.apply(entry.getKey()) + "=" + String.valueOf(entry.getValue())).collect(Collectors.joining(",", "{", "}"));
    }

    public static class Builder {
        private ServiceId service;
        private int statusCode = 0;
        private String statusMessage = "";
        private Instant timestamp = Instant.EPOCH;
        private Map<MetricId, Number> metrics = new LinkedHashMap<MetricId, Number>();
        private final Map<DimensionId, String> dimensions = new LinkedHashMap<DimensionId, String>();
        private Set<ConsumerId> consumers = Set.of();

        public Builder(ServiceId service) {
            Objects.requireNonNull(service, "Service cannot be null.");
            this.service = service;
        }

        public Builder service(ServiceId service) {
            if (service == null) {
                throw new IllegalArgumentException("Service cannot be null.");
            }
            this.service = service;
            return this;
        }

        public Builder statusCode(Integer statusCode) {
            if (statusCode != null) {
                this.statusCode = statusCode;
            }
            return this;
        }

        public Builder statusMessage(String statusMessage) {
            if (statusMessage != null) {
                this.statusMessage = statusMessage;
            }
            return this;
        }

        public Builder timestamp(Instant timestamp) {
            if (timestamp != null) {
                this.timestamp = timestamp;
            }
            return this;
        }

        public Builder putMetrics(Collection<Metric> extraMetrics) {
            if (extraMetrics != null) {
                extraMetrics.forEach(metric -> this.metrics.put(metric.getName(), metric.getValue()));
            }
            return this;
        }

        public Builder putMetric(MetricId id, Number value) {
            this.metrics.put(id, value);
            return this;
        }

        public Builder retainMetrics(Set<MetricId> idsToRetain) {
            this.metrics.keySet().retainAll(idsToRetain);
            return this;
        }

        public Builder applyOutputNames(Map<MetricId, List<MetricId>> outputNamesById) {
            LinkedHashMap<MetricId, Number> newMetrics = new LinkedHashMap<MetricId, Number>();
            outputNamesById.forEach((id, outputNames) -> {
                if (this.metrics.containsKey(id)) {
                    outputNames.forEach(outputName -> newMetrics.put((MetricId)outputName, this.metrics.get(id)));
                }
            });
            this.metrics = newMetrics;
            return this;
        }

        public Builder putDimension(DimensionId id, String value) {
            this.dimensions.put(id, value);
            return this;
        }

        public Builder putDimensions(Map<DimensionId, String> extraDimensions) {
            if (extraDimensions != null) {
                this.dimensions.putAll(extraDimensions);
            }
            return this;
        }

        public Builder putDimensionsIfAbsent(Map<DimensionId, String> extraDimensions) {
            if (extraDimensions != null) {
                extraDimensions.forEach(this.dimensions::putIfAbsent);
            }
            return this;
        }

        public Set<DimensionId> getDimensionIds() {
            return new LinkedHashSet<DimensionId>(this.dimensions.keySet());
        }

        public String getDimensionValue(DimensionId id) {
            return this.dimensions.get(id);
        }

        public Builder retainDimensions(Collection<DimensionId> idsToRetain) {
            this.dimensions.keySet().retainAll(idsToRetain);
            return this;
        }

        public Builder addConsumers(Set<ConsumerId> extraConsumers) {
            if (extraConsumers != null && !extraConsumers.isEmpty()) {
                if (this.consumers.isEmpty()) {
                    if (extraConsumers.size() == 1) {
                        this.consumers = Set.of(extraConsumers.iterator().next());
                        return this;
                    }
                    this.consumers = new LinkedHashSet<ConsumerId>(extraConsumers.size());
                } else if (this.consumers.size() == 1) {
                    LinkedHashSet<ConsumerId> copy = new LinkedHashSet<ConsumerId>(extraConsumers.size() + 1);
                    copy.addAll(this.consumers);
                    this.consumers = copy;
                }
                this.consumers.addAll(extraConsumers);
            }
            return this;
        }

        public boolean hasConsumer(ConsumerId id) {
            return this.consumers.contains(id);
        }

        public MetricsPacket build() {
            return new MetricsPacket(this.statusCode, this.statusMessage, this.timestamp, this.service, this.metrics, this.dimensions, this.consumers);
        }

        public boolean hasMetrics() {
            return !this.metrics.isEmpty();
        }

        public Instant getTimestamp() {
            return this.timestamp;
        }
    }
}

