/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.metric;

import ai.vespa.metricsproxy.metric.Metric;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Metrics {
    private final List<Metric> metrics = new ArrayList<Metric>();
    private Instant timestamp;
    private boolean isFrozen = false;

    public Metrics() {
        this(Instant.now());
    }

    public Metrics(Instant timestamp) {
        this.timestamp = timestamp;
    }

    private void ensureNotFrozen() {
        if (this.isFrozen) {
            throw new IllegalStateException("Frozen Metrics cannot be modified!");
        }
    }

    public Instant getTimeStamp() {
        return this.timestamp;
    }

    public void setTimeStamp(Instant timestamp) {
        this.ensureNotFrozen();
        this.timestamp = timestamp;
    }

    public void add(Metric m) {
        this.ensureNotFrozen();
        this.timestamp = m.getTimeStamp();
        this.metrics.add(m);
    }

    public int size() {
        return this.metrics.size();
    }

    public List<Metric> list() {
        this.isFrozen = true;
        return Collections.unmodifiableList(this.metrics);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Metric m : this.metrics) {
            sb.append(m.getName()).append(":").append(m.getValue()).append("\n");
        }
        return sb.toString();
    }
}

