/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.metric;

import ai.vespa.metricsproxy.service.VespaService;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class MetricsFormatter {
    private final boolean includeServiceName;
    private final boolean isSystemMetric;
    private final DecimalFormat df = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.ENGLISH));

    public MetricsFormatter(boolean includeServiceName, boolean isSystemMetric) {
        this.includeServiceName = includeServiceName;
        this.isSystemMetric = isSystemMetric;
    }

    public String format(VespaService service, String name, Number value) {
        StringBuilder sb = new StringBuilder();
        if (this.includeServiceName) {
            sb.append(service.getServiceName()).append(".");
        }
        if (this.isSystemMetric) {
            sb.append(MetricsFormatter.toSystemServiceId(service.getConfigId()));
        } else {
            sb.append(MetricsFormatter.toServiceId(service.getConfigId()));
        }
        sb.append(".").append(MetricsFormatter.formatMetricName(name)).append("=");
        if (value instanceof Double) {
            sb.append(this.df.format(value.doubleValue()));
        } else {
            sb.append(value.toString());
        }
        return sb.toString();
    }

    private static String formatMetricName(String name) {
        name = name.replaceAll("\"", "");
        name = name.replaceAll("\\.", "_");
        return name;
    }

    private static String toServiceId(String configId) {
        return "'" + configId.replace("/", ".") + "'";
    }

    private static String toSystemServiceId(String configId) {
        Object name = configId.replace("/", ".");
        name = ((String)name).replaceFirst("\\.", ".'") + "'";
        return name;
    }
}

