/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.http.application;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class MetricsNodesConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "c19dfc9855390a21b7f8c6128b89add0";
    public static final String CONFIG_DEF_NAME = "metrics-nodes";
    public static final String CONFIG_DEF_NAMESPACE = "ai.vespa.metricsproxy.http.application";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"package=ai.vespa.metricsproxy.http.application", "node[].nodeId string default=\"\"", "node[].hostname string", "node[].role string", "node[].metricsPort int", "node[].metricsPath string"};
    private final InnerNodeVector<Node> node;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public MetricsNodesConfig(Builder builder) {
        this(builder, true);
    }

    private MetricsNodesConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for metrics-nodes must be initialized: " + String.valueOf(builder.__uninitialized));
        }
        this.node = Node.createVector(builder.node);
    }

    public List<Node> node() {
        return this.node;
    }

    public Node node(int i) {
        return (Node)((Object)this.node.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(MetricsNodesConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Node.Builder> node = new ArrayList<Node.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(MetricsNodesConfig config) {
            for (Node n : config.node()) {
                this.node(new Node.Builder(n));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.node.isEmpty()) {
                this.node.addAll(__superior.node);
            }
            return this;
        }

        public Builder node(Node.Builder __builder) {
            this.node.add(__builder);
            return this;
        }

        public Builder node(Consumer<Node.Builder> __func) {
            Node.Builder __inner = new Node.Builder();
            __func.accept(__inner);
            this.node.add(__inner);
            return this;
        }

        public Builder node(List<Node.Builder> __builders) {
            this.node = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return MetricsNodesConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return MetricsNodesConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return MetricsNodesConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public MetricsNodesConfig build() {
            return new MetricsNodesConfig(this);
        }
    }

    public static final class Node
    extends InnerNode {
        private final StringNode nodeId;
        private final StringNode hostname;
        private final StringNode role;
        private final IntegerNode metricsPort;
        private final StringNode metricsPath;

        public Node(Builder builder) {
            this(builder, true);
        }

        private Node(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for metrics-nodes.node[] must be initialized: " + String.valueOf(builder.__uninitialized));
            }
            this.nodeId = builder.nodeId == null ? new StringNode("") : new StringNode(builder.nodeId);
            this.hostname = builder.hostname == null ? new StringNode() : new StringNode(builder.hostname);
            this.role = builder.role == null ? new StringNode() : new StringNode(builder.role);
            this.metricsPort = builder.metricsPort == null ? new IntegerNode() : new IntegerNode(builder.metricsPort.intValue());
            this.metricsPath = builder.metricsPath == null ? new StringNode() : new StringNode(builder.metricsPath);
        }

        public String nodeId() {
            return this.nodeId.value();
        }

        public String hostname() {
            return this.hostname.value();
        }

        public String role() {
            return this.role.value();
        }

        public int metricsPort() {
            return this.metricsPort.value();
        }

        public String metricsPath() {
            return this.metricsPath.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Node newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("node");
            return changes;
        }

        private static InnerNodeVector<Node> createVector(List<Builder> builders) {
            ArrayList<Node> elems = new ArrayList<Node>();
            for (Builder b : builders) {
                elems.add(new Node(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(List.of("hostname", "role", "metricsPort", "metricsPath"));
            private String nodeId = null;
            private String hostname = null;
            private String role = null;
            private Integer metricsPort = null;
            private String metricsPath = null;

            public Builder() {
            }

            public Builder(Node config) {
                this.nodeId(config.nodeId());
                this.hostname(config.hostname());
                this.role(config.role());
                this.metricsPort(config.metricsPort());
                this.metricsPath(config.metricsPath());
            }

            private Builder override(Builder __superior) {
                if (__superior.nodeId != null) {
                    this.nodeId(__superior.nodeId);
                }
                if (__superior.hostname != null) {
                    this.hostname(__superior.hostname);
                }
                if (__superior.role != null) {
                    this.role(__superior.role);
                }
                if (__superior.metricsPort != null) {
                    this.metricsPort(__superior.metricsPort);
                }
                if (__superior.metricsPath != null) {
                    this.metricsPath(__superior.metricsPath);
                }
                return this;
            }

            public Builder nodeId(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.nodeId = __value;
                return this;
            }

            public Builder hostname(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.hostname = __value;
                this.__uninitialized.remove("hostname");
                return this;
            }

            public Builder role(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.role = __value;
                this.__uninitialized.remove("role");
                return this;
            }

            public Builder metricsPort(int __value) {
                this.metricsPort = __value;
                this.__uninitialized.remove("metricsPort");
                return this;
            }

            private Builder metricsPort(String __value) {
                return this.metricsPort(Integer.valueOf(__value));
            }

            public Builder metricsPath(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.metricsPath = __value;
                this.__uninitialized.remove("metricsPath");
                return this;
            }

            public Node build() {
                return new Node(this);
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

