/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.metric;

import ai.vespa.metricsproxy.metric.model.StatusCode;

public class HealthMetric {
    private final String message;
    private final StatusCode status;
    private final boolean isAlive;

    private HealthMetric(StatusCode status, String message, boolean isAlive) {
        this.message = message;
        this.status = status;
        this.isAlive = isAlive;
    }

    public static HealthMetric get(String status, String message) {
        StatusCode statusCode;
        if (message == null) {
            message = "";
        }
        return new HealthMetric(statusCode, message, (statusCode = StatusCode.fromString(status)) == StatusCode.UP);
    }

    public static HealthMetric getDown(String message) {
        return new HealthMetric(StatusCode.DOWN, message, false);
    }

    public static HealthMetric getUnknown(String message) {
        return new HealthMetric(StatusCode.UNKNOWN, message, false);
    }

    public static HealthMetric getOk(String message) {
        return new HealthMetric(StatusCode.UP, message, true);
    }

    public String getMessage() {
        return this.message;
    }

    public StatusCode getStatus() {
        return this.status;
    }

    public boolean isOk() {
        return this.isAlive;
    }
}

