/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.network;

import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.Protocol;
import com.yahoo.messagebus.network.Network;
import com.yahoo.messagebus.network.NetworkOwner;
import com.yahoo.text.Utf8Array;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

public class NetworkMultiplexer
implements NetworkOwner {
    private static final Logger log = Logger.getLogger(NetworkMultiplexer.class.getName());
    private final Network net;
    private final Deque<NetworkOwner> owners = new ConcurrentLinkedDeque<NetworkOwner>();
    private final Map<String, Deque<NetworkOwner>> sessions = new ConcurrentHashMap<String, Deque<NetworkOwner>>();
    private final AtomicBoolean disowned;

    private NetworkMultiplexer(Network net, boolean shared) {
        net.attach(this);
        this.net = net;
        this.disowned = new AtomicBoolean(!shared);
    }

    public static NetworkMultiplexer shared(Network net) {
        return new NetworkMultiplexer(net, true);
    }

    public static NetworkMultiplexer dedicated(Network net) {
        return new NetworkMultiplexer(net, false);
    }

    public void registerSession(String session, NetworkOwner owner, boolean broadcast) {
        this.sessions.compute(session, (name, owners) -> {
            if (owners == null) {
                owners = new ConcurrentLinkedDeque<NetworkOwner>();
                if (broadcast) {
                    this.net.registerSession(session);
                }
            } else if (owners.contains(owner)) {
                throw new IllegalArgumentException("Session '" + session + "' with owner '" + String.valueOf(owner) + "' already registered with " + String.valueOf(this));
            }
            owners.push(owner);
            return owners;
        });
    }

    public void unregisterSession(String session, NetworkOwner owner, boolean broadcast) {
        this.sessions.computeIfPresent(session, (name, owners) -> {
            if (owners.size() == 1 && owners.contains(owner)) {
                if (broadcast) {
                    this.net.unregisterSession(session);
                }
                return null;
            }
            owners.remove(owner);
            return owners;
        });
    }

    @Override
    public Protocol getProtocol(Utf8Array name) {
        Protocol protocol = null;
        for (NetworkOwner owner : this.owners) {
            protocol = owner.getProtocol(name) == null ? protocol : owner.getProtocol(name);
        }
        return protocol;
    }

    @Override
    public void deliverMessage(Message message, String session) {
        NetworkOwner owner = this.sessions.getOrDefault(session, this.owners).peek();
        if (owner == null) {
            log.warning(String.valueOf(this) + " received message '" + String.valueOf(message) + "' with no owners attached");
            message.discard();
        } else {
            owner.deliverMessage(message, session);
        }
    }

    public void attach(NetworkOwner owner) {
        if (this.owners.contains(owner)) {
            throw new IllegalArgumentException(String.valueOf(owner) + " is already attached to " + String.valueOf(this));
        }
        this.owners.add(owner);
    }

    public void detach(NetworkOwner owner) {
        if (!this.owners.remove(owner)) {
            throw new IllegalArgumentException(String.valueOf(owner) + " not attached to " + String.valueOf(this));
        }
        this.destroyIfOwnerless();
    }

    public void disown() {
        if (this.disowned.getAndSet(true)) {
            throw new IllegalStateException("Destroy called on a dedicated multiplexer--this automatically shuts down when detached from--or called multiple times on a shared multiplexer");
        }
        this.destroyIfOwnerless();
    }

    private void destroyIfOwnerless() {
        if (this.disowned.get() && this.owners.isEmpty()) {
            this.net.shutdown();
        }
    }

    public Network net() {
        return this.net;
    }

    public String toString() {
        return "network multiplexer with owners: " + String.valueOf(this.owners) + ", sessions: " + String.valueOf(this.sessions) + " and destructible: " + this.disowned.get();
    }
}

