/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.routing;

import com.yahoo.messagebus.routing.HopDirective;

public class TcpDirective
implements HopDirective {
    private final String host;
    private final int port;
    private final String session;

    public TcpDirective(String host, int port, String session) {
        this.host = host;
        this.port = port;
        this.session = session;
    }

    @Override
    public boolean matches(HopDirective dir) {
        if (!(dir instanceof TcpDirective)) {
            return false;
        }
        TcpDirective rhs = (TcpDirective)dir;
        return this.host.equals(rhs.host) && this.port == rhs.port && this.session.equals(rhs.session);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getSession() {
        return this.session;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TcpDirective)) {
            return false;
        }
        TcpDirective rhs = (TcpDirective)obj;
        if (!this.host.equals(rhs.host)) {
            return false;
        }
        if (this.port != rhs.port) {
            return false;
        }
        return this.session.equals(rhs.session);
    }

    public String toString() {
        return "tcp/" + this.host + ":" + this.port + "/" + this.session;
    }

    @Override
    public String toDebugString() {
        return "TcpDirective(host = '" + this.host + "', port = " + this.port + ", session = '" + this.session + "')";
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + this.port;
        result = 31 * result + (this.session != null ? this.session.hashCode() : 0);
        return result;
    }
}

