// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.messagebus;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of messagebus
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class MessagebusConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "04a33fc5c97314d4c98f3d743fbd25c4";
  public final static String CONFIG_DEF_NAME = "messagebus";
  public final static String CONFIG_DEF_NAMESPACE = "messagebus";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=messagebus",
    "routingtable[].protocol string",
    "routingtable[].hop[].name string",
    "routingtable[].hop[].selector string",
    "routingtable[].hop[].recipient[] string",
    "routingtable[].hop[].ignoreresult bool default=false",
    "routingtable[].route[].name string",
    "routingtable[].route[].hop[] string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Routingtable.Builder> routingtable = new ArrayList<>();

    public Builder() { }

    public Builder(MessagebusConfig config) {
      for (Routingtable r : config.routingtable()) {
        routingtable(new Routingtable.Builder(r));
      }
    }

    private Builder override(Builder __superior) {
      if (!__superior.routingtable.isEmpty())
        routingtable.addAll(__superior.routingtable);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Routingtable builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder routingtable(Routingtable.Builder __builder) {
      routingtable.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder routingtable(java.util.function.Consumer<Routingtable.Builder> __func) {
      Routingtable.Builder __inner = new Routingtable.Builder();
      __func.accept(__inner);
      routingtable.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Routingtable builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder routingtable(List<Routingtable.Builder> __builders) {
      routingtable = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public MessagebusConfig build() {
      return new MessagebusConfig(this);
    }

  }

  private final InnerNodeVector<Routingtable> routingtable;

  public MessagebusConfig(Builder builder) {
    this(builder, true);
  }

  private MessagebusConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "messagebus must be initialized: " + builder.__uninitialized);

    routingtable = Routingtable.createVector(builder.routingtable);
  }

  /**
   * @return messagebus.routingtable[]
   */
  public List<Routingtable> routingtable() {
    return routingtable;
  }

  /**
   * @param i the index of the value to return
   * @return messagebus.routingtable[]
   */
  public Routingtable routingtable(int i) {
    return routingtable.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(MessagebusConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("messagebus");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents messagebus.routingtable[]
   */
  public final static class Routingtable extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "protocol"
        ));

      private String protocol = null;
      public List<Hop.Builder> hop = new ArrayList<>();
      public List<Route.Builder> route = new ArrayList<>();

      public Builder() { }

      public Builder(Routingtable config) {
        protocol(config.protocol());
        for (Hop h : config.hop()) {
          hop(new Hop.Builder(h));
        }
        for (Route r : config.route()) {
          route(new Route.Builder(r));
        }
      }

      private Builder override(Builder __superior) {
        if (__superior.protocol != null)
          protocol(__superior.protocol);
        if (!__superior.hop.isEmpty())
          hop.addAll(__superior.hop);
        if (!__superior.route.isEmpty())
          route.addAll(__superior.route);
        return this;
      }

      public Builder protocol(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        protocol = __value;
        __uninitialized.remove("protocol");
        return this;
      }


      /**
       * Add the given builder to this builder's list of Hop builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder hop(Hop.Builder __builder) {
        hop.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder hop(java.util.function.Consumer<Hop.Builder> __func) {
        Hop.Builder __inner = new Hop.Builder();
        __func.accept(__inner);
        hop.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Hop builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder hop(List<Hop.Builder> __builders) {
        hop = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Route builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder route(Route.Builder __builder) {
        route.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder route(java.util.function.Consumer<Route.Builder> __func) {
        Route.Builder __inner = new Route.Builder();
        __func.accept(__inner);
        route.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Route builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder route(List<Route.Builder> __builders) {
        route = __builders;
        return this;
      }

      public Routingtable build() {
        return new Routingtable(this);
      }

    }

    // Name of the protocol that uses this routing table. All
    // instances of message bus must support all named protocols.
    private final StringNode protocol;
    private final InnerNodeVector<Hop> hop;
    private final InnerNodeVector<Route> route;

    public Routingtable(Builder builder) {
      this(builder, true);
    }

    private Routingtable(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "messagebus.routingtable[] must be initialized: " + builder.__uninitialized);

      protocol = (builder.protocol == null) ?
          new StringNode() : new StringNode(builder.protocol);
      hop = Hop.createVector(builder.hop);
      route = Route.createVector(builder.route);
    }

    /**
     * @return messagebus.routingtable[].protocol
     */
    public String protocol() {
      return protocol.value();
    }

    /**
     * @return messagebus.routingtable[].hop[]
     */
    public List<Hop> hop() {
      return hop;
    }

    /**
     * @param i the index of the value to return
     * @return messagebus.routingtable[].hop[]
     */
    public Hop hop(int i) {
      return hop.get(i);
    }

    /**
     * @return messagebus.routingtable[].route[]
     */
    public List<Route> route() {
      return route;
    }

    /**
     * @param i the index of the value to return
     * @return messagebus.routingtable[].route[]
     */
    public Route route(int i) {
      return route.get(i);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Routingtable newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("routingtable");
      return changes;
    }

    private static InnerNodeVector<Routingtable> createVector(List<Builder> builders) {
        List<Routingtable> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Routingtable(b));
        }
        return new InnerNodeVector<Routingtable>(elems);
    }

    /**
     * This class represents messagebus.routingtable[].hop[]
     */
    public final static class Hop extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "name",
          "selector"
          ));

        private String name = null;
        private String selector = null;
        public List<String> recipient = new ArrayList<>();
        private Boolean ignoreresult = null;

        public Builder() { }

        public Builder(Hop config) {
          name(config.name());
          selector(config.selector());
          recipient(config.recipient());
          ignoreresult(config.ignoreresult());
        }

        private Builder override(Builder __superior) {
          if (__superior.name != null)
            name(__superior.name);
          if (__superior.selector != null)
            selector(__superior.selector);
          if (!__superior.recipient.isEmpty())
            recipient.addAll(__superior.recipient);
          if (__superior.ignoreresult != null)
            ignoreresult(__superior.ignoreresult);
          return this;
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Builder selector(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          selector = __value;
          __uninitialized.remove("selector");
          return this;
        }


        public Builder recipient(String __value) {
          recipient.add(__value);
          return this;
        }

        public Builder recipient(Collection<String> __values) {
          recipient.addAll(__values);
          return this;
        }

        public Builder ignoreresult(boolean __value) {
          ignoreresult = __value;
          return this;
        }

        private Builder ignoreresult(String __value) {
          return ignoreresult(Boolean.valueOf(__value));
        }

        public Hop build() {
          return new Hop(this);
        }

      }

      // A protocol-unique name for a hop.
      private final StringNode name;
      // The selector string of a hop, this string typically contains
      // routing policy references on the form [policy-name:parameter].
      // The protocol for the routing table must support all named
      // policies.
      private final StringNode selector;
      // List of recipients for a hop. These strings may contain
      // wildcards to allow the network layer to choose any single
      // matching service.
      private final LeafNodeVector<String, StringNode> recipient;
      // Whether or not to ignore the result from this hop.
      private final BooleanNode ignoreresult;

      public Hop(Builder builder) {
        this(builder, true);
      }

      private Hop(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "messagebus.routingtable[].hop[] must be initialized: " + builder.__uninitialized);

        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
        selector = (builder.selector == null) ?
            new StringNode() : new StringNode(builder.selector);
        recipient = new LeafNodeVector<>(builder.recipient, new StringNode());
        ignoreresult = (builder.ignoreresult == null) ?
            new BooleanNode(false) : new BooleanNode(builder.ignoreresult);
      }

      /**
       * @return messagebus.routingtable[].hop[].name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return messagebus.routingtable[].hop[].selector
       */
      public String selector() {
        return selector.value();
      }

      /**
       * @return messagebus.routingtable[].hop[].recipient[]
       */
      public List<String> recipient() {
        return recipient.asList();
      }

      /**
       * @param i the index of the value to return
       * @return messagebus.routingtable[].hop[].recipient[]
       */
      public String recipient(int i) {
        return recipient.get(i).value();
      }

      /**
       * @return messagebus.routingtable[].hop[].ignoreresult
       */
      public boolean ignoreresult() {
        return ignoreresult.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Hop newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("hop");
        return changes;
      }

      private static InnerNodeVector<Hop> createVector(List<Builder> builders) {
          List<Hop> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Hop(b));
          }
          return new InnerNodeVector<Hop>(elems);
      }
    }

    /**
     * This class represents messagebus.routingtable[].route[]
     */
    public final static class Route extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "name"
          ));

        private String name = null;
        public List<String> hop = new ArrayList<>();

        public Builder() { }

        public Builder(Route config) {
          name(config.name());
          hop(config.hop());
        }

        private Builder override(Builder __superior) {
          if (__superior.name != null)
            name(__superior.name);
          if (!__superior.hop.isEmpty())
            hop.addAll(__superior.hop);
          return this;
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Builder hop(String __value) {
          hop.add(__value);
          return this;
        }

        public Builder hop(Collection<String> __values) {
          hop.addAll(__values);
          return this;
        }

        public Route build() {
          return new Route(this);
        }

      }

      // A protocol-unique name for a route.
      private final StringNode name;
      // An array of hop names that together make up the route.
      private final LeafNodeVector<String, StringNode> hop;

      public Route(Builder builder) {
        this(builder, true);
      }

      private Route(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "messagebus.routingtable[].route[] must be initialized: " + builder.__uninitialized);

        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
        hop = new LeafNodeVector<>(builder.hop, new StringNode());
      }

      /**
       * @return messagebus.routingtable[].route[].name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return messagebus.routingtable[].route[].hop[]
       */
      public List<String> hop() {
        return hop.asList();
      }

      /**
       * @param i the index of the value to return
       * @return messagebus.routingtable[].route[].hop[]
       */
      public String hop(int i) {
        return hop.get(i).value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Route newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("route");
        return changes;
      }

      private static InnerNodeVector<Route> createVector(List<Builder> builders) {
          List<Route> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Route(b));
          }
          return new InnerNodeVector<Route>(elems);
      }
    }
  }

}
