/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.routing;

import com.yahoo.messagebus.routing.ErrorDirective;
import com.yahoo.messagebus.routing.HopDirective;
import com.yahoo.messagebus.routing.Route;
import java.util.ArrayList;
import java.util.List;

public class Hop {
    private final List<HopDirective> selector = new ArrayList<HopDirective>();
    private boolean ignoreResult = false;
    private String cache = null;

    public Hop() {
    }

    public Hop(Hop hop) {
        this.selector.addAll(hop.selector);
        this.ignoreResult = hop.ignoreResult;
    }

    Hop(List<HopDirective> selector, boolean ignoreResult) {
        this.selector.addAll(selector);
        this.ignoreResult = ignoreResult;
    }

    public static Hop parse(String str) {
        Route route = Route.parse(str);
        if (route.getNumHops() > 1) {
            return new Hop().addDirective(new ErrorDirective("Failed to completely parse '" + str + "'."));
        }
        return route.getHop(0);
    }

    public boolean hasDirectives() {
        return !this.selector.isEmpty();
    }

    public int getNumDirectives() {
        return this.selector.size();
    }

    public HopDirective getDirective(int i) {
        return this.selector.get(i);
    }

    public Hop addDirective(HopDirective directive) {
        this.cache = null;
        this.selector.add(directive);
        return this;
    }

    public Hop setDirective(int i, HopDirective directive) {
        this.selector.set(i, directive);
        return this;
    }

    public HopDirective removeDirective(int i) {
        this.cache = null;
        return this.selector.remove(i);
    }

    public Hop clearDirectives() {
        this.cache = null;
        this.selector.clear();
        return this;
    }

    public boolean getIgnoreResult() {
        return this.ignoreResult;
    }

    public Hop setIgnoreResult(boolean ignoreResult) {
        this.ignoreResult = ignoreResult;
        return this;
    }

    public boolean matches(Hop hop) {
        if (hop == null || hop.getNumDirectives() != this.selector.size()) {
            return false;
        }
        for (int i = 0; i < hop.getNumDirectives(); ++i) {
            if (this.selector.get(i).matches(hop.getDirective(i))) continue;
            return false;
        }
        return true;
    }

    public String toDebugString() {
        StringBuilder ret = new StringBuilder("Hop(selector = { ");
        for (int i = 0; i < this.selector.size(); ++i) {
            ret.append(this.selector.get(i).toDebugString());
            if (i >= this.selector.size() - 1) continue;
            ret.append(", ");
        }
        ret.append(" }, ignoreResult = ").append(this.ignoreResult).append(")");
        return ret.toString();
    }

    public String toString() {
        return (this.ignoreResult ? "?" : "") + this.getServiceName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Hop)) {
            return false;
        }
        Hop rhs = (Hop)obj;
        if (this.selector.size() != rhs.selector.size()) {
            return false;
        }
        for (int i = 0; i < this.selector.size(); ++i) {
            if (this.selector.get(i).equals(rhs.selector.get(i))) continue;
            return false;
        }
        return true;
    }

    public String getServiceName() {
        if (this.cache == null) {
            this.cache = this.toString(0, this.selector.size());
        }
        return this.cache;
    }

    public String toString(int fromIncluding, int toNotIncluding) {
        StringBuilder ret = new StringBuilder();
        for (int i = fromIncluding; i < toNotIncluding; ++i) {
            ret.append(this.selector.get(i));
            if (i >= toNotIncluding - 1) continue;
            ret.append("/");
        }
        return ret.toString();
    }

    public String getPrefix(int toNotIncluding) {
        if (toNotIncluding > 0) {
            return this.toString(0, toNotIncluding) + "/";
        }
        return "";
    }

    public String getSuffix(int fromNotIncluding) {
        if (fromNotIncluding < this.selector.size() - 1) {
            return "/" + this.toString(fromNotIncluding + 1, this.selector.size());
        }
        return "";
    }

    public int hashCode() {
        int result = this.selector.hashCode();
        result = 31 * result + (this.ignoreResult ? 1 : 0);
        result = 31 * result + (this.cache != null ? this.cache.hashCode() : 0);
        return result;
    }
}

