/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.network.rpc;

import com.yahoo.concurrent.SystemTimer;
import com.yahoo.concurrent.Timer;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Supervisor;
import com.yahoo.messagebus.network.rpc.RPCServiceAddress;
import com.yahoo.messagebus.network.rpc.RPCTarget;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RPCTargetPool {
    private final Map<Spec, Entry> targets = new HashMap<Spec, Entry>();
    private final Timer timer;
    private final long expireMillis;
    private final int numTargetsPerSpec;

    public RPCTargetPool(double expireSecs, int numTargetsPerSpec) {
        this((Timer)SystemTimer.INSTANCE, expireSecs, numTargetsPerSpec);
    }

    public RPCTargetPool(Timer timer, double expireSecs, int numTargetsPerSpec) {
        this.timer = timer;
        this.expireMillis = (long)(expireSecs * 1000.0);
        this.numTargetsPerSpec = numTargetsPerSpec;
    }

    public synchronized void flushTargets(boolean force) {
        Iterator<Entry> it = this.targets.values().iterator();
        long currentTime = this.timer.milliTime();
        long expireTime = currentTime - this.expireMillis;
        while (it.hasNext()) {
            Entry entry = it.next();
            if (entry.isValid()) {
                if (entry.getRefCount() > 1) {
                    entry.lastUse = currentTime;
                    continue;
                }
                if (!force && entry.lastUse > expireTime) continue;
            }
            entry.close();
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RPCTarget getTarget(Supervisor orb, RPCServiceAddress address) {
        Spec spec = address.getConnectionSpec();
        long now = this.timer.milliTime();
        RPCTargetPool rPCTargetPool = this;
        synchronized (rPCTargetPool) {
            Entry entry = this.targets.get(spec);
            if (entry != null) {
                RPCTarget target = entry.getTarget(now);
                if (target != null) {
                    return target;
                }
                this.dropTarget(entry, spec);
            }
            return this.createAndAddTarget(orb, spec, now);
        }
    }

    private void dropTarget(Entry entry, Spec key) {
        entry.close();
        this.targets.remove(key);
    }

    private RPCTarget createAndAddTarget(Supervisor orb, Spec spec, long now) {
        RPCTarget[] tmpTargets = new RPCTarget[this.numTargetsPerSpec];
        for (int i = 0; i < tmpTargets.length; ++i) {
            tmpTargets[i] = new RPCTarget(spec, orb);
        }
        Entry entry = new Entry(tmpTargets, now);
        this.targets.put(spec, entry);
        return entry.getTarget(now);
    }

    public synchronized int size() {
        return this.targets.size();
    }

    private static class Entry
    implements Closeable {
        private final RPCTarget[] targets;
        private int index;
        long lastUse;

        Entry(RPCTarget[] targets, long lastUse) {
            this.targets = targets;
            this.lastUse = lastUse;
        }

        RPCTarget getTarget(long now) {
            RPCTarget target;
            if (this.index >= this.targets.length) {
                this.index = 0;
            }
            if ((target = this.targets[this.index]).getJRTTarget().isValid()) {
                target.addRef();
                this.lastUse = now;
                ++this.index;
                return target;
            }
            return null;
        }

        boolean isValid() {
            for (RPCTarget target : this.targets) {
                if (target.getJRTTarget().isValid()) continue;
                return false;
            }
            return true;
        }

        int getRefCount() {
            int refCount = 0;
            for (RPCTarget target : this.targets) {
                refCount += target.getRefCount();
            }
            return refCount;
        }

        @Override
        public void close() {
            for (RPCTarget target : this.targets) {
                target.subRef();
            }
        }
    }
}

