/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.lucene;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.FileReference;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeMaps;
import com.yahoo.config.OptionalPathNode;
import com.yahoo.config.StringNode;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

public final class LuceneAnalysisConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "8693aedc2ccd03cddde9c61d304e0560";
    public static final String CONFIG_DEF_NAME = "lucene-analysis";
    public static final String CONFIG_DEF_NAMESPACE = "com.yahoo.language.lucene";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"package=com.yahoo.language.lucene", "configDir path optional", "analysis{}.tokenizer.name string default=standard", "analysis{}.tokenizer.conf{} string", "analysis{}.charFilters[].name string", "analysis{}.charFilters[].conf{} string", "analysis{}.tokenFilters[].name string", "analysis{}.tokenFilters[].conf{} string"};
    private final OptionalPathNode configDir;
    private final Map<String, Analysis> analysis;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public LuceneAnalysisConfig(Builder builder) {
        this(builder, true);
    }

    private LuceneAnalysisConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for lucene-analysis must be initialized: " + String.valueOf(builder.__uninitialized));
        }
        this.configDir = builder.configDir == null ? new OptionalPathNode() : new OptionalPathNode(builder.configDir);
        this.analysis = Analysis.createMap(builder.analysis);
    }

    public Optional<Path> configDir() {
        return this.configDir.value();
    }

    public Map<String, Analysis> analysis() {
        return Collections.unmodifiableMap(this.analysis);
    }

    public Analysis analysis(String key) {
        return this.analysis.get(key);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(LuceneAnalysisConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Optional<FileReference> configDir = Optional.empty();
        public Map<String, Analysis.Builder> analysis = new LinkedHashMap<String, Analysis.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(LuceneAnalysisConfig config) {
            this.configDir(config.configDir.getFileReference());
            for (Map.Entry<String, Analysis> __entry : config.analysis().entrySet()) {
                this.analysis(__entry.getKey(), new Analysis.Builder(__entry.getValue()));
            }
        }

        private Builder override(Builder __superior) {
            if (__superior.configDir != null) {
                this.configDir(__superior.configDir);
            }
            this.analysis(__superior.analysis);
            return this;
        }

        public Builder configDir(Optional<FileReference> __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.configDir = __value;
            this.__uninitialized.remove("configDir");
            return this;
        }

        private Builder configDir(FileReference __value) {
            return this.configDir(Optional.of(__value));
        }

        public Builder analysis(String __key, Analysis.Builder __value) {
            this.analysis.put(__key, __value);
            return this;
        }

        public Builder analysis(Map<String, Analysis.Builder> __values) {
            this.analysis.putAll(__values);
            return this;
        }

        public Builder analysis(String __key, Consumer<Analysis.Builder> __func) {
            Analysis.Builder __inner = new Analysis.Builder();
            __func.accept(__inner);
            this.analysis.put(__key, __inner);
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return LuceneAnalysisConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return LuceneAnalysisConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return LuceneAnalysisConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public LuceneAnalysisConfig build() {
            return new LuceneAnalysisConfig(this);
        }
    }

    public static final class Analysis
    extends InnerNode {
        private final Tokenizer tokenizer;
        private final InnerNodeVector<CharFilters> charFilters;
        private final InnerNodeVector<TokenFilters> tokenFilters;

        public Analysis(Builder builder) {
            this(builder, true);
        }

        private Analysis(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for lucene-analysis.analysis{} must be initialized: " + String.valueOf(builder.__uninitialized));
            }
            this.tokenizer = new Tokenizer(builder.tokenizer, throwIfUninitialized);
            this.charFilters = CharFilters.createVector(builder.charFilters);
            this.tokenFilters = TokenFilters.createVector(builder.tokenFilters);
        }

        public Tokenizer tokenizer() {
            return this.tokenizer;
        }

        public List<CharFilters> charFilters() {
            return this.charFilters;
        }

        public CharFilters charFilters(int i) {
            return (CharFilters)((Object)this.charFilters.get(i));
        }

        public List<TokenFilters> tokenFilters() {
            return this.tokenFilters;
        }

        public TokenFilters tokenFilters(int i) {
            return (TokenFilters)((Object)this.tokenFilters.get(i));
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Analysis newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("analysis");
            return changes;
        }

        private static Map<String, Analysis> createMap(Map<String, Builder> builders) {
            LinkedHashMap<String, Analysis> ret = new LinkedHashMap<String, Analysis>();
            for (String key : builders.keySet()) {
                ret.put(key, new Analysis(builders.get(key)));
            }
            return Collections.unmodifiableMap(ret);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            public Tokenizer.Builder tokenizer = new Tokenizer.Builder();
            public List<CharFilters.Builder> charFilters = new ArrayList<CharFilters.Builder>();
            public List<TokenFilters.Builder> tokenFilters = new ArrayList<TokenFilters.Builder>();

            public Builder() {
            }

            public Builder(Analysis config) {
                this.tokenizer(new Tokenizer.Builder(config.tokenizer()));
                for (CharFilters c : config.charFilters()) {
                    this.charFilters(new CharFilters.Builder(c));
                }
                for (TokenFilters t : config.tokenFilters()) {
                    this.tokenFilters(new TokenFilters.Builder(t));
                }
            }

            private Builder override(Builder __superior) {
                this.tokenizer(this.tokenizer.override(__superior.tokenizer));
                if (!__superior.charFilters.isEmpty()) {
                    this.charFilters.addAll(__superior.charFilters);
                }
                if (!__superior.tokenFilters.isEmpty()) {
                    this.tokenFilters.addAll(__superior.tokenFilters);
                }
                return this;
            }

            public Builder tokenizer(Tokenizer.Builder __builder) {
                this.tokenizer = __builder;
                return this;
            }

            public Builder tokenizer(Consumer<Tokenizer.Builder> __func) {
                Tokenizer.Builder __inner = new Tokenizer.Builder();
                __func.accept(__inner);
                this.tokenizer = __inner;
                return this;
            }

            public Builder charFilters(CharFilters.Builder __builder) {
                this.charFilters.add(__builder);
                return this;
            }

            public Builder charFilters(Consumer<CharFilters.Builder> __func) {
                CharFilters.Builder __inner = new CharFilters.Builder();
                __func.accept(__inner);
                this.charFilters.add(__inner);
                return this;
            }

            public Builder charFilters(List<CharFilters.Builder> __builders) {
                this.charFilters = __builders;
                return this;
            }

            public Builder tokenFilters(TokenFilters.Builder __builder) {
                this.tokenFilters.add(__builder);
                return this;
            }

            public Builder tokenFilters(Consumer<TokenFilters.Builder> __func) {
                TokenFilters.Builder __inner = new TokenFilters.Builder();
                __func.accept(__inner);
                this.tokenFilters.add(__inner);
                return this;
            }

            public Builder tokenFilters(List<TokenFilters.Builder> __builders) {
                this.tokenFilters = __builders;
                return this;
            }

            public Analysis build() {
                return new Analysis(this);
            }
        }

        public static final class Tokenizer
        extends InnerNode {
            private final StringNode name;
            private final Map<String, StringNode> conf;

            public Tokenizer(Builder builder) {
                this(builder, true);
            }

            private Tokenizer(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for lucene-analysis.analysis{}.tokenizer must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.name = builder.name == null ? new StringNode("standard") : new StringNode(builder.name);
                this.conf = LeafNodeMaps.asNodeMap(builder.conf, (LeafNode)new StringNode());
            }

            public String name() {
                return this.name.value();
            }

            public Map<String, String> conf() {
                return LeafNodeMaps.asValueMap(this.conf);
            }

            public String conf(String key) {
                return this.conf.get(key).value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Tokenizer newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("tokenizer");
                return changes;
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private String name = null;
                public Map<String, String> conf = new LinkedHashMap<String, String>();

                public Builder() {
                }

                public Builder(Tokenizer config) {
                    this.name(config.name());
                    this.conf(config.conf());
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    this.conf(__superior.conf);
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    return this;
                }

                public Builder conf(String __key, String __value) {
                    this.conf.put(__key, __value);
                    return this;
                }

                public Builder conf(Map<String, String> __values) {
                    this.conf.putAll(__values);
                    return this;
                }

                public Tokenizer build() {
                    return new Tokenizer(this);
                }
            }
        }

        public static final class CharFilters
        extends InnerNode {
            private final StringNode name;
            private final Map<String, StringNode> conf;

            public CharFilters(Builder builder) {
                this(builder, true);
            }

            private CharFilters(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for lucene-analysis.analysis{}.charFilters[] must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                this.conf = LeafNodeMaps.asNodeMap(builder.conf, (LeafNode)new StringNode());
            }

            public String name() {
                return this.name.value();
            }

            public Map<String, String> conf() {
                return LeafNodeMaps.asValueMap(this.conf);
            }

            public String conf(String key) {
                return this.conf.get(key).value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(CharFilters newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("charFilters");
                return changes;
            }

            private static InnerNodeVector<CharFilters> createVector(List<Builder> builders) {
                ArrayList<CharFilters> elems = new ArrayList<CharFilters>();
                for (Builder b : builders) {
                    elems.add(new CharFilters(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(List.of("name"));
                private String name = null;
                public Map<String, String> conf = new LinkedHashMap<String, String>();

                public Builder() {
                }

                public Builder(CharFilters config) {
                    this.name(config.name());
                    this.conf(config.conf());
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    this.conf(__superior.conf);
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Builder conf(String __key, String __value) {
                    this.conf.put(__key, __value);
                    return this;
                }

                public Builder conf(Map<String, String> __values) {
                    this.conf.putAll(__values);
                    return this;
                }

                public CharFilters build() {
                    return new CharFilters(this);
                }
            }
        }

        public static final class TokenFilters
        extends InnerNode {
            private final StringNode name;
            private final Map<String, StringNode> conf;

            public TokenFilters(Builder builder) {
                this(builder, true);
            }

            private TokenFilters(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for lucene-analysis.analysis{}.tokenFilters[] must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                this.conf = LeafNodeMaps.asNodeMap(builder.conf, (LeafNode)new StringNode());
            }

            public String name() {
                return this.name.value();
            }

            public Map<String, String> conf() {
                return LeafNodeMaps.asValueMap(this.conf);
            }

            public String conf(String key) {
                return this.conf.get(key).value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(TokenFilters newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("tokenFilters");
                return changes;
            }

            private static InnerNodeVector<TokenFilters> createVector(List<Builder> builders) {
                ArrayList<TokenFilters> elems = new ArrayList<TokenFilters>();
                for (Builder b : builders) {
                    elems.add(new TokenFilters(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(List.of("name"));
                private String name = null;
                public Map<String, String> conf = new LinkedHashMap<String, String>();

                public Builder() {
                }

                public Builder(TokenFilters config) {
                    this.name(config.name());
                    this.conf(config.conf());
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    this.conf(__superior.conf);
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Builder conf(String __key, String __value) {
                    this.conf.put(__key, __value);
                    return this;
                }

                public Builder conf(Map<String, String> __values) {
                    this.conf.putAll(__values);
                    return this;
                }

                public TokenFilters build() {
                    return new TokenFilters(this);
                }
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

