/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.lucene;

import com.yahoo.language.Language;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.ar.ArabicAnalyzer;
import org.apache.lucene.analysis.bg.BulgarianAnalyzer;
import org.apache.lucene.analysis.bn.BengaliAnalyzer;
import org.apache.lucene.analysis.ca.CatalanAnalyzer;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;
import org.apache.lucene.analysis.ckb.SoraniAnalyzer;
import org.apache.lucene.analysis.cz.CzechAnalyzer;
import org.apache.lucene.analysis.da.DanishAnalyzer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.el.GreekAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.es.SpanishAnalyzer;
import org.apache.lucene.analysis.et.EstonianAnalyzer;
import org.apache.lucene.analysis.eu.BasqueAnalyzer;
import org.apache.lucene.analysis.fa.PersianAnalyzer;
import org.apache.lucene.analysis.fi.FinnishAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.ga.IrishAnalyzer;
import org.apache.lucene.analysis.gl.GalicianAnalyzer;
import org.apache.lucene.analysis.hi.HindiAnalyzer;
import org.apache.lucene.analysis.hu.HungarianAnalyzer;
import org.apache.lucene.analysis.hy.ArmenianAnalyzer;
import org.apache.lucene.analysis.id.IndonesianAnalyzer;
import org.apache.lucene.analysis.it.ItalianAnalyzer;
import org.apache.lucene.analysis.lt.LithuanianAnalyzer;
import org.apache.lucene.analysis.lv.LatvianAnalyzer;
import org.apache.lucene.analysis.ne.NepaliAnalyzer;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.lucene.analysis.no.NorwegianAnalyzer;
import org.apache.lucene.analysis.pt.PortugueseAnalyzer;
import org.apache.lucene.analysis.ro.RomanianAnalyzer;
import org.apache.lucene.analysis.ru.RussianAnalyzer;
import org.apache.lucene.analysis.sr.SerbianAnalyzer;
import org.apache.lucene.analysis.sv.SwedishAnalyzer;
import org.apache.lucene.analysis.ta.TamilAnalyzer;
import org.apache.lucene.analysis.te.TeluguAnalyzer;
import org.apache.lucene.analysis.th.ThaiAnalyzer;
import org.apache.lucene.analysis.tr.TurkishAnalyzer;

class DefaultAnalyzers {
    private final Map<Language, Analyzer> analyzerClasses = Map.ofEntries(Map.entry(Language.ARABIC, new ArabicAnalyzer()), Map.entry(Language.BULGARIAN, new BulgarianAnalyzer()), Map.entry(Language.BENGALI, new BengaliAnalyzer()), Map.entry(Language.CATALAN, new CatalanAnalyzer()), Map.entry(Language.CHINESE_SIMPLIFIED, new CJKAnalyzer()), Map.entry(Language.CHINESE_TRADITIONAL, new CJKAnalyzer()), Map.entry(Language.JAPANESE, new CJKAnalyzer()), Map.entry(Language.KOREAN, new CJKAnalyzer()), Map.entry(Language.KURDISH, new SoraniAnalyzer()), Map.entry(Language.CZECH, new CzechAnalyzer()), Map.entry(Language.DANISH, new DanishAnalyzer()), Map.entry(Language.GERMAN, new GermanAnalyzer()), Map.entry(Language.GREEK, new GreekAnalyzer()), Map.entry(Language.ENGLISH, new EnglishAnalyzer()), Map.entry(Language.SPANISH, new SpanishAnalyzer()), Map.entry(Language.ESTONIAN, new EstonianAnalyzer()), Map.entry(Language.BASQUE, new BasqueAnalyzer()), Map.entry(Language.PERSIAN, new PersianAnalyzer()), Map.entry(Language.FINNISH, new FinnishAnalyzer()), Map.entry(Language.FRENCH, new FrenchAnalyzer()), Map.entry(Language.IRISH, new IrishAnalyzer()), Map.entry(Language.GALICIAN, new GalicianAnalyzer()), Map.entry(Language.HINDI, new HindiAnalyzer()), Map.entry(Language.HUNGARIAN, new HungarianAnalyzer()), Map.entry(Language.ARMENIAN, new ArmenianAnalyzer()), Map.entry(Language.INDONESIAN, new IndonesianAnalyzer()), Map.entry(Language.ITALIAN, new ItalianAnalyzer()), Map.entry(Language.LITHUANIAN, new LithuanianAnalyzer()), Map.entry(Language.LATVIAN, new LatvianAnalyzer()), Map.entry(Language.NEPALI, new NepaliAnalyzer()), Map.entry(Language.DUTCH, new DutchAnalyzer()), Map.entry(Language.NORWEGIAN_BOKMAL, new NorwegianAnalyzer()), Map.entry(Language.PORTUGUESE, new PortugueseAnalyzer()), Map.entry(Language.ROMANIAN, new RomanianAnalyzer()), Map.entry(Language.RUSSIAN, new RussianAnalyzer()), Map.entry(Language.SERBIAN, new SerbianAnalyzer()), Map.entry(Language.SWEDISH, new SwedishAnalyzer()), Map.entry(Language.TAMIL, new TamilAnalyzer()), Map.entry(Language.TELUGU, new TeluguAnalyzer()), Map.entry(Language.THAI, new ThaiAnalyzer()), Map.entry(Language.TURKISH, new TurkishAnalyzer()));

    public Analyzer get(Language language) {
        return this.analyzerClasses.get(language);
    }
}

