/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.lucene;

import com.yahoo.component.ComponentId;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.language.Language;
import com.yahoo.language.lucene.DefaultAnalyzers;
import com.yahoo.language.lucene.LuceneAnalysisConfig;
import com.yahoo.language.process.StemMode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharFilterFactory;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenizerFactory;
import org.apache.lucene.analysis.custom.CustomAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

class AnalyzerFactory {
    private static final Logger log = Logger.getLogger(AnalyzerFactory.class.getName());
    private final LuceneAnalysisConfig config;
    private final Map<AnalyzerKey, Analyzer> languageAnalyzers = new ConcurrentHashMap<AnalyzerKey, Analyzer>();
    private final Analyzer defaultAnalyzer = new StandardAnalyzer();
    private static final String STANDARD_TOKENIZER = "standard";
    private final ComponentRegistry<Analyzer> analyzerComponents;
    private final DefaultAnalyzers defaultAnalyzers;

    private static String dump(ComponentRegistry<Analyzer> analyzers) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        Map map = analyzers.allComponentsById();
        for (Map.Entry entry : map.entrySet()) {
            buf.append(" {");
            buf.append(((ComponentId)entry.getKey()).toString());
            buf.append(":");
            buf.append(((Analyzer)entry.getValue()).getClass());
            buf.append("}");
        }
        buf.append(" ]");
        return buf.toString();
    }

    public AnalyzerFactory(LuceneAnalysisConfig config, ComponentRegistry<Analyzer> analyzers) {
        this.config = config;
        this.analyzerComponents = analyzers;
        this.defaultAnalyzers = new DefaultAnalyzers();
        log.config("Available in classpath char filters: " + String.valueOf(CharFilterFactory.availableCharFilters()));
        log.config("Available in classpath tokenizers: " + String.valueOf(TokenizerFactory.availableTokenizers()));
        log.config("Available in classpath token filters: " + String.valueOf(TokenFilterFactory.availableTokenFilters()));
        log.config("Available in component registry: " + AnalyzerFactory.dump(analyzers));
    }

    public Analyzer getAnalyzer(Language language, StemMode stemMode, boolean removeAccents) {
        return this.languageAnalyzers.computeIfAbsent(new AnalyzerKey(language, stemMode, removeAccents), this::createAnalyzer);
    }

    private Analyzer createAnalyzer(AnalyzerKey analyzerKey) {
        Analyzer analyzer = this.analysisConfig(analyzerKey);
        if (analyzer != null) {
            return analyzer;
        }
        analyzer = this.fromComponents(analyzerKey);
        if (analyzer != null) {
            return analyzer;
        }
        analyzer = this.defaultAnalyzers.get(analyzerKey.language());
        if (analyzer != null) {
            return analyzer;
        }
        return this.defaultAnalyzer;
    }

    private Analyzer analysisConfig(AnalyzerKey analyzerKey) {
        return this.lookup(analyzerKey, key -> this.createAnalyzer(analyzerKey, this.config.analysis((String)key)));
    }

    private Analyzer fromComponents(AnalyzerKey analyzerKey) {
        return this.lookup(analyzerKey, key -> (Analyzer)this.analyzerComponents.getComponent(key));
    }

    private Analyzer lookup(AnalyzerKey key, Function<String, Analyzer> analyzerMap) {
        Analyzer analyzer = analyzerMap.apply(key.languageCodeAndStemMode());
        if (analyzer != null) {
            return analyzer;
        }
        analyzer = analyzerMap.apply(key.generalizedLanguageCodeAndStemMode());
        if (analyzer != null) {
            return analyzer;
        }
        analyzer = analyzerMap.apply(key.languageCode());
        if (analyzer != null) {
            return analyzer;
        }
        analyzer = analyzerMap.apply(key.generalizedLanguageCode());
        return analyzer;
    }

    private Analyzer createAnalyzer(AnalyzerKey analyzerKey, LuceneAnalysisConfig.Analysis analysis) {
        try {
            if (analysis == null) {
                return null;
            }
            CustomAnalyzer.Builder builder = this.config.configDir().map(CustomAnalyzer::builder).orElseGet(CustomAnalyzer::builder);
            builder = this.withTokenizer(builder, analysis);
            builder = this.addCharFilters(builder, analysis);
            builder = this.addTokenFilters(builder, analysis);
            return builder.build();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build analyzer " + String.valueOf(analyzerKey) + ", with configuration " + String.valueOf((Object)analysis), e);
        }
    }

    private CustomAnalyzer.Builder withTokenizer(CustomAnalyzer.Builder builder, LuceneAnalysisConfig.Analysis analysis) throws IOException {
        if (null == analysis) {
            return builder.withTokenizer(STANDARD_TOKENIZER, new HashMap());
        }
        String tokenizerName = analysis.tokenizer().name();
        Map<String, String> conf = analysis.tokenizer().conf();
        return builder.withTokenizer(tokenizerName, this.asModifiable(conf));
    }

    private CustomAnalyzer.Builder addCharFilters(CustomAnalyzer.Builder builder, LuceneAnalysisConfig.Analysis analysis) throws IOException {
        if (null == analysis) {
            return builder;
        }
        for (LuceneAnalysisConfig.Analysis.CharFilters charFilter : analysis.charFilters()) {
            builder.addCharFilter(charFilter.name(), this.asModifiable(charFilter.conf()));
        }
        return builder;
    }

    private CustomAnalyzer.Builder addTokenFilters(CustomAnalyzer.Builder builder, LuceneAnalysisConfig.Analysis analysis) throws IOException {
        if (null == analysis) {
            return builder;
        }
        for (LuceneAnalysisConfig.Analysis.TokenFilters tokenFilter : analysis.tokenFilters()) {
            builder.addTokenFilter(tokenFilter.name(), this.asModifiable(tokenFilter.conf()));
        }
        return builder;
    }

    private Map<String, String> asModifiable(Map<String, String> map) {
        return new HashMap<String, String>(map);
    }

    private record AnalyzerKey(Language language, StemMode stemMode, boolean removeAccents) {
        public String languageCodeAndStemMode() {
            return this.languageCode() + "/" + this.stemMode.toString();
        }

        public String generalizedLanguageCodeAndStemMode() {
            return this.generalizedLanguageCode() + "/" + this.stemMode.toString();
        }

        public String languageCode() {
            return this.language.languageCode();
        }

        public String generalizedLanguageCode() {
            if (this.language == Language.CHINESE_SIMPLIFIED || this.language == Language.CHINESE_TRADITIONAL) {
                return "zh";
            }
            return this.language.languageCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AnalyzerKey)) {
                return false;
            }
            AnalyzerKey other = (AnalyzerKey)o;
            return other.language == this.language && other.stemMode == this.stemMode;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.language, this.stemMode);
        }
    }
}

