/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.process;

import com.yahoo.collections.LazyMap;
import com.yahoo.language.Language;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class InvocationContext<SUBCLASS extends InvocationContext<SUBCLASS>> {
    private Language language = Language.UNKNOWN;
    private String destination;
    private String componentId = "unknown";
    private final Map<Object, Object> cache;

    public InvocationContext(String destination) {
        this(destination, (Map<Object, Object>)LazyMap.newHashMap());
    }

    public InvocationContext(String destination, Map<Object, Object> cache) {
        this.destination = destination;
        this.cache = Objects.requireNonNull(cache);
    }

    protected InvocationContext(SUBCLASS other) {
        this.language = ((InvocationContext)other).getLanguage();
        this.destination = ((InvocationContext)other).getDestination();
        this.componentId = ((InvocationContext)other).getComponentId();
        this.cache = ((InvocationContext)other).getCache();
    }

    public Language getLanguage() {
        return this.language;
    }

    public SUBCLASS setLanguage(Language language) {
        this.language = language != null ? language : Language.UNKNOWN;
        return (SUBCLASS)this;
    }

    public String getDestination() {
        return this.destination;
    }

    public SUBCLASS setDestination(String destination) {
        this.destination = destination;
        return (SUBCLASS)this;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public SUBCLASS setComponentId(String componentId) {
        this.componentId = componentId;
        return (SUBCLASS)this;
    }

    protected Map<Object, Object> getCache() {
        return this.cache;
    }

    public void putCachedValue(Object key, Object value) {
        this.cache.put(key, value);
    }

    public Object getCachedValue(Object key) {
        return this.cache.get(key);
    }

    public <T> T computeCachedValueIfAbsent(Object key, Supplier<? extends T> supplier) {
        return (T)this.cache.computeIfAbsent(key, __ -> supplier.get());
    }
}

