/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.process;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class StemList
extends AbstractList<String> {
    private final Optional<String> origin;
    private final List<String> stems;

    public StemList() {
        this(new String[0]);
    }

    public StemList(String ... stems) {
        this(Optional.empty(), stems);
    }

    public StemList(Optional<String> origin, String ... stems) {
        this.origin = origin;
        this.stems = new ArrayList<String>(Math.max(stems.length, 3));
        for (String word : stems) {
            this.add(word);
        }
    }

    public Optional<String> getOrigin() {
        return this.origin;
    }

    @Override
    public String get(int i) {
        return this.stems.get(i);
    }

    @Override
    public int size() {
        return this.stems.size();
    }

    @Override
    public String set(int i, String element) {
        int existing = this.stems.indexOf(element);
        if (existing >= 0 && existing != i) {
            return element;
        }
        return this.stems.set(i, element);
    }

    @Override
    public void add(int i, String element) {
        int existing = this.stems.indexOf(element);
        if (existing < 0) {
            this.stems.add(i, element);
        }
    }

    @Override
    public String remove(int i) {
        return this.stems.remove(i);
    }
}

