// Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
package com.yahoo.language.process;

/**
 * List of token scripts (e.g. latin, japanese, chinese, etc.) which may warrant different
 * linguistics treatment.
 *
 * @author Mathias Mølster Lidal
 */
public enum TokenScript {

    COMMON,
    LATIN,
    GREEK,
    CYRILLIC,
    ARMENIAN,
    HEBREW,
    ARABIC,
    SYRIAC,
    THAANA,
    DEVANAGARI,
    BENGALI,
    GURMUKHI,
    GUJARATI,
    ORIYA,
    TAMIL,
    TELUGU,
    KANNADA,
    MALAYALAM,
    SINHALA,
    THAI,
    LAO,
    TIBETAN,
    MYANMAR,
    GEORGIAN,
    HANGUL,
    ETHIOPIC,
    CHEROKEE,
    CANADIAN,
    OGHAM,
    RUNIC,
    KHMER,
    MONGOLIAN,
    HIRAGANA,
    KATAKANA,
    CHINESE,
    HAN,
    YI,
    OLDITALIC,
    GOTHIC,
    DESERET,
    INHERITED,
    TAGALOG,
    HANUNOO,
    BUHID,
    TAGBANWA,
    LIMBU,
    TAILE,
    LINEARB,
    UGARITIC,
    SHAVIAN,
    OSMANYA,
    CYPRIOT,
    BRAILLE,
    ASCII,
    BUGINESE,
    COPTIC,
    GLAGOLITIC,
    KHAROSHTHI,
    OLDPERSIAN,
    SYLOTINAGRI,
    TAILUE,
    TIFINAGH,
    VIETNAMESE,
    UNKNOWN;

}
