/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt.slobrok.api;

import com.yahoo.jrt.Int32Value;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.RequestWaiter;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.jrt.Task;
import com.yahoo.jrt.TransportThread;
import com.yahoo.jrt.Values;
import com.yahoo.jrt.slobrok.api.BackOff;
import com.yahoo.jrt.slobrok.api.BackOffPolicy;
import com.yahoo.jrt.slobrok.api.IMirror;
import com.yahoo.jrt.slobrok.api.SlobrokList;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Mirror
implements IMirror {
    private static final Logger log = Logger.getLogger(Mirror.class.getName());
    private final EventLog eventLog = new EventLog();
    private final Supervisor orb;
    private final SlobrokList slobroks;
    private String currSlobrok;
    private final BackOffPolicy backOff;
    private volatile int updates = 0;
    private volatile long iterations = 0L;
    private boolean requestDone = false;
    private boolean logOnSuccess = true;
    private final AtomicReference<Entry[]> specs = new AtomicReference<Entry[]>(new Entry[0]);
    private int specsGeneration = 0;
    private final TransportThread transportThread;
    private final Task updateTask;
    private final RequestWaiter reqWait;
    private Target target = null;
    private Request req = null;

    public Mirror(Supervisor orb, SlobrokList slobroks, BackOffPolicy bop) {
        this.orb = orb;
        this.slobroks = slobroks;
        this.backOff = bop;
        this.eventLog.addEvent("mirror created; with list of servers: " + String.valueOf(slobroks));
        this.transportThread = orb.transport().selectThread();
        this.updateTask = this.transportThread.createTask(this::checkForUpdate);
        this.reqWait = new RequestWaiter(){

            @Override
            public void handleRequestDone(Request req) {
                Mirror.this.requestDone = true;
                Mirror.this.updateTask.scheduleNow();
                Mirror.this.transportThread.wakeup_if_not_self();
            }
        };
        this.startFetchRequest();
    }

    public Mirror(Supervisor orb, SlobrokList slobroks) {
        this(orb, slobroks, new BackOff());
    }

    public void shutdown() {
        this.eventLog.addEvent("mirror shutdown");
        this.updateTask.kill();
        this.transportThread.perform(this::handleShutdown);
    }

    @Override
    public List<Entry> lookup(String pattern) {
        ArrayList<Entry> found = new ArrayList<Entry>();
        char[] p = pattern.toCharArray();
        for (Entry specEntry : this.specs.get()) {
            if (!Mirror.match(specEntry.getNameArray(), p)) continue;
            found.add(specEntry);
        }
        return found;
    }

    @Override
    public int updates() {
        return this.updates;
    }

    public boolean ready() {
        return this.updates != 0;
    }

    public boolean connected() {
        return this.target != null;
    }

    static boolean match(char[] name, char[] pattern) {
        int ni = 0;
        int pi = 0;
        while (ni < name.length && pi < pattern.length) {
            if (name[ni] == pattern[pi]) {
                ++ni;
                ++pi;
                continue;
            }
            if (pattern[pi] == '*') {
                ++pi;
                while (ni < name.length && name[ni] != '/') {
                    ++ni;
                }
                if (pi >= pattern.length || pattern[pi] != '*') continue;
                ++pi;
                ni = name.length;
                continue;
            }
            return false;
        }
        while (pi < pattern.length && pattern[pi] == '*') {
            ++pi;
        }
        return ni == name.length && pi == pattern.length;
    }

    private void checkForUpdate() {
        ++this.iterations;
        if (this.requestDone) {
            this.handleUpdate();
            this.requestDone = false;
        }
        this.startFetchRequest();
    }

    private void startFetchRequest() {
        if (this.target != null && !this.slobroks.contains(this.currSlobrok)) {
            log.log(Level.INFO, "location broker " + this.currSlobrok + " removed, will disconnect and use one of: " + String.valueOf(this.slobroks));
            this.target.close();
            this.target = null;
            this.eventLog.addEvent("new list of servers: " + String.valueOf(this.slobroks));
        }
        if (this.target == null) {
            this.logOnSuccess = true;
            this.currSlobrok = this.slobroks.nextSlobrokSpec();
            if (this.currSlobrok == null) {
                double delay = this.backOff.get();
                Level level = Level.FINE;
                if (this.backOff.shouldInform(delay)) {
                    level = Level.INFO;
                }
                if (this.backOff.shouldWarn(delay)) {
                    level = Level.INFO;
                }
                log.log(level, "no location brokers available, retrying: " + String.valueOf(this.slobroks) + " (in " + delay + " seconds)");
                this.updateTask.schedule(delay);
                return;
            }
            this.eventLog.addEvent("selected new server: " + this.currSlobrok);
            log.fine(() -> "Try connecting to " + this.currSlobrok);
            this.target = this.orb.connect(new Spec(this.currSlobrok));
            this.specsGeneration = 0;
        }
        this.req = new Request("slobrok.incremental.fetch");
        this.req.parameters().add(new Int32Value(this.specsGeneration));
        this.req.parameters().add(new Int32Value(5000));
        this.target.invokeAsync(this.req, Duration.ofSeconds(40L), this.reqWait);
    }

    private void handleUpdate() {
        if (!this.req.checkReturnTypes("iSSSi") || this.req.returnValues().get(2).count() != this.req.returnValues().get(3).count()) {
            if (!this.logOnSuccess) {
                log.log(Level.INFO, "Error with location broker " + this.currSlobrok + " update: " + this.req.errorMessage() + " (error code " + this.req.errorCode() + ")");
            } else {
                log.fine(() -> "Error with location broker " + this.currSlobrok + " update: " + this.req.errorMessage() + " (error code " + this.req.errorCode() + ")");
            }
            this.target.close();
            this.target = null;
            this.eventLog.addEvent("failed: " + this.currSlobrok + " [" + this.req.errorMessage() + "]");
            return;
        }
        this.eventLog.addEvent("good answer from: " + this.currSlobrok);
        Values answer = this.req.returnValues();
        int diffFromGeneration = answer.get(0).asInt32();
        int diffToGeneration = answer.get(4).asInt32();
        if (this.specsGeneration != diffToGeneration) {
            Entry[] newSpecs;
            int nRemoves = answer.get(1).count();
            String[] r = answer.get(1).asStringArray();
            int numNames = answer.get(2).count();
            String[] n = answer.get(2).asStringArray();
            String[] s = answer.get(3).asStringArray();
            if (diffFromGeneration == 0) {
                newSpecs = new Entry[numNames];
                for (int idx = 0; idx < numNames; ++idx) {
                    newSpecs[idx] = new Entry(n[idx], s[idx]);
                }
            } else {
                int idx;
                HashMap<String, Entry> map = new HashMap<String, Entry>();
                for (Entry e : this.specs.get()) {
                    map.put(e.getName(), e);
                }
                for (String rem : r) {
                    map.remove(rem);
                }
                for (idx = 0; idx < numNames; ++idx) {
                    map.put(n[idx], new Entry(n[idx], s[idx]));
                }
                newSpecs = new Entry[map.size()];
                idx = 0;
                for (Entry e : map.values()) {
                    newSpecs[idx++] = e;
                }
            }
            if (this.logOnSuccess) {
                log.log(Level.INFO, "successfully connected to location broker " + this.currSlobrok + " (mirror initialized with " + newSpecs.length + " service names)");
                this.logOnSuccess = false;
            } else {
                log.fine(() -> "successfully updated from location broker " + this.currSlobrok + " (now " + newSpecs.length + " service names)");
            }
            this.specs.set(newSpecs);
            this.specsGeneration = diffToGeneration;
            int u = this.updates + 1;
            if (u == 0) {
                ++u;
            }
            this.updates = u;
        } else {
            log.fine(() -> "NOP update from location broker " + this.currSlobrok + " (curr gen " + this.specsGeneration + ")");
        }
        this.backOff.reset();
    }

    private void handleShutdown() {
        if (this.req != null) {
            this.req.abort();
            this.req = null;
        }
        if (this.target != null) {
            this.target.close();
            this.target = null;
        }
        this.specs.set(new Entry[0]);
    }

    public void dumpState() {
        log.log(Level.INFO, "location broker mirror state:  iterations: " + this.iterations + ", connected to: " + String.valueOf(this.target) + ", number of service specs: " + this.specs.get().length + ", seen " + this.updates + " updates, current server: " + this.currSlobrok + ", list of servers: " + String.valueOf(this.slobroks));
        this.eventLog.dump();
    }

    public long getIterations() {
        return this.iterations;
    }

    static class EventLog {
        int idx = 0;
        List<Event> firstEvents = new ArrayList<Event>();
        List<Event> lastEvents = new ArrayList<Event>();

        EventLog() {
        }

        synchronized void addEvent(String message) {
            Event event = new Event(message);
            if (this.firstEvents.size() < 10) {
                this.firstEvents.add(event);
            } else if (this.lastEvents.size() < 10) {
                this.lastEvents.add(event);
            } else {
                this.lastEvents.set(this.idx, event);
                this.idx = (this.idx + 1) % this.lastEvents.size();
            }
        }

        void dump(Event e, long nanos, double now) {
            long tt = (long)(now - (double)(nanos - e.timestamp) / 1.0E9);
            log.info("event at [" + tt + "]: " + e.message);
        }

        synchronized void dump() {
            long nanos = System.nanoTime();
            double now = (double)System.currentTimeMillis() / 1000.0;
            log.info("initial events for location broker mirror");
            for (Event e : this.firstEvents) {
                this.dump(e, nanos, now);
            }
            if (this.lastEvents.size() > 0) {
                log.info("last events for location broker mirror");
                for (Event e : this.lastEvents) {
                    this.dump(e, nanos, now);
                }
            }
        }

        private static class Event {
            final long timestamp = System.nanoTime();
            final String message;

            Event(String msg) {
                this.message = msg;
            }
        }
    }

    public static final class Entry
    implements Comparable<Entry> {
        private final String name;
        private final Spec spec;
        private final char[] nameArray;

        public Entry(String name, String spec) {
            this.name = name;
            this.spec = new Spec(spec);
            this.nameArray = name.toCharArray();
        }

        public boolean equals(Object rhs) {
            if (rhs == null || !(rhs instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)rhs;
            return this.name.equals(e.name) && this.spec.equals(e.spec);
        }

        public int hashCode() {
            return this.name.hashCode() + this.spec.hashCode();
        }

        @Override
        public int compareTo(Entry b) {
            int diff = this.name.compareTo(b.name);
            return diff != 0 ? diff : this.spec.compareTo(b.spec);
        }

        char[] getNameArray() {
            return this.nameArray;
        }

        public String getName() {
            return this.name;
        }

        public Spec getSpec() {
            return this.spec;
        }

        public String getSpecString() {
            return this.spec.toString();
        }
    }
}

