/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;

public class Spec
implements Comparable<Spec> {
    private final String host;
    private final int port;
    private final boolean malformed;
    private final String asString;

    private static SocketAddress createAddress(String host, int port) {
        return host == null ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
    }

    private static String createString(String host, int port) {
        return host == null ? "tcp/" + port : "tcp/" + host + ":" + port;
    }

    public Spec(String spec) {
        if (spec.startsWith("tcp/")) {
            String portStr;
            int sep = spec.indexOf(58);
            String hostStr = null;
            if (sep == -1) {
                portStr = spec.substring(4);
            } else {
                hostStr = spec.substring(4, sep);
                portStr = spec.substring(sep + 1);
            }
            boolean correct = true;
            int portNum = 0;
            try {
                portNum = Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                correct = false;
            }
            this.port = portNum;
            this.malformed = !correct;
            this.host = correct ? hostStr : null;
            this.asString = correct ? Spec.createString(this.host, this.port) : "MALFORMED";
        } else {
            this.malformed = true;
            this.port = 0;
            this.host = null;
            this.asString = "MALFORMED";
        }
    }

    public Spec(String host, int port) {
        this.host = host;
        this.port = port;
        this.malformed = false;
        this.asString = Spec.createString(host, port);
    }

    public Spec(int port) {
        this(null, port);
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public boolean malformed() {
        return this.malformed;
    }

    SocketAddress resolveAddress() {
        return !this.malformed ? Spec.createAddress(this.host, this.port) : null;
    }

    public String toString() {
        return this.asString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Spec spec = (Spec)o;
        return this.port == spec.port && this.malformed == spec.malformed && Objects.equals(this.host, spec.host);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.malformed);
    }

    @Override
    public int compareTo(Spec o) {
        int cmp = 0;
        if (this.host != null && o.host != null) {
            cmp = this.host.compareTo(o.host);
        } else {
            if (this.host != null) {
                return -1;
            }
            if (o.host != null) {
                return 1;
            }
        }
        return cmp == 0 ? Integer.compare(this.port, o.port) : cmp;
    }
}

