/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Connection;
import com.yahoo.jrt.ErrorPacket;
import com.yahoo.jrt.Packet;
import com.yahoo.jrt.ReplyHandler;
import com.yahoo.jrt.ReplyPacket;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.RequestPacket;
import com.yahoo.jrt.RequestWaiter;
import com.yahoo.jrt.Task;

class InvocationClient
implements ReplyHandler,
Runnable {
    Connection conn;
    Request req;
    double timeout;
    RequestWaiter reqWaiter;
    Integer replyKey;
    Task timeoutTask;

    public InvocationClient(Connection conn, Request req, double timeout, RequestWaiter waiter) {
        this.conn = conn;
        this.req = req;
        this.timeout = timeout;
        this.reqWaiter = waiter;
        req.clientHandler(this);
        this.replyKey = conn.allocateKey();
        this.timeoutTask = conn.transportThread().createTask(this);
    }

    public void invoke() {
        if (!this.conn.postPacket(new RequestPacket(0, this.replyKey, this.req.methodName(), this.req.parameters()), this)) {
            this.req.setError(104, "Connection error");
            this.reqWaiter.handleRequestDone(this.req);
            return;
        }
        this.timeoutTask.schedule(this.timeout);
    }

    @Override
    public Integer key() {
        return this.replyKey;
    }

    @Override
    public void handleReply(Packet packet) {
        this.timeoutTask.kill();
        if (packet == null) {
            this.req.setError(110, "Bad reply packet");
        } else {
            int pcode = packet.packetCode();
            if (pcode == 101) {
                ReplyPacket rp = (ReplyPacket)packet;
                this.req.returnValues(rp.returnValues());
            } else if (pcode == 102) {
                ErrorPacket ep = (ErrorPacket)packet;
                this.req.setError(ep.errorCode(), ep.errorMessage());
            }
        }
        this.reqWaiter.handleRequestDone(this.req);
    }

    public void handleAbort() {
        if (!this.conn.cancelReply(this)) {
            return;
        }
        this.timeoutTask.kill();
        this.req.setError(102, "Aborted by user");
        this.reqWaiter.handleRequestDone(this.req);
    }

    @Override
    public void handleConnectionDown() {
        this.timeoutTask.kill();
        this.req.setError(104, "Connection error");
        this.reqWaiter.handleRequestDone(this.req);
    }

    @Override
    public void run() {
        if (!this.conn.cancelReply(this)) {
            return;
        }
        this.req.setError(103, "Request timed out after " + this.timeout + " seconds.");
        this.reqWaiter.handleRequestDone(this.req);
    }
}

