/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.vespa.indexinglanguage.expressions.Expression;

public class VerificationException
extends IllegalArgumentException {
    private final Class<?> type;
    private final String expression;

    public VerificationException(Expression expression, String message) {
        super("Invalid expression '" + String.valueOf((Object)expression) + "': " + message);
        if (expression != null) {
            this.type = ((Object)((Object)expression)).getClass();
            this.expression = ((Object)((Object)expression)).toString();
        } else {
            this.type = null;
            this.expression = "null";
        }
    }

    public VerificationException(Class<?> expression, String message) {
        super("Invalid expression of type '" + expression.getSimpleName() + "': " + message);
        this.type = expression;
        this.expression = expression.getName();
    }

    public String getExpression() {
        return this.expression;
    }

    public Class<?> getExpressionType() {
        return this.type;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ": " + this.getMessage();
    }
}

