/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.tensor.Tensor;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.TypeContext;
import java.util.Objects;
import java.util.Optional;

public class BinarizeExpression
extends Expression {
    private final double threshold;

    public BinarizeExpression(double threshold) {
        this.threshold = threshold;
    }

    @Override
    public DataType setInputType(DataType inputType, TypeContext context) {
        return super.setInputType(inputType, (DataType)TensorDataType.any(), context);
    }

    @Override
    public DataType setOutputType(DataType outputType, TypeContext context) {
        return super.setOutputType(null, outputType, (DataType)TensorDataType.any(), context);
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        Optional tensor = ((TensorFieldValue)context.getCurrentValue()).getTensor();
        if (tensor.isEmpty()) {
            return;
        }
        context.setCurrentValue((FieldValue)new TensorFieldValue(((Tensor)tensor.get()).map(v -> v > this.threshold ? 1.0 : 0.0)));
    }

    public String toString() {
        return "binarize" + (String)(this.threshold == 0.0 ? "" : " " + this.threshold);
    }

    public int hashCode() {
        return Objects.hash(this.threshold, this.toString().hashCode());
    }

    public boolean equals(Object o) {
        if (!(o instanceof BinarizeExpression)) {
            return false;
        }
        BinarizeExpression other = (BinarizeExpression)((Object)o);
        return this.threshold == other.threshold;
    }
}

