/* IndexingParser.java */
/* Generated by: ParserGeneratorCC: Do not edit this line. IndexingParser.java */
package com.yahoo.vespa.indexinglanguage.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.LinkedHashMap;

import com.yahoo.collections.Pair;
import com.yahoo.document.datatypes.*;
import com.yahoo.text.StringUtilities;
import com.yahoo.vespa.indexinglanguage.expressions.*;
import com.yahoo.vespa.indexinglanguage.linguistics.AnnotatorConfig;
import com.yahoo.language.process.Chunker;
import com.yahoo.language.process.Embedder;
import com.yahoo.language.process.FieldGenerator;
import com.yahoo.language.Linguistics;

/**
 * @author Simon Thoresen Hult
 */
public class IndexingParser implements IndexingParserConstants {

    private String defaultFieldName;
    private Linguistics linguistics;
    private Components<Chunker> chunkers;
    private Components<Embedder> embedders;
    private Components<FieldGenerator> generators;
    private AnnotatorConfig globalAnnotatorConfig = new AnnotatorConfig();

    public IndexingParser(String str) {
        this(new IndexingInput(str));
    }

    public IndexingParser setDefaultFieldName(String fieldName) {
        defaultFieldName = fieldName;
        return this;
    }

    public IndexingParser setLinguistics(Linguistics linguistics) {
        this.linguistics = linguistics;
        return this;
    }

    public IndexingParser setChunkers(Map<String, Chunker> chunkers) {
        this.chunkers = new Components.Map<Chunker>(chunkers, Chunker.FailingChunker.factory());
        return this;
    }

    public IndexingParser setEmbedders(Map<String, Embedder> embedders) {
        this.embedders = new Components.Map<Embedder>(embedders, Embedder.FailingEmbedder.factory());
        return this;
    }

    public IndexingParser setGenerators(Map<String, FieldGenerator> generators) {
        this.generators = new Components.Map<FieldGenerator>(generators, FieldGenerator.FailingFieldGenerator.factory());
        return this;
    }

    public IndexingParser setGlobalAnnotatorConfig(AnnotatorConfig config) {
        globalAnnotatorConfig = config;
        return this;
    }

    private static DoubleFieldValue parseDouble(String str) {
        return new DoubleFieldValue(new BigDecimal(str).doubleValue());
    }

    private static FloatFieldValue parseFloat(String str) {
        if (str.endsWith("f") || str.endsWith("F")) {
            str = str.substring(0, str.length() - 1);
        }
        return new FloatFieldValue(new BigDecimal(str).floatValue());
    }

    private static IntegerFieldValue parseInteger(String str) {
        if (str.startsWith("0x")) {
            return new IntegerFieldValue(new BigInteger(str.substring(2), 16).intValue());
        } else {
            return new IntegerFieldValue(new BigInteger(str).intValue());
        }
    }

    private static LongFieldValue parseLong(String str) {
        if (str.endsWith("l") || str.endsWith("L")) {
            str = str.substring(0, str.length() - 1);
        }
        if (str.startsWith("0x")) {
            return new LongFieldValue(new BigInteger(str.substring(2), 16).longValue());
        } else {
            return new LongFieldValue(new BigInteger(str).longValue());
        }
    }

// --------------------------------------------------------------------------------
//
// Production rules.
//
// --------------------------------------------------------------------------------
  final public 
Expression root() throws ParseException {Expression exp;
    exp = statement();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SCOLON:{
      jj_consume_token(SCOLON);
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      ;
    }
while (exp instanceof ExpressionList && ((ExpressionList)exp).size() == 1) exp = ((ExpressionList)exp).get(0);
      {if ("" != null) return exp;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ScriptExpression script() throws ParseException {StatementExpression exp;
    List<StatementExpression> lst = new ArrayList<StatementExpression>();
    jj_consume_token(LCURLY);
    nl();
    exp = statement();
lst.add(exp);
    nl();
    label_1:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case SCOLON:{
        break;
        }
      default:
        jj_la1[1] = jj_gen;
        break label_1;
      }
      jj_consume_token(SCOLON);
      nl();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case INTEGER:
      case LONG:
      case DOUBLE:
      case FLOAT:
      case ADD:
      case SUB:
      case LCURLY:
      case LPAREN:
      case STRING:
      case ATTRIBUTE:
      case BASE64_DECODE:
      case BASE64_ENCODE:
      case BINARIZE:
      case BUSY_WAIT:
      case CHUNK:
      case CLEAR_STATE:
      case ECHO:
      case EMBED:
      case GENERATE:
      case EXACT:
      case FLATTEN:
      case FOR_EACH:
      case GET_FIELD:
      case GET_VAR:
      case GUARD:
      case HASH:
      case HEX_DECODE:
      case HEX_ENCODE:
      case HOST_NAME:
      case IF:
      case INDEX:
      case INPUT:
      case JOIN:
      case LOWER_CASE:
      case NGRAM:
      case NORMALIZE:
      case NOW:
      case OPTIMIZE_PREDICATE:
      case PACK_BITS:
      case PASSTHROUGH:
      case RANDOM:
      case SELECT_INPUT:
      case SET_LANGUAGE:
      case SET_VAR:
      case SLEEP:
      case SPLIT:
      case SUBSTRING:
      case SUMMARY:
      case SWITCH:
      case THIS:
      case TOKENIZE:
      case TO_ARRAY:
      case TO_BOOL:
      case TO_BYTE:
      case TO_DOUBLE:
      case TO_FLOAT:
      case TO_INT:
      case TO_LONG:
      case TO_POS:
      case TO_EPOCH_SECOND:
      case TO_STRING:
      case TO_URI:
      case TO_WSET:
      case TRIM:
      case ZCURVE:
      case TRUE:
      case FALSE:
      case UNDERSCORE:{
        exp = statement();
lst.add(exp);
        nl();
        break;
        }
      default:
        jj_la1[2] = jj_gen;
        ;
      }
    }
    jj_consume_token(RCURLY);
{if ("" != null) return new ScriptExpression(lst);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public StatementExpression statement() throws ParseException {Expression exp;
    List<Expression> lst = new ArrayList<Expression>();
    exp = expression();
lst.add(exp);
    label_2:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PIPE:{
        break;
        }
      default:
        jj_la1[3] = jj_gen;
        break label_2;
      }
      jj_consume_token(PIPE);
      nl();
      exp = expression();
lst.add(exp);
    }
{if ("" != null) return new StatementExpression(lst);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression expression() throws ParseException {Expression choice;
    List<Expression> choices = new ArrayList<Expression>();
    choice = nonChoiceExpression();
choices.add(choice);
    label_3:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case CHOICE:{
        break;
        }
      default:
        jj_la1[4] = jj_gen;
        break label_3;
      }
      jj_consume_token(CHOICE);
      choice = nonChoiceExpression();
choices.add(choice);
    }
{if ("" != null) return choices.size() == 1 ? choices.get(0) : new ChoiceExpression(choices);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression nonChoiceExpression() throws ParseException {Expression exp;
    List<Expression> lst = new ArrayList<Expression>();
    exp = math();
lst.add(exp);
    label_4:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DOT:{
        break;
        }
      default:
        jj_la1[5] = jj_gen;
        break label_4;
      }
      jj_consume_token(DOT);
      exp = math();
lst.add(exp);
    }
{if ("" != null) return lst.size() == 1 ? exp : new CatExpression(lst);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression math() throws ParseException {ArithmeticExpression.Operator op = ArithmeticExpression.Operator.ADD;
    MathResolver math = new MathResolver();
    Expression exp;
    exp = value();
math.push(op, exp);
    label_5:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ADD:
      case SUB:
      case MUL:
      case DIV:
      case MOD:{
        break;
        }
      default:
        jj_la1[6] = jj_gen;
        break label_5;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ADD:{
        jj_consume_token(ADD);
op = ArithmeticExpression.Operator.ADD;
        break;
        }
      case DIV:{
        jj_consume_token(DIV);
op = ArithmeticExpression.Operator.DIV;
        break;
        }
      case MOD:{
        jj_consume_token(MOD);
op = ArithmeticExpression.Operator.MOD;
        break;
        }
      case MUL:{
        jj_consume_token(MUL);
op = ArithmeticExpression.Operator.MUL;
        break;
        }
      case SUB:{
        jj_consume_token(SUB);
op = ArithmeticExpression.Operator.SUB;
        break;
        }
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      exp = value();
math.push(op, exp);
    }
{if ("" != null) return math.resolve();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression value() throws ParseException {Expression val;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ATTRIBUTE:{
      val = attributeExp();
      break;
      }
    case BASE64_DECODE:{
      val = base64DecodeExp();
      break;
      }
    case BASE64_ENCODE:{
      val = base64EncodeExp();
      break;
      }
    case BINARIZE:{
      val = binarizeExp();
      break;
      }
    case BUSY_WAIT:{
      val = busy_waitExp();
      break;
      }
    case CHUNK:{
      val = chunkExp();
      break;
      }
    case CLEAR_STATE:{
      val = clearStateExp();
      break;
      }
    case ECHO:{
      val = echoExp();
      break;
      }
    case EMBED:{
      val = embedExp();
      break;
      }
    case GENERATE:{
      val = generateExp();
      break;
      }
    case EXACT:{
      val = exactExp();
      break;
      }
    case UNDERSCORE:{
      val = executionValueExp();
      break;
      }
    case FLATTEN:{
      val = flattenExp();
      break;
      }
    case FOR_EACH:{
      val = forEachExp();
      break;
      }
    case GET_FIELD:{
      val = getFieldExp();
      break;
      }
    case GET_VAR:{
      val = getVarExp();
      break;
      }
    case GUARD:{
      val = guardExp();
      break;
      }
    case HASH:{
      val = hashExp();
      break;
      }
    case HEX_DECODE:{
      val = hexDecodeExp();
      break;
      }
    case HEX_ENCODE:{
      val = hexEncodeExp();
      break;
      }
    case HOST_NAME:{
      val = hostNameExp();
      break;
      }
    case IF:{
      val = ifThenExp();
      break;
      }
    case INDEX:{
      val = indexExp();
      break;
      }
    case INPUT:{
      val = inputExp();
      break;
      }
    case JOIN:{
      val = joinExp();
      break;
      }
    case TRUE:
    case FALSE:{
      val = literalBoolExp();
      break;
      }
    case LOWER_CASE:{
      val = lowerCaseExp();
      break;
      }
    case NGRAM:{
      val = ngramExp();
      break;
      }
    case NORMALIZE:{
      val = normalizeExp();
      break;
      }
    case NOW:{
      val = nowExp();
      break;
      }
    case OPTIMIZE_PREDICATE:{
      val = optimizePredicateExp();
      break;
      }
    case PACK_BITS:{
      val = packBitsExp();
      break;
      }
    case PASSTHROUGH:{
      val = passthroughExp();
      break;
      }
    case RANDOM:{
      val = randomExp();
      break;
      }
    case LCURLY:{
      val = script();
      break;
      }
    case SELECT_INPUT:{
      val = selectInputExp();
      break;
      }
    case SET_LANGUAGE:{
      val = setLanguageExp();
      break;
      }
    case INTEGER:
    case LONG:
    case DOUBLE:
    case FLOAT:
    case ADD:
    case SUB:
    case STRING:{
      val = setValueExp();
      break;
      }
    case SET_VAR:{
      val = setVarExp();
      break;
      }
    case SLEEP:{
      val = sleepExp();
      break;
      }
    case SPLIT:{
      val = splitExp();
      break;
      }
    case SUBSTRING:{
      val = substringExp();
      break;
      }
    case SUMMARY:{
      val = summaryExp();
      break;
      }
    case SWITCH:{
      val = switchExp();
      break;
      }
    case THIS:{
      val = thisExp();
      break;
      }
    case TOKENIZE:{
      val = tokenizeExp();
      break;
      }
    case TO_ARRAY:{
      val = toArrayExp();
      break;
      }
    case TO_BOOL:{
      val = toBoolExp();
      break;
      }
    case TO_BYTE:{
      val = toByteExp();
      break;
      }
    case TO_DOUBLE:{
      val = toDoubleExp();
      break;
      }
    case TO_EPOCH_SECOND:{
      val = toEpochSecondExp();
      break;
      }
    case TO_FLOAT:{
      val = toFloatExp();
      break;
      }
    case TO_INT:{
      val = toIntExp();
      break;
      }
    case TO_LONG:{
      val = toLongExp();
      break;
      }
    case TO_POS:{
      val = toPosExp();
      break;
      }
    case TO_STRING:{
      val = toStringExp();
      break;
      }
    case TO_URI:{
      val = toUriExp();
      break;
      }
    case TO_WSET:{
      val = toWsetExp();
      break;
      }
    case TRIM:{
      val = trimExp();
      break;
      }
    case ZCURVE:{
      val = zcurveExp();
      break;
      }
    case LPAREN:{
      jj_consume_token(LPAREN);
      val = statement();
      jj_consume_token(RPAREN);
val = new ParenthesisExpression(val);
      break;
      }
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return val;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression attributeExp() throws ParseException {String val = defaultFieldName;
    jj_consume_token(ATTRIBUTE);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case STRING:
    case ATTRIBUTE:
    case BASE64_DECODE:
    case BASE64_ENCODE:
    case BINARIZE:
    case BUSY_WAIT:
    case CASE:
    case CASE_DEFAULT:
    case CHUNK:
    case CLEAR_STATE:
    case CREATE_IF_NON_EXISTENT:
    case ECHO:
    case ELSE:
    case EMBED:
    case GENERATE:
    case EXACT:
    case FLATTEN:
    case FOR_EACH:
    case GET_FIELD:
    case GET_VAR:
    case GUARD:
    case HASH:
    case HEX_DECODE:
    case HEX_ENCODE:
    case HOST_NAME:
    case IF:
    case INDEX:
    case INPUT:
    case JOIN:
    case LOWER_CASE:
    case MAX_LENGTH:
    case NGRAM:
    case NORMALIZE:
    case NOW:
    case OPTIMIZE_PREDICATE:
    case PACK_BITS:
    case PASSTHROUGH:
    case RANDOM:
    case REMOVE_IF_ZERO:
    case SELECT_INPUT:
    case SET_LANGUAGE:
    case SET_VAR:
    case SLEEP:
    case SPLIT:
    case STEM:
    case SUBSTRING:
    case SUMMARY:
    case SWITCH:
    case THIS:
    case TOKENIZE:
    case TO_ARRAY:
    case TO_BOOL:
    case TO_BYTE:
    case TO_DOUBLE:
    case TO_FLOAT:
    case TO_INT:
    case TO_LONG:
    case TO_POS:
    case TO_EPOCH_SECOND:
    case TO_STRING:
    case TO_URI:
    case TO_WSET:
    case TRIM:
    case ZCURVE:
    case TRUE:
    case FALSE:
    case IDENTIFIER:{
      val = fieldName();
      break;
      }
    default:
      jj_la1[9] = jj_gen;
      ;
    }
{if ("" != null) return new AttributeExpression(val);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression base64DecodeExp() throws ParseException {
    jj_consume_token(BASE64_DECODE);
{if ("" != null) return new Base64DecodeExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression base64EncodeExp() throws ParseException {
    jj_consume_token(BASE64_ENCODE);
{if ("" != null) return new Base64EncodeExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression busy_waitExp() throws ParseException {
    jj_consume_token(BUSY_WAIT);
{if ("" != null) return new BusyWaitExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression chunkExp() throws ParseException {String chunkerId = "";
    List<String> arguments = new ArrayList<String>();
    jj_consume_token(CHUNK);
    if (jj_2_1(2)) {
      chunkerId = identifier();
    } else {
      ;
    }
    arguments = arguments();
{if ("" != null) return new ChunkExpression(chunkers, chunkerId, arguments);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression clearStateExp() throws ParseException {
    jj_consume_token(CLEAR_STATE);
{if ("" != null) return new ClearStateExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression echoExp() throws ParseException {
    jj_consume_token(ECHO);
{if ("" != null) return new EchoExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression embedExp() throws ParseException {String embedderId = "";
    List<String> arguments = new ArrayList<String>();
    jj_consume_token(EMBED);
    if (jj_2_2(2)) {
      embedderId = identifier();
    } else {
      ;
    }
    arguments = arguments();
{if ("" != null) return new EmbedExpression(linguistics, embedders, embedderId, arguments);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression generateExp() throws ParseException {String generatorId = "";
    List<String> arguments = new ArrayList<String>();
    jj_consume_token(GENERATE);
    if (jj_2_3(2)) {
      generatorId = identifier();
    } else {
      ;
    }
    arguments = arguments();
{if ("" != null) return new GenerateExpression(linguistics, generators, generatorId, arguments);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression exactExp() throws ParseException {AnnotatorConfig config = globalAnnotatorConfig;
    jj_consume_token(EXACT);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case KEEP_CASE:
    case MAX_LENGTH:
    case MAX_OCCURRENCES:
    case MAX_TOKEN_LENGTH:
    case NORMALIZE:
    case STEM:{
      config = annotatorConfig();
      break;
      }
    default:
      jj_la1[10] = jj_gen;
      ;
    }
{if ("" != null) return new ExactExpression(config);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression flattenExp() throws ParseException {
    jj_consume_token(FLATTEN);
{if ("" != null) return new FlattenExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression forEachExp() throws ParseException {Expression val;
    jj_consume_token(FOR_EACH);
    jj_consume_token(LCURLY);
    nl();
    val = statement();
    nl();
    jj_consume_token(RCURLY);
{if ("" != null) return new ForEachExpression(val);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression getFieldExp() throws ParseException {boolean hasPrefix = false;
    String val;
    jj_consume_token(GET_FIELD);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case 103:{
      jj_consume_token(103);
hasPrefix = true;
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      ;
    }
    val = identifier();
{if ("" != null) return new GetFieldExpression( (hasPrefix ? "$" : "") + val);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression getVarExp() throws ParseException {String val;
    jj_consume_token(GET_VAR);
    val = identifier();
{if ("" != null) return new GetVarExpression(val);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression guardExp() throws ParseException {Expression val;
    jj_consume_token(GUARD);
    val = script();
{if ("" != null) return new GuardExpression(val);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression hashExp() throws ParseException {
    jj_consume_token(HASH);
{if ("" != null) return new HashExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression hexDecodeExp() throws ParseException {
    jj_consume_token(HEX_DECODE);
{if ("" != null) return new HexDecodeExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression hexEncodeExp() throws ParseException {
    jj_consume_token(HEX_ENCODE);
{if ("" != null) return new HexEncodeExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression hostNameExp() throws ParseException {
    jj_consume_token(HOST_NAME);
{if ("" != null) return new HostNameExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression ifThenExp() throws ParseException {Expression lhs, rhs, ifTrue, ifFalse = null;
    IfThenExpression.Comparator cmp;
    jj_consume_token(IF);
    jj_consume_token(LPAREN);
    lhs = expression();
    cmp = ifThenCmp();
    rhs = expression();
    jj_consume_token(RPAREN);
    ifTrue = script();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ELSE:{
      jj_consume_token(ELSE);
      ifFalse = script();
      break;
      }
    default:
      jj_la1[12] = jj_gen;
      ;
    }
{if ("" != null) return new IfThenExpression(lhs, cmp, rhs, ifTrue, ifFalse);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public IfThenExpression.Comparator ifThenCmp() throws ParseException {IfThenExpression.Comparator val = null;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case EQ:{
      jj_consume_token(EQ);
val = IfThenExpression.Comparator.EQ;
      break;
      }
    case NE:{
      jj_consume_token(NE);
val = IfThenExpression.Comparator.NE;
      break;
      }
    case LE:{
      jj_consume_token(LE);
val = IfThenExpression.Comparator.LE;
      break;
      }
    case LT:{
      jj_consume_token(LT);
val = IfThenExpression.Comparator.LT;
      break;
      }
    case GE:{
      jj_consume_token(GE);
val = IfThenExpression.Comparator.GE;
      break;
      }
    case GT:{
      jj_consume_token(GT);
val = IfThenExpression.Comparator.GT;
      break;
      }
    default:
      jj_la1[13] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return val;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression indexExp() throws ParseException {String val = defaultFieldName;
    jj_consume_token(INDEX);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case STRING:
    case ATTRIBUTE:
    case BASE64_DECODE:
    case BASE64_ENCODE:
    case BINARIZE:
    case BUSY_WAIT:
    case CASE:
    case CASE_DEFAULT:
    case CHUNK:
    case CLEAR_STATE:
    case CREATE_IF_NON_EXISTENT:
    case ECHO:
    case ELSE:
    case EMBED:
    case GENERATE:
    case EXACT:
    case FLATTEN:
    case FOR_EACH:
    case GET_FIELD:
    case GET_VAR:
    case GUARD:
    case HASH:
    case HEX_DECODE:
    case HEX_ENCODE:
    case HOST_NAME:
    case IF:
    case INDEX:
    case INPUT:
    case JOIN:
    case LOWER_CASE:
    case MAX_LENGTH:
    case NGRAM:
    case NORMALIZE:
    case NOW:
    case OPTIMIZE_PREDICATE:
    case PACK_BITS:
    case PASSTHROUGH:
    case RANDOM:
    case REMOVE_IF_ZERO:
    case SELECT_INPUT:
    case SET_LANGUAGE:
    case SET_VAR:
    case SLEEP:
    case SPLIT:
    case STEM:
    case SUBSTRING:
    case SUMMARY:
    case SWITCH:
    case THIS:
    case TOKENIZE:
    case TO_ARRAY:
    case TO_BOOL:
    case TO_BYTE:
    case TO_DOUBLE:
    case TO_FLOAT:
    case TO_INT:
    case TO_LONG:
    case TO_POS:
    case TO_EPOCH_SECOND:
    case TO_STRING:
    case TO_URI:
    case TO_WSET:
    case TRIM:
    case ZCURVE:
    case TRUE:
    case FALSE:
    case IDENTIFIER:{
      val = fieldName();
      break;
      }
    default:
      jj_la1[14] = jj_gen;
      ;
    }
{if ("" != null) return new IndexExpression(val);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression inputExp() throws ParseException {String val = defaultFieldName;
    jj_consume_token(INPUT);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case STRING:
    case ATTRIBUTE:
    case BASE64_DECODE:
    case BASE64_ENCODE:
    case BINARIZE:
    case BUSY_WAIT:
    case CASE:
    case CASE_DEFAULT:
    case CHUNK:
    case CLEAR_STATE:
    case CREATE_IF_NON_EXISTENT:
    case ECHO:
    case ELSE:
    case EMBED:
    case GENERATE:
    case EXACT:
    case FLATTEN:
    case FOR_EACH:
    case GET_FIELD:
    case GET_VAR:
    case GUARD:
    case HASH:
    case HEX_DECODE:
    case HEX_ENCODE:
    case HOST_NAME:
    case IF:
    case INDEX:
    case INPUT:
    case JOIN:
    case LOWER_CASE:
    case MAX_LENGTH:
    case NGRAM:
    case NORMALIZE:
    case NOW:
    case OPTIMIZE_PREDICATE:
    case PACK_BITS:
    case PASSTHROUGH:
    case RANDOM:
    case REMOVE_IF_ZERO:
    case SELECT_INPUT:
    case SET_LANGUAGE:
    case SET_VAR:
    case SLEEP:
    case SPLIT:
    case STEM:
    case SUBSTRING:
    case SUMMARY:
    case SWITCH:
    case THIS:
    case TOKENIZE:
    case TO_ARRAY:
    case TO_BOOL:
    case TO_BYTE:
    case TO_DOUBLE:
    case TO_FLOAT:
    case TO_INT:
    case TO_LONG:
    case TO_POS:
    case TO_EPOCH_SECOND:
    case TO_STRING:
    case TO_URI:
    case TO_WSET:
    case TRIM:
    case ZCURVE:
    case TRUE:
    case FALSE:
    case IDENTIFIER:{
      val = identifier();
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      ;
    }
{if ("" != null) return new InputExpression(val);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression joinExp() throws ParseException {String val;
    jj_consume_token(JOIN);
    val = string();
{if ("" != null) return new JoinExpression(val);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression lowerCaseExp() throws ParseException {
    jj_consume_token(LOWER_CASE);
{if ("" != null) return new LowerCaseExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression ngramExp() throws ParseException {int gramSize;
    jj_consume_token(NGRAM);
    gramSize = integer();
{if ("" != null) return new NGramExpression(linguistics, gramSize);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression normalizeExp() throws ParseException {
    jj_consume_token(NORMALIZE);
{if ("" != null) return new NormalizeExpression(linguistics);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression nowExp() throws ParseException {
    jj_consume_token(NOW);
{if ("" != null) return new NowExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression optimizePredicateExp() throws ParseException {
    jj_consume_token(OPTIMIZE_PREDICATE);
{if ("" != null) return new OptimizePredicateExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression packBitsExp() throws ParseException {
    jj_consume_token(PACK_BITS);
{if ("" != null) return new PackBitsExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression passthroughExp() throws ParseException {String val = defaultFieldName;
    jj_consume_token(PASSTHROUGH);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case STRING:
    case ATTRIBUTE:
    case BASE64_DECODE:
    case BASE64_ENCODE:
    case BINARIZE:
    case BUSY_WAIT:
    case CASE:
    case CASE_DEFAULT:
    case CHUNK:
    case CLEAR_STATE:
    case CREATE_IF_NON_EXISTENT:
    case ECHO:
    case ELSE:
    case EMBED:
    case GENERATE:
    case EXACT:
    case FLATTEN:
    case FOR_EACH:
    case GET_FIELD:
    case GET_VAR:
    case GUARD:
    case HASH:
    case HEX_DECODE:
    case HEX_ENCODE:
    case HOST_NAME:
    case IF:
    case INDEX:
    case INPUT:
    case JOIN:
    case LOWER_CASE:
    case MAX_LENGTH:
    case NGRAM:
    case NORMALIZE:
    case NOW:
    case OPTIMIZE_PREDICATE:
    case PACK_BITS:
    case PASSTHROUGH:
    case RANDOM:
    case REMOVE_IF_ZERO:
    case SELECT_INPUT:
    case SET_LANGUAGE:
    case SET_VAR:
    case SLEEP:
    case SPLIT:
    case STEM:
    case SUBSTRING:
    case SUMMARY:
    case SWITCH:
    case THIS:
    case TOKENIZE:
    case TO_ARRAY:
    case TO_BOOL:
    case TO_BYTE:
    case TO_DOUBLE:
    case TO_FLOAT:
    case TO_INT:
    case TO_LONG:
    case TO_POS:
    case TO_EPOCH_SECOND:
    case TO_STRING:
    case TO_URI:
    case TO_WSET:
    case TRIM:
    case ZCURVE:
    case TRUE:
    case FALSE:
    case IDENTIFIER:{
      val = fieldName();
      break;
      }
    default:
      jj_la1[16] = jj_gen;
      ;
    }
{if ("" != null) return new PassthroughExpression(val);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression randomExp() throws ParseException {Integer val = null;
    jj_consume_token(RANDOM);
    if (jj_2_4(2)) {
      val = integer();
    } else {
      ;
    }
{if ("" != null) return new RandomExpression(val);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression selectInputExp() throws ParseException {List<Pair<String, Expression>> cases = new ArrayList<Pair<String, Expression>>();
    Expression exp;
    String str;
    jj_consume_token(SELECT_INPUT);
    jj_consume_token(LCURLY);
    nl();
    label_6:
    while (true) {
      str = identifier();
      jj_consume_token(COLON);
      exp = statement();
      jj_consume_token(SCOLON);
      nl();
cases.add(new Pair<String, Expression>(str, exp));
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case STRING:
      case ATTRIBUTE:
      case BASE64_DECODE:
      case BASE64_ENCODE:
      case BINARIZE:
      case BUSY_WAIT:
      case CASE:
      case CASE_DEFAULT:
      case CHUNK:
      case CLEAR_STATE:
      case CREATE_IF_NON_EXISTENT:
      case ECHO:
      case ELSE:
      case EMBED:
      case GENERATE:
      case EXACT:
      case FLATTEN:
      case FOR_EACH:
      case GET_FIELD:
      case GET_VAR:
      case GUARD:
      case HASH:
      case HEX_DECODE:
      case HEX_ENCODE:
      case HOST_NAME:
      case IF:
      case INDEX:
      case INPUT:
      case JOIN:
      case LOWER_CASE:
      case MAX_LENGTH:
      case NGRAM:
      case NORMALIZE:
      case NOW:
      case OPTIMIZE_PREDICATE:
      case PACK_BITS:
      case PASSTHROUGH:
      case RANDOM:
      case REMOVE_IF_ZERO:
      case SELECT_INPUT:
      case SET_LANGUAGE:
      case SET_VAR:
      case SLEEP:
      case SPLIT:
      case STEM:
      case SUBSTRING:
      case SUMMARY:
      case SWITCH:
      case THIS:
      case TOKENIZE:
      case TO_ARRAY:
      case TO_BOOL:
      case TO_BYTE:
      case TO_DOUBLE:
      case TO_FLOAT:
      case TO_INT:
      case TO_LONG:
      case TO_POS:
      case TO_EPOCH_SECOND:
      case TO_STRING:
      case TO_URI:
      case TO_WSET:
      case TRIM:
      case ZCURVE:
      case TRUE:
      case FALSE:
      case IDENTIFIER:{
        break;
        }
      default:
        jj_la1[17] = jj_gen;
        break label_6;
      }
    }
    jj_consume_token(RCURLY);
{if ("" != null) return new SelectInputExpression(cases);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression setLanguageExp() throws ParseException {
    jj_consume_token(SET_LANGUAGE);
{if ("" != null) return new SetLanguageExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression setValueExp() throws ParseException {FieldValue val;
    val = fieldValue();
{if ("" != null) return new ConstantExpression(val);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression setVarExp() throws ParseException {String val;
    jj_consume_token(SET_VAR);
    val = identifier();
{if ("" != null) return new SetVarExpression(val);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression sleepExp() throws ParseException {
    jj_consume_token(SLEEP);
{if ("" != null) return new SleepExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression splitExp() throws ParseException {String val;
    jj_consume_token(SPLIT);
    val = string();
{if ("" != null) return new SplitExpression(val);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression substringExp() throws ParseException {long from, to;
    jj_consume_token(SUBSTRING);
    from = integer();
    to = integer();
{if ("" != null) return new SubstringExpression((int)from, (int)to);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression summaryExp() throws ParseException {String val = defaultFieldName;
    jj_consume_token(SUMMARY);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case STRING:
    case ATTRIBUTE:
    case BASE64_DECODE:
    case BASE64_ENCODE:
    case BINARIZE:
    case BUSY_WAIT:
    case CASE:
    case CASE_DEFAULT:
    case CHUNK:
    case CLEAR_STATE:
    case CREATE_IF_NON_EXISTENT:
    case ECHO:
    case ELSE:
    case EMBED:
    case GENERATE:
    case EXACT:
    case FLATTEN:
    case FOR_EACH:
    case GET_FIELD:
    case GET_VAR:
    case GUARD:
    case HASH:
    case HEX_DECODE:
    case HEX_ENCODE:
    case HOST_NAME:
    case IF:
    case INDEX:
    case INPUT:
    case JOIN:
    case LOWER_CASE:
    case MAX_LENGTH:
    case NGRAM:
    case NORMALIZE:
    case NOW:
    case OPTIMIZE_PREDICATE:
    case PACK_BITS:
    case PASSTHROUGH:
    case RANDOM:
    case REMOVE_IF_ZERO:
    case SELECT_INPUT:
    case SET_LANGUAGE:
    case SET_VAR:
    case SLEEP:
    case SPLIT:
    case STEM:
    case SUBSTRING:
    case SUMMARY:
    case SWITCH:
    case THIS:
    case TOKENIZE:
    case TO_ARRAY:
    case TO_BOOL:
    case TO_BYTE:
    case TO_DOUBLE:
    case TO_FLOAT:
    case TO_INT:
    case TO_LONG:
    case TO_POS:
    case TO_EPOCH_SECOND:
    case TO_STRING:
    case TO_URI:
    case TO_WSET:
    case TRIM:
    case ZCURVE:
    case TRUE:
    case FALSE:
    case IDENTIFIER:{
      val = fieldName();
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      ;
    }
{if ("" != null) return new SummaryExpression(val);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression switchExp() throws ParseException {Map<String, Expression> cases = new LinkedHashMap<String, Expression>();
    Expression exp, defaultExp = null;
    String str;
    jj_consume_token(SWITCH);
    jj_consume_token(LCURLY);
    nl();
    label_7:
    while (true) {
      jj_consume_token(CASE);
      str = string();
      jj_consume_token(COLON);
      exp = statement();
cases.put(str, exp);
      jj_consume_token(SCOLON);
      nl();
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case CASE:{
        break;
        }
      default:
        jj_la1[19] = jj_gen;
        break label_7;
      }
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case CASE_DEFAULT:{
      jj_consume_token(CASE_DEFAULT);
      jj_consume_token(COLON);
      defaultExp = statement();
      jj_consume_token(SCOLON);
      nl();
      break;
      }
    default:
      jj_la1[20] = jj_gen;
      ;
    }
    jj_consume_token(RCURLY);
{if ("" != null) return new SwitchExpression(cases, defaultExp);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression thisExp() throws ParseException {
    jj_consume_token(THIS);
{if ("" != null) return new ThisExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression tokenizeExp() throws ParseException {AnnotatorConfig config = globalAnnotatorConfig;
    jj_consume_token(TOKENIZE);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case KEEP_CASE:
    case MAX_LENGTH:
    case MAX_OCCURRENCES:
    case MAX_TOKEN_LENGTH:
    case NORMALIZE:
    case STEM:{
      config = annotatorConfig();
      break;
      }
    default:
      jj_la1[21] = jj_gen;
      ;
    }
{if ("" != null) return new TokenizeExpression(linguistics, config);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public AnnotatorConfig annotatorConfig() throws ParseException {AnnotatorConfig config = new AnnotatorConfig(globalAnnotatorConfig);
    String str = "SHORTEST";
    Integer maxLength;
    Integer maxTermOccurrences;
    Integer maxTokenLength;
    label_8:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case STEM:{
        jj_consume_token(STEM);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COLON:{
          jj_consume_token(COLON);
          str = string();
          break;
          }
        default:
          jj_la1[22] = jj_gen;
          ;
        }
config.setStemMode(str);
        break;
        }
      case MAX_LENGTH:{
        jj_consume_token(MAX_LENGTH);
        jj_consume_token(COLON);
        maxLength = integer();
config.setMaxTokenizeLength(maxLength);
        break;
        }
      case MAX_OCCURRENCES:{
        jj_consume_token(MAX_OCCURRENCES);
        jj_consume_token(COLON);
        maxTermOccurrences = integer();
config.setMaxTermOccurrences(maxTermOccurrences);
        break;
        }
      case MAX_TOKEN_LENGTH:{
        jj_consume_token(MAX_TOKEN_LENGTH);
        jj_consume_token(COLON);
        maxTokenLength = integer();
config.setMaxTokenLength(maxTokenLength);
        break;
        }
      case NORMALIZE:{
        jj_consume_token(NORMALIZE);
config.setRemoveAccents(true);
        break;
        }
      case KEEP_CASE:{
        jj_consume_token(KEEP_CASE);
config.setLowercase(false);
        break;
        }
      default:
        jj_la1[23] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case KEEP_CASE:
      case MAX_LENGTH:
      case MAX_OCCURRENCES:
      case MAX_TOKEN_LENGTH:
      case NORMALIZE:
      case STEM:{
        break;
        }
      default:
        jj_la1[24] = jj_gen;
        break label_8;
      }
    }
{if ("" != null) return config;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression toArrayExp() throws ParseException {
    jj_consume_token(TO_ARRAY);
{if ("" != null) return new ToArrayExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression toBoolExp() throws ParseException {
    jj_consume_token(TO_BOOL);
{if ("" != null) return new ToBoolExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression toByteExp() throws ParseException {
    jj_consume_token(TO_BYTE);
{if ("" != null) return new ToByteExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression toDoubleExp() throws ParseException {
    jj_consume_token(TO_DOUBLE);
{if ("" != null) return new ToDoubleExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression toEpochSecondExp() throws ParseException {
    jj_consume_token(TO_EPOCH_SECOND);
{if ("" != null) return new ToEpochSecondExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression toFloatExp() throws ParseException {
    jj_consume_token(TO_FLOAT);
{if ("" != null) return new ToFloatExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression toIntExp() throws ParseException {
    jj_consume_token(TO_INT);
{if ("" != null) return new ToIntegerExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression toLongExp() throws ParseException {
    jj_consume_token(TO_LONG);
{if ("" != null) return new ToLongExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression toPosExp() throws ParseException {
    jj_consume_token(TO_POS);
{if ("" != null) return new ToPositionExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression toStringExp() throws ParseException {
    jj_consume_token(TO_STRING);
{if ("" != null) return new ToStringExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression toUriExp() throws ParseException {
    jj_consume_token(TO_URI);
{if ("" != null) return new ToUriExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression toWsetExp() throws ParseException {boolean createIfNonExistent = false;
    boolean removeIfZero = false;
    jj_consume_token(TO_WSET);
    label_9:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case CREATE_IF_NON_EXISTENT:
      case REMOVE_IF_ZERO:{
        break;
        }
      default:
        jj_la1[25] = jj_gen;
        break label_9;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case CREATE_IF_NON_EXISTENT:{
        jj_consume_token(CREATE_IF_NON_EXISTENT);
createIfNonExistent = true;
        break;
        }
      case REMOVE_IF_ZERO:{
        jj_consume_token(REMOVE_IF_ZERO);
removeIfZero = true;
        break;
        }
      default:
        jj_la1[26] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return new ToWsetExpression(createIfNonExistent, removeIfZero);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression trimExp() throws ParseException {
    jj_consume_token(TRIM);
{if ("" != null) return new TrimExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression literalBoolExp() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TRUE:{
      jj_consume_token(TRUE);
      break;
      }
    case FALSE:{
      jj_consume_token(FALSE);
      break;
      }
    default:
      jj_la1[27] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return new LiteralBoolExpression(Boolean.parseBoolean(token.image));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression zcurveExp() throws ParseException {
    jj_consume_token(ZCURVE);
{if ("" != null) return new ZCurveExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression binarizeExp() throws ParseException {NumericFieldValue threshold = new DoubleFieldValue(0);
    jj_consume_token(BINARIZE);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case INTEGER:
    case LONG:
    case DOUBLE:
    case FLOAT:
    case ADD:
    case SUB:{
      threshold = numericValue();
      break;
      }
    default:
      jj_la1[28] = jj_gen;
      ;
    }
{if ("" != null) return new BinarizeExpression(threshold.getNumber().doubleValue());}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Expression executionValueExp() throws ParseException {
    jj_consume_token(UNDERSCORE);
{if ("" != null) return new ExecutionValueExpression();}
    throw new IllegalStateException ("Missing return statement in function");
}

/** A possibly empty list of arguments that can be strings or numbers. */
  final public List<String> arguments() throws ParseException {String argument;
    NumericFieldValue numericArgument;
    List<String> arguments = new ArrayList<String>();
    label_10:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case INTEGER:
      case LONG:
      case DOUBLE:
      case FLOAT:
      case ADD:
      case SUB:
      case STRING:
      case ATTRIBUTE:
      case BASE64_DECODE:
      case BASE64_ENCODE:
      case BINARIZE:
      case BUSY_WAIT:
      case CASE:
      case CASE_DEFAULT:
      case CHUNK:
      case CLEAR_STATE:
      case CREATE_IF_NON_EXISTENT:
      case ECHO:
      case ELSE:
      case EMBED:
      case GENERATE:
      case EXACT:
      case FLATTEN:
      case FOR_EACH:
      case GET_FIELD:
      case GET_VAR:
      case GUARD:
      case HASH:
      case HEX_DECODE:
      case HEX_ENCODE:
      case HOST_NAME:
      case IF:
      case INDEX:
      case INPUT:
      case JOIN:
      case LOWER_CASE:
      case MAX_LENGTH:
      case NGRAM:
      case NORMALIZE:
      case NOW:
      case OPTIMIZE_PREDICATE:
      case PACK_BITS:
      case PASSTHROUGH:
      case RANDOM:
      case REMOVE_IF_ZERO:
      case SELECT_INPUT:
      case SET_LANGUAGE:
      case SET_VAR:
      case SLEEP:
      case SPLIT:
      case STEM:
      case SUBSTRING:
      case SUMMARY:
      case SWITCH:
      case THIS:
      case TOKENIZE:
      case TO_ARRAY:
      case TO_BOOL:
      case TO_BYTE:
      case TO_DOUBLE:
      case TO_FLOAT:
      case TO_INT:
      case TO_LONG:
      case TO_POS:
      case TO_EPOCH_SECOND:
      case TO_STRING:
      case TO_URI:
      case TO_WSET:
      case TRIM:
      case ZCURVE:
      case TRUE:
      case FALSE:
      case IDENTIFIER:{
        break;
        }
      default:
        jj_la1[29] = jj_gen;
        break label_10;
      }
      if (jj_2_5(2)) {
        argument = identifier();
arguments.add(argument);
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case INTEGER:
        case LONG:
        case DOUBLE:
        case FLOAT:
        case ADD:
        case SUB:{
          numericArgument = numericValue();
arguments.add(numericArgument.getNumber().toString());
          break;
          }
        default:
          jj_la1[30] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
{if ("" != null) return arguments;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String identifier() throws ParseException {String val;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case STRING:{
      val = string();
      break;
      }
    case ATTRIBUTE:
    case BASE64_DECODE:
    case BASE64_ENCODE:
    case BINARIZE:
    case BUSY_WAIT:
    case CASE:
    case CASE_DEFAULT:
    case CHUNK:
    case CLEAR_STATE:
    case CREATE_IF_NON_EXISTENT:
    case ECHO:
    case ELSE:
    case EMBED:
    case GENERATE:
    case EXACT:
    case FLATTEN:
    case FOR_EACH:
    case GET_FIELD:
    case GET_VAR:
    case GUARD:
    case HASH:
    case HEX_DECODE:
    case HEX_ENCODE:
    case HOST_NAME:
    case IF:
    case INDEX:
    case INPUT:
    case JOIN:
    case LOWER_CASE:
    case MAX_LENGTH:
    case NGRAM:
    case NORMALIZE:
    case NOW:
    case OPTIMIZE_PREDICATE:
    case PACK_BITS:
    case PASSTHROUGH:
    case RANDOM:
    case REMOVE_IF_ZERO:
    case SELECT_INPUT:
    case SET_LANGUAGE:
    case SET_VAR:
    case SLEEP:
    case SPLIT:
    case STEM:
    case SUBSTRING:
    case SUMMARY:
    case SWITCH:
    case THIS:
    case TOKENIZE:
    case TO_ARRAY:
    case TO_BOOL:
    case TO_BYTE:
    case TO_DOUBLE:
    case TO_FLOAT:
    case TO_INT:
    case TO_LONG:
    case TO_POS:
    case TO_EPOCH_SECOND:
    case TO_STRING:
    case TO_URI:
    case TO_WSET:
    case TRIM:
    case ZCURVE:
    case TRUE:
    case FALSE:
    case IDENTIFIER:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ATTRIBUTE:{
        jj_consume_token(ATTRIBUTE);
        break;
        }
      case BASE64_DECODE:{
        jj_consume_token(BASE64_DECODE);
        break;
        }
      case BASE64_ENCODE:{
        jj_consume_token(BASE64_ENCODE);
        break;
        }
      case BINARIZE:{
        jj_consume_token(BINARIZE);
        break;
        }
      case BUSY_WAIT:{
        jj_consume_token(BUSY_WAIT);
        break;
        }
      case CASE:{
        jj_consume_token(CASE);
        break;
        }
      case CASE_DEFAULT:{
        jj_consume_token(CASE_DEFAULT);
        break;
        }
      case CHUNK:{
        jj_consume_token(CHUNK);
        break;
        }
      case CLEAR_STATE:{
        jj_consume_token(CLEAR_STATE);
        break;
        }
      case CREATE_IF_NON_EXISTENT:{
        jj_consume_token(CREATE_IF_NON_EXISTENT);
        break;
        }
      case ECHO:{
        jj_consume_token(ECHO);
        break;
        }
      case EXACT:{
        jj_consume_token(EXACT);
        break;
        }
      case ELSE:{
        jj_consume_token(ELSE);
        break;
        }
      case EMBED:{
        jj_consume_token(EMBED);
        break;
        }
      case GENERATE:{
        jj_consume_token(GENERATE);
        break;
        }
      case FLATTEN:{
        jj_consume_token(FLATTEN);
        break;
        }
      case FOR_EACH:{
        jj_consume_token(FOR_EACH);
        break;
        }
      case GET_FIELD:{
        jj_consume_token(GET_FIELD);
        break;
        }
      case GET_VAR:{
        jj_consume_token(GET_VAR);
        break;
        }
      case GUARD:{
        jj_consume_token(GUARD);
        break;
        }
      case HASH:{
        jj_consume_token(HASH);
        break;
        }
      case HEX_DECODE:{
        jj_consume_token(HEX_DECODE);
        break;
        }
      case HEX_ENCODE:{
        jj_consume_token(HEX_ENCODE);
        break;
        }
      case HOST_NAME:{
        jj_consume_token(HOST_NAME);
        break;
        }
      case IDENTIFIER:{
        jj_consume_token(IDENTIFIER);
        break;
        }
      case IF:{
        jj_consume_token(IF);
        break;
        }
      case INDEX:{
        jj_consume_token(INDEX);
        break;
        }
      case INPUT:{
        jj_consume_token(INPUT);
        break;
        }
      case JOIN:{
        jj_consume_token(JOIN);
        break;
        }
      case LOWER_CASE:{
        jj_consume_token(LOWER_CASE);
        break;
        }
      case MAX_LENGTH:{
        jj_consume_token(MAX_LENGTH);
        break;
        }
      case NGRAM:{
        jj_consume_token(NGRAM);
        break;
        }
      case NORMALIZE:{
        jj_consume_token(NORMALIZE);
        break;
        }
      case NOW:{
        jj_consume_token(NOW);
        break;
        }
      case OPTIMIZE_PREDICATE:{
        jj_consume_token(OPTIMIZE_PREDICATE);
        break;
        }
      case PACK_BITS:{
        jj_consume_token(PACK_BITS);
        break;
        }
      case PASSTHROUGH:{
        jj_consume_token(PASSTHROUGH);
        break;
        }
      case RANDOM:{
        jj_consume_token(RANDOM);
        break;
        }
      case REMOVE_IF_ZERO:{
        jj_consume_token(REMOVE_IF_ZERO);
        break;
        }
      case SELECT_INPUT:{
        jj_consume_token(SELECT_INPUT);
        break;
        }
      case SET_LANGUAGE:{
        jj_consume_token(SET_LANGUAGE);
        break;
        }
      case SET_VAR:{
        jj_consume_token(SET_VAR);
        break;
        }
      case SLEEP:{
        jj_consume_token(SLEEP);
        break;
        }
      case SPLIT:{
        jj_consume_token(SPLIT);
        break;
        }
      case STEM:{
        jj_consume_token(STEM);
        break;
        }
      case SUBSTRING:{
        jj_consume_token(SUBSTRING);
        break;
        }
      case SUMMARY:{
        jj_consume_token(SUMMARY);
        break;
        }
      case SWITCH:{
        jj_consume_token(SWITCH);
        break;
        }
      case THIS:{
        jj_consume_token(THIS);
        break;
        }
      case TO_ARRAY:{
        jj_consume_token(TO_ARRAY);
        break;
        }
      case TO_BOOL:{
        jj_consume_token(TO_BOOL);
        break;
        }
      case TO_BYTE:{
        jj_consume_token(TO_BYTE);
        break;
        }
      case TO_DOUBLE:{
        jj_consume_token(TO_DOUBLE);
        break;
        }
      case TO_EPOCH_SECOND:{
        jj_consume_token(TO_EPOCH_SECOND);
        break;
        }
      case TO_FLOAT:{
        jj_consume_token(TO_FLOAT);
        break;
        }
      case TO_INT:{
        jj_consume_token(TO_INT);
        break;
        }
      case TO_LONG:{
        jj_consume_token(TO_LONG);
        break;
        }
      case TO_POS:{
        jj_consume_token(TO_POS);
        break;
        }
      case TO_STRING:{
        jj_consume_token(TO_STRING);
        break;
        }
      case TO_URI:{
        jj_consume_token(TO_URI);
        break;
        }
      case TO_WSET:{
        jj_consume_token(TO_WSET);
        break;
        }
      case TOKENIZE:{
        jj_consume_token(TOKENIZE);
        break;
        }
      case TRIM:{
        jj_consume_token(TRIM);
        break;
        }
      case TRUE:{
        jj_consume_token(TRUE);
        break;
        }
      case FALSE:{
        jj_consume_token(FALSE);
        break;
        }
      case ZCURVE:{
        jj_consume_token(ZCURVE);
        break;
        }
      default:
        jj_la1[31] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
val = token.image;
      break;
      }
    default:
      jj_la1[32] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return val;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String fieldName() throws ParseException {StringBuilder builder = new StringBuilder();
    String str;
    str = identifier();
builder.append(str);
    label_11:
    while (true) {
      if (jj_2_6(2)) {
      } else {
        break label_11;
      }
      jj_consume_token(DOT);
builder.append(token.image);
      str = identifier();
builder.append(str);
    }
{if ("" != null) return builder.toString();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public FieldValue fieldValue() throws ParseException {FieldValue val;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case INTEGER:
    case LONG:
    case DOUBLE:
    case FLOAT:
    case ADD:
    case SUB:{
      val = numericValue();
      break;
      }
    case STRING:{
      val = stringValue();
      break;
      }
    default:
      jj_la1[33] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return val;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NumericFieldValue numericValue() throws ParseException {NumericFieldValue val;
    String pre = "";
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ADD:
    case SUB:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ADD:{
        jj_consume_token(ADD);
        break;
        }
      case SUB:{
        jj_consume_token(SUB);
pre = "-";
        break;
        }
      default:
        jj_la1[34] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[35] = jj_gen;
      ;
    }
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DOUBLE:{
      jj_consume_token(DOUBLE);
val = parseDouble(pre + token.image);
      break;
      }
    case FLOAT:{
      jj_consume_token(FLOAT);
val = parseFloat(pre + token.image);
      break;
      }
    case INTEGER:{
      jj_consume_token(INTEGER);
val = parseInteger(pre + token.image);
      break;
      }
    case LONG:{
      jj_consume_token(LONG);
val = parseLong(pre + token.image);
      break;
      }
    default:
      jj_la1[36] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return val;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public FieldValue stringValue() throws ParseException {String val;
    val = string();
{if ("" != null) return new StringFieldValue(val);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String string() throws ParseException {
    jj_consume_token(STRING);
{if ("" != null) return StringUtilities.unescape(token.image.substring(1, token.image.length() - 1));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public int integer() throws ParseException {String pre = "";
    int val;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ADD:
    case SUB:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ADD:{
        jj_consume_token(ADD);
        break;
        }
      case SUB:{
        jj_consume_token(SUB);
pre = "-";
        break;
        }
      default:
        jj_la1[37] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[38] = jj_gen;
      ;
    }
    jj_consume_token(INTEGER);
val = Integer.parseInt(pre + token.image);
{if ("" != null) return val;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void nl() throws ParseException {
    label_12:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case NL:{
        break;
        }
      default:
        jj_la1[39] = jj_gen;
        break label_12;
      }
      jj_consume_token(NL);
    }
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_3R_19()
 {
    if (jj_scan_token(SUB)) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_3R_13()) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_13()) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_3R_14()) return true;
    return false;
  }

  private boolean jj_3R_18()
 {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_3R_13()) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_3R_13()) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_13()) return true;
    return false;
  }

  private boolean jj_3R_14()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_17()) jj_scanpos = xsp;
    if (jj_scan_token(INTEGER)) return true;
    return false;
  }

  private boolean jj_3R_13()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_15()) {
    jj_scanpos = xsp;
    if (jj_3R_16()) return true;
    }
    return false;
  }

  private boolean jj_3R_15()
 {
    if (jj_3R_18()) return true;
    return false;
  }

  private boolean jj_3R_16()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(34)) {
    jj_scanpos = xsp;
    if (jj_scan_token(35)) {
    jj_scanpos = xsp;
    if (jj_scan_token(36)) {
    jj_scanpos = xsp;
    if (jj_scan_token(37)) {
    jj_scanpos = xsp;
    if (jj_scan_token(38)) {
    jj_scanpos = xsp;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(41)) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(44)) {
    jj_scanpos = xsp;
    if (jj_scan_token(45)) {
    jj_scanpos = xsp;
    if (jj_scan_token(46)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) {
    jj_scanpos = xsp;
    if (jj_scan_token(56)) {
    jj_scanpos = xsp;
    if (jj_scan_token(102)) {
    jj_scanpos = xsp;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_scan_token(58)) {
    jj_scanpos = xsp;
    if (jj_scan_token(59)) {
    jj_scanpos = xsp;
    if (jj_scan_token(60)) {
    jj_scanpos = xsp;
    if (jj_scan_token(62)) {
    jj_scanpos = xsp;
    if (jj_scan_token(63)) {
    jj_scanpos = xsp;
    if (jj_scan_token(66)) {
    jj_scanpos = xsp;
    if (jj_scan_token(67)) {
    jj_scanpos = xsp;
    if (jj_scan_token(68)) {
    jj_scanpos = xsp;
    if (jj_scan_token(69)) {
    jj_scanpos = xsp;
    if (jj_scan_token(70)) {
    jj_scanpos = xsp;
    if (jj_scan_token(71)) {
    jj_scanpos = xsp;
    if (jj_scan_token(72)) {
    jj_scanpos = xsp;
    if (jj_scan_token(73)) {
    jj_scanpos = xsp;
    if (jj_scan_token(74)) {
    jj_scanpos = xsp;
    if (jj_scan_token(75)) {
    jj_scanpos = xsp;
    if (jj_scan_token(76)) {
    jj_scanpos = xsp;
    if (jj_scan_token(77)) {
    jj_scanpos = xsp;
    if (jj_scan_token(78)) {
    jj_scanpos = xsp;
    if (jj_scan_token(79)) {
    jj_scanpos = xsp;
    if (jj_scan_token(80)) {
    jj_scanpos = xsp;
    if (jj_scan_token(81)) {
    jj_scanpos = xsp;
    if (jj_scan_token(82)) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) {
    jj_scanpos = xsp;
    if (jj_scan_token(85)) {
    jj_scanpos = xsp;
    if (jj_scan_token(86)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_scan_token(88)) {
    jj_scanpos = xsp;
    if (jj_scan_token(93)) {
    jj_scanpos = xsp;
    if (jj_scan_token(89)) {
    jj_scanpos = xsp;
    if (jj_scan_token(90)) {
    jj_scanpos = xsp;
    if (jj_scan_token(91)) {
    jj_scanpos = xsp;
    if (jj_scan_token(92)) {
    jj_scanpos = xsp;
    if (jj_scan_token(94)) {
    jj_scanpos = xsp;
    if (jj_scan_token(95)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) {
    jj_scanpos = xsp;
    if (jj_scan_token(97)) {
    jj_scanpos = xsp;
    if (jj_scan_token(99)) {
    jj_scanpos = xsp;
    if (jj_scan_token(100)) {
    jj_scanpos = xsp;
    if (jj_scan_token(98)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_17()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_3R_19()) return true;
    }
    return false;
  }

  /** Generated Token Manager. */
  public IndexingParserTokenManager token_source;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[40];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	   jj_la1_init_2();
	   jj_la1_init_3();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x80000000,0x80000000,0x5001bc0,0x800000,0x400000,0x10000000,0xf800,0xf800,0x5001bc0,0x0,0x0,0x0,0x0,0x3f0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x1bc0,0x1bc0,0x1bc0,0x0,0x0,0x1bc0,0x1800,0x1800,0x3c0,0x1800,0x1800,0x400,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x0,0x0,0x5fffeb3f,0x0,0x0,0x0,0x0,0x0,0x5fffeb3f,0xdfffffff,0xa0000000,0x0,0x1000,0x0,0xdfffffff,0xdfffffff,0xdfffffff,0xdfffffff,0xdfffffff,0x40,0x80,0xa0000000,0x0,0xa0000000,0xa0000000,0x400,0x400,0x0,0x0,0xdfffffff,0x0,0xdffffffe,0xdfffffff,0x1,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_2() {
	   jj_la1_2 = new int[] {0x0,0x0,0xffff7dfc,0x0,0x0,0x0,0x0,0x0,0xffff7dfc,0xfffffffc,0x800b,0x0,0x0,0x0,0xfffffffc,0xfffffffc,0xfffffffc,0xfffffffc,0xfffffffc,0x0,0x0,0x800b,0x0,0x800b,0x800b,0x200,0x200,0x0,0x0,0xfffffffc,0x0,0xfffffffc,0xfffffffc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_3() {
	   jj_la1_3 = new int[] {0x0,0x0,0x3f,0x0,0x0,0x0,0x0,0x0,0x3f,0x5f,0x0,0x80,0x0,0x0,0x5f,0x5f,0x5f,0x5f,0x5f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x18,0x0,0x5f,0x0,0x5f,0x5f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
  private final JJCalls[] jj_2_rtns = new JJCalls[6];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /**
   * Constructor with user supplied CharStream.
   * @param stream stream to init with
   */
  public IndexingParser(final CharStream stream) {
	 token_source = new IndexingParserTokenManager(stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 40; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise.
   * @param stream stream to init with
   */
  public void ReInit(final CharStream stream) {
	 token_source.ReInit(stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
   for (int i = 0; i < 40; i++)
     jj_la1[i] = -1;
   for (int i = 0; i < jj_2_rtns.length; i++)
     jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Constructor with generated Token Manager.
   * @param tm Token manager to use
   */
  public IndexingParser(final IndexingParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 40; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise
   * @param tm Token manager to use
   */
  public void ReInit(final IndexingParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 40; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(final int kind) throws ParseException {
    final Token oldToken = token;
    if (token.next != null)
      token = token.next;
    else {
      token.next = token_source.getNextToken();
      token = token.next;
    }
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen)
              c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  private static final class LookaheadSuccess extends IllegalStateException {}
  private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		   jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		   jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


  /**
   * @return the next Token.
   */
  public final Token getNextToken() {
   if (token.next != null)
     token = token.next;
   else
     token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

  /**
   * @param index index to be retrieved
   * @return the specific Token.
   */
  public final Token getToken(final int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next == null)
        t.next = token_source.getNextToken();
      t = t.next;
    }
    return t;
  }

  private int jj_ntk_f() {
    final Token nt = jj_nt = token.next;
    final int ret;
    if (nt == null) {
      token.next = token_source.getNextToken();
      ret = jj_ntk = token.next.kind;
    }
    else
      ret = jj_ntk = nt.kind;
    return ret;
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
  if (pos >= 100) {
    return;
  }

  if (pos == jj_endpos + 1) {
    jj_lasttokens[jj_endpos++] = kind;
  } else if (jj_endpos != 0) {
    jj_expentry = new int[jj_endpos];

    for (int i = 0; i < jj_endpos; i++) {
      jj_expentry[i] = jj_lasttokens[i];
    }

    for (final int[] oldentry : jj_expentries) {
      if (oldentry.length == jj_expentry.length) {
        boolean isMatched = true;
        for (int i = 0; i < jj_expentry.length; i++) {
          if (oldentry[i] != jj_expentry[i]) {
            isMatched = false;
            break;
          }
        }
        if (isMatched) {
          jj_expentries.add(jj_expentry);
          break;
        }
      }
    }

    if (pos != 0) {
      jj_endpos = pos;
      jj_lasttokens[jj_endpos - 1] = kind;
    }
  }
}

  /**
   * Generate ParseException.
   * @return new Exception object. Never <code>null</code>
   */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[104];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 40; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 104; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /**
   * @return Always <code>false</code>.
   */
  public final boolean trace_enabled() {
    return false;
  }

  /** Enable tracing. */
  public final void enable_tracing() {}

  /** Disable tracing. */
  public final void disable_tracing() {}

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 6; i++) {
      try {
        JJCalls p = jj_2_rtns[i];
        do {
          if (p.gen > jj_gen) {
            jj_la = p.arg;
            jj_scanpos = p.first;
            jj_lastpos = p.first;
            switch (i) {
              case 0: jj_3_1(); break;
              case 1: jj_3_2(); break;
              case 2: jj_3_3(); break;
              case 3: jj_3_4(); break;
              case 4: jj_3_5(); break;
              case 5: jj_3_6(); break;
            }
          }
          p = p.next;
        } while (p != null);
      } catch(LookaheadSuccess ls) { /* ignore */ }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) {
        p.next = new JJCalls();
        p = p.next;
        break;
      }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; 
    p.first = token;
    p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
