/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.FieldPath;
import com.yahoo.vespa.indexinglanguage.expressions.AnyDataType;
import com.yahoo.vespa.indexinglanguage.expressions.ChoiceExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.TypeContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class InputExpression
extends Expression {
    private final String fieldName;
    private FieldPath fieldPath;

    public InputExpression(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("'input' must be given a field name as argument");
        }
        this.fieldName = fieldName;
    }

    @Override
    public boolean requiresInput() {
        return false;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public DataType setInputType(DataType inputType, TypeContext context) {
        super.setInputType(inputType, context);
        return this.requireFieldType(context);
    }

    @Override
    public DataType setOutputType(DataType outputType, TypeContext context) {
        super.setOutputType(this.requireFieldType(context), outputType, null, context);
        return AnyDataType.instance;
    }

    private DataType requireFieldType(TypeContext context) {
        DataType fieldType = context.getFieldType(this.fieldName, this);
        if (fieldType == null) {
            throw new VerificationException(this, "Field '" + this.fieldName + "' not found");
        }
        return fieldType;
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        if (this.fieldPath != null) {
            context.setCurrentValue(context.getFieldValue(this.fieldPath));
        } else {
            context.setCurrentValue(context.getFieldValue(this.fieldName));
        }
    }

    @Override
    public DataType getOutputType(TypeContext context) {
        return context.getFieldType(this.fieldName, this);
    }

    public String toString() {
        return "input " + this.fieldName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InputExpression)) {
            return false;
        }
        InputExpression rhs = (InputExpression)((Object)obj);
        return Objects.equals(this.fieldName, rhs.fieldName);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + this.fieldName.hashCode();
    }

    public static class RequiredInputFieldsExtractor
    implements ObjectOperation,
    ObjectPredicate {
        private final Set<String> inputFieldNames = new HashSet<String>();

        public void execute(Object obj) {
            if (obj instanceof InputExpression) {
                InputExpression input = (InputExpression)((Object)obj);
                this.inputFieldNames.add(input.getFieldName());
            }
            if (obj instanceof ChoiceExpression) {
                ChoiceExpression choice = (ChoiceExpression)obj;
                HashSet<String> required = null;
                for (Expression child : choice.asList()) {
                    if (required == null) {
                        required = new HashSet<String>();
                        required.addAll(RequiredInputFieldsExtractor.runOn(child));
                        continue;
                    }
                    required.retainAll(RequiredInputFieldsExtractor.runOn(child));
                }
                this.inputFieldNames.addAll(required);
            }
        }

        public boolean check(Object obj) {
            return obj instanceof InputExpression || obj instanceof ChoiceExpression;
        }

        public static Set<String> runOn(Expression expression) {
            RequiredInputFieldsExtractor extractor = new RequiredInputFieldsExtractor();
            expression.select(extractor, extractor);
            return extractor.inputFieldNames;
        }
    }

    public static class InputFieldNameExtractor
    implements ObjectOperation,
    ObjectPredicate {
        private final List<String> inputFieldNames = new ArrayList<String>(1);

        public void execute(Object obj) {
            this.inputFieldNames.add(((InputExpression)((Object)obj)).getFieldName());
        }

        public boolean check(Object obj) {
            return obj instanceof InputExpression;
        }

        public static List<String> runOn(Expression expression) {
            InputFieldNameExtractor inputFieldNameExtractor = new InputFieldNameExtractor();
            expression.select(inputFieldNameExtractor, inputFieldNameExtractor);
            return inputFieldNameExtractor.inputFieldNames;
        }
    }

    public static class FieldPathOptimizer
    implements ObjectOperation,
    ObjectPredicate {
        private final DocumentType documentType;

        public FieldPathOptimizer(DocumentType documentType) {
            this.documentType = documentType;
        }

        public void execute(Object obj) {
            InputExpression exp = (InputExpression)((Object)obj);
            exp.fieldPath = this.documentType.buildFieldPath(exp.getFieldName());
        }

        public boolean check(Object obj) {
            return obj instanceof InputExpression;
        }
    }
}

