/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.TypeContext;
import java.util.Base64;

public final class Base64DecodeExpression
extends Expression {
    @Override
    public DataType setInputType(DataType inputType, TypeContext context) {
        super.setInputType(inputType, (DataType)DataType.STRING, context);
        return DataType.LONG;
    }

    @Override
    public DataType setOutputType(DataType outputType, TypeContext context) {
        super.setOutputType((DataType)DataType.LONG, outputType, null, context);
        return DataType.STRING;
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        String input = String.valueOf(context.getCurrentValue());
        if (input.isEmpty()) {
            context.setCurrentValue((FieldValue)new LongFieldValue(Long.MIN_VALUE));
            return;
        }
        if (input.length() > 12) {
            throw new NumberFormatException("Base64 value '" + input + "' is out of range");
        }
        byte[] decoded = Base64.getDecoder().decode(input);
        if (decoded == null || decoded.length == 0) {
            throw new NumberFormatException("Illegal base64 value '" + input + "'");
        }
        long output = 0L;
        int i = decoded.length;
        while (--i >= 0) {
            output = (output << 8) + (long)(decoded[i] & 0xFF);
        }
        context.setCurrentValue((FieldValue)new LongFieldValue(output));
    }

    public String toString() {
        return "base64decode";
    }

    public boolean equals(Object obj) {
        return obj instanceof Base64DecodeExpression;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

