package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.NumericFieldValue;

/**
 * Utility expression that will busy-wait the amount of time given in the numeric field.
 * Non-numeric fields will be ignored.
 *
 * @author baldersheim
 */
public final class BusyWaitExpression extends Expression {

    @Override
    public boolean isMutating() { return false; }

    @Override
    protected void doExecute(ExecutionContext context) {
        FieldValue value = context.getCurrentValue();
        if (value instanceof NumericFieldValue num) {
            double napSecs = num.getNumber().doubleValue();
            long doom = System.nanoTime() + (long)(1_000_000_000.0 * napSecs);
            while (doom > System.nanoTime()) {
                double pi = 3;
                for (int i = 0; i < 1000; i++) {
                    pi += nihlakanta(i);
                }
                context.getCache().put("Busy wait computing pi and store it to avoid jit optiming it away", pi);
            }
        }
    }

    private static double nihlakanta(int i) {
        long a = 2 + i * 4L;
        return (24 * (a+2))/(double)(a*(a+1)*(a+2)*(a+3));
    }

    @Override public String toString() { return "busy_wait"; }
    @Override public boolean equals(Object obj) { return obj instanceof BusyWaitExpression; }
    @Override public int hashCode() { return getClass().hashCode(); }

}
