/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.language.Linguistics;
import com.yahoo.language.process.Chunker;
import com.yahoo.language.process.Embedder;
import com.yahoo.language.process.FieldGenerator;
import com.yahoo.language.simple.SimpleLinguistics;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.ScriptParser;
import com.yahoo.vespa.indexinglanguage.ScriptParserContext;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.ExpressionList;
import com.yahoo.vespa.indexinglanguage.expressions.StatementExpression;
import com.yahoo.vespa.indexinglanguage.expressions.TypeContext;
import com.yahoo.vespa.indexinglanguage.parser.IndexingInput;
import com.yahoo.vespa.indexinglanguage.parser.ParseException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class ScriptExpression
extends ExpressionList<StatementExpression> {
    public ScriptExpression() {
        this(List.of());
    }

    public ScriptExpression(StatementExpression ... statements) {
        this((Collection<? extends StatementExpression>)List.of(statements));
    }

    public ScriptExpression(Collection<? extends StatementExpression> statements) {
        super(statements);
    }

    @Override
    public ScriptExpression convertChildren(ExpressionConverter converter) {
        return new ScriptExpression((Collection<? extends StatementExpression>)this.asList().stream().map(child -> (StatementExpression)converter.branch().convert((Expression)((Object)child))).filter(Objects::nonNull).toList());
    }

    @Override
    public boolean isMutating() {
        List expressions = this.asList();
        if (expressions.isEmpty()) {
            return false;
        }
        return ((StatementExpression)expressions.get(expressions.size() - 1)).isMutating();
    }

    @Override
    public boolean requiresInput() {
        return this.expressions().stream().anyMatch(statement -> statement.requiresInput());
    }

    @Override
    public DataType setInputType(DataType inputType, TypeContext context) {
        super.setInputType(inputType, context);
        DataType currentOutput = null;
        for (StatementExpression expression : this.expressions()) {
            currentOutput = expression.setInputType(inputType, context);
        }
        return currentOutput != null ? currentOutput : this.getOutputType(context);
    }

    @Override
    public DataType setOutputType(DataType outputType, TypeContext context) {
        super.setOutputType(outputType, context);
        DataType currentInput = null;
        if (!this.expressions().isEmpty()) {
            currentInput = ((StatementExpression)this.expressions().get(this.expressions().size() - 1)).setOutputType(outputType, context);
        }
        return currentInput != null ? currentInput : this.getInputType(context);
    }

    @Override
    protected void doResolve(TypeContext context) {
        for (Expression exp : this) {
            context.resolve(exp);
        }
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        FieldValue input = context.getCurrentValue();
        for (StatementExpression statement : this) {
            if (!context.isComplete() && !statement.getInputFields().isEmpty() && !this.containsAtLeastOneInputFrom(statement.getInputFields(), context)) continue;
            context.setCurrentValue(input);
            context.execute(statement);
        }
        context.setCurrentValue(input);
    }

    private boolean containsAtLeastOneInputFrom(List<String> inputFields, ExecutionContext context) {
        for (String inputField : inputFields) {
            if (context.getFieldValue(inputField) == null) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("{ ");
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ret.append(it.next()).append(";");
            if (!it.hasNext()) continue;
            ret.append(" ");
        }
        ret.append(" }");
        return ret.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof ScriptExpression;
    }

    public static ScriptExpression fromString(String expression) throws ParseException {
        return ScriptExpression.fromString(expression, (Linguistics)new SimpleLinguistics(), Map.of(), Embedder.throwsOnUse.asMap(), Map.of());
    }

    public static ScriptExpression fromString(String expression, Linguistics linguistics, Map<String, Chunker> chunkers, Map<String, Embedder> embedders, Map<String, FieldGenerator> generators) throws ParseException {
        return ScriptExpression.newInstance(new ScriptParserContext(linguistics, chunkers, embedders, generators).setInputStream(new IndexingInput(expression)));
    }

    public static ScriptExpression newInstance(ScriptParserContext config) throws ParseException {
        return ScriptParser.parseScript(config);
    }
}

