/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.collections.LazyMap;
import com.yahoo.document.FieldPath;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.language.Language;
import com.yahoo.language.Linguistics;
import com.yahoo.language.detect.Detection;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.FieldValues;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ExecutionContext {
    private final Map<String, FieldValue> variables = new HashMap<String, FieldValue>();
    private final FieldValues fieldValues;
    private FieldValue currentValue;
    private Language language;
    private final Map<Object, Object> cache = LazyMap.newHashMap();

    public ExecutionContext() {
        this(null);
    }

    public ExecutionContext(FieldValues fieldValue) {
        this.fieldValues = fieldValue;
        this.language = Language.UNKNOWN;
    }

    public ExecutionContext execute(Expression expression) {
        if (expression != null) {
            expression.execute(this);
        }
        return this;
    }

    public boolean isComplete() {
        return this.fieldValues != null && this.fieldValues.isComplete();
    }

    public FieldValue getFieldValue(String fieldName) {
        return this.fieldValues.getInputValue(fieldName);
    }

    public FieldValue getFieldValue(FieldPath fieldPath) {
        return this.fieldValues.getInputValue(fieldPath);
    }

    public ExecutionContext setFieldValue(String fieldName, FieldValue fieldValue, Expression expression) {
        this.fieldValues.setOutputValue(fieldName, fieldValue, expression);
        return this;
    }

    public FieldValues getFieldValues() {
        return this.fieldValues;
    }

    public FieldValue getVariable(String name) {
        return this.variables.get(name);
    }

    public ExecutionContext setVariable(String name, FieldValue value) {
        this.variables.put(name, value);
        return this;
    }

    public FieldValue getCurrentValue() {
        return this.currentValue;
    }

    public ExecutionContext setCurrentValue(FieldValue value) {
        this.currentValue = value;
        return this;
    }

    public Object getCachedValue(Object key) {
        return this.cache.get(key);
    }

    public void putCachedValue(String key, Object value) {
        this.cache.put(key, value);
    }

    public Map<Object, Object> getCache() {
        return this.cache;
    }

    public Language getLanguage() {
        return this.language;
    }

    public ExecutionContext setLanguage(Language language) {
        this.language = Objects.requireNonNull(language);
        return this;
    }

    public Language resolveLanguage(Linguistics linguistics) {
        if (this.language != Language.UNKNOWN) {
            return this.language;
        }
        if (linguistics == null) {
            return Language.ENGLISH;
        }
        Detection detection = linguistics.getDetector().detect(String.valueOf(this.currentValue), null);
        if (detection == null) {
            return Language.ENGLISH;
        }
        Language detected = detection.getLanguage();
        if (detected == Language.UNKNOWN) {
            return Language.ENGLISH;
        }
        return detected;
    }

    public ExecutionContext clear() {
        this.variables.clear();
        this.currentValue = null;
        return this;
    }
}

