/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.serialization.FieldReader;
import com.yahoo.document.serialization.FieldWriter;
import com.yahoo.document.serialization.XmlStream;

class MapEntryFieldValue
extends FieldValue {
    private final MapDataType type;
    private FieldValue key = null;
    private FieldValue value = null;

    MapEntryFieldValue(FieldValue key, FieldValue value) {
        this.type = new MapDataType(key.getDataType(), value.getDataType());
        this.key = key;
        this.value = value;
    }

    public FieldValue getKey() {
        return this.key;
    }

    public void setKey(FieldValue key) {
        if (!this.type.getKeyType().isAssignableFrom(key.getDataType())) {
            throw new IllegalArgumentException("Got " + key.getDataType() + " but require " + this.type.getKeyType());
        }
        this.key = key;
    }

    public FieldValue getValue() {
        return this.value;
    }

    public void setValue(FieldValue value) {
        if (!this.type.getValueType().isAssignableFrom(value.getDataType())) {
            throw new IllegalArgumentException("Got " + value.getDataType() + " but require " + this.type.getValueType());
        }
        this.value = value;
    }

    public DataType getDataType() {
        return this.type;
    }

    public void printXml(XmlStream xml) {
    }

    public void clear() {
        this.key = null;
        this.value = null;
    }

    public void assign(Object o) {
        throw new IllegalArgumentException("Cannot be assigned a single value");
    }

    public void serialize(Field field, FieldWriter writer) {
        throw new IllegalArgumentException("Cannot be serialized");
    }

    public void deserialize(Field field, FieldReader reader) {
        throw new IllegalArgumentException("Cannot be deserialized");
    }
}

