/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.FieldPath;
import com.yahoo.vespa.indexinglanguage.expressions.AnyDataType;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import java.util.ArrayList;
import java.util.List;

public final class InputExpression
extends Expression {
    private final String fieldName;
    private FieldPath fieldPath;

    public InputExpression(String fieldName) {
        super(null);
        if (fieldName == null) {
            throw new IllegalArgumentException("'input' must be given a field name as argument");
        }
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public DataType setInputType(DataType inputType, VerificationContext context) {
        super.setInputType(inputType, context);
        return this.requireFieldType(context);
    }

    @Override
    public DataType setOutputType(DataType outputType, VerificationContext context) {
        super.setOutputType(this.requireFieldType(context), outputType, null, context);
        return AnyDataType.instance;
    }

    private DataType requireFieldType(VerificationContext context) {
        DataType fieldType = context.getFieldType(this.fieldName, this);
        if (fieldType == null) {
            throw new VerificationException(this, "Field '" + this.fieldName + "' not found");
        }
        return fieldType;
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setCurrentType(this.requireFieldType(context));
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        if (this.fieldPath != null) {
            context.setCurrentValue(context.getFieldValue(this.fieldPath));
        } else {
            context.setCurrentValue(context.getFieldValue(this.fieldName));
        }
    }

    @Override
    public DataType createdOutputType() {
        return UnresolvedDataType.INSTANCE;
    }

    @Override
    public DataType getOutputType(VerificationContext context) {
        return context.getFieldType(this.fieldName, this);
    }

    public String toString() {
        return "input" + (String)(this.fieldName != null ? " " + this.fieldName : "");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InputExpression)) {
            return false;
        }
        InputExpression rhs = (InputExpression)((Object)obj);
        return InputExpression.equals(this.fieldName, rhs.fieldName);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + (this.fieldName != null ? this.fieldName.hashCode() : 0);
    }

    public static class InputFieldNameExtractor
    implements ObjectOperation,
    ObjectPredicate {
        private final List<String> inputFieldNames = new ArrayList<String>(1);

        public void execute(Object obj) {
            this.inputFieldNames.add(((InputExpression)((Object)obj)).getFieldName());
        }

        public boolean check(Object obj) {
            return obj instanceof InputExpression;
        }

        public static List<String> runOn(Expression expression) {
            InputFieldNameExtractor inputFieldNameExtractor = new InputFieldNameExtractor();
            expression.select(inputFieldNameExtractor, inputFieldNameExtractor);
            return inputFieldNameExtractor.inputFieldNames;
        }
    }

    public static class FieldPathOptimizer
    implements ObjectOperation,
    ObjectPredicate {
        private final DocumentType documentType;

        public FieldPathOptimizer(DocumentType documentType) {
            this.documentType = documentType;
        }

        public void execute(Object obj) {
            InputExpression exp = (InputExpression)((Object)obj);
            exp.fieldPath = this.documentType.buildFieldPath(exp.getFieldName());
        }

        public boolean check(Object obj) {
            return obj instanceof InputExpression;
        }
    }
}

