/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.collections.LazyMap;
import com.yahoo.document.FieldPath;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.language.Language;
import com.yahoo.language.Linguistics;
import com.yahoo.language.detect.Detection;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.FieldValueAdapter;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ExecutionContext {
    private final Map<String, FieldValue> variables = new HashMap<String, FieldValue>();
    private final FieldValueAdapter fieldValue;
    private FieldValue currentValue;
    private Language language;
    private final Map<Object, Object> cache = LazyMap.newHashMap();

    public ExecutionContext() {
        this(null);
    }

    public ExecutionContext(FieldValueAdapter fieldValue) {
        this.fieldValue = fieldValue;
        this.language = Language.UNKNOWN;
    }

    public ExecutionContext execute(Expression expression) {
        if (expression != null) {
            expression.execute(this);
        }
        return this;
    }

    public boolean isComplete() {
        return this.fieldValue != null && this.fieldValue.isComplete();
    }

    public FieldValue getFieldValue(String fieldName) {
        return this.fieldValue.getInputValue(fieldName);
    }

    public FieldValue getFieldValue(FieldPath fieldPath) {
        return this.fieldValue.getInputValue(fieldPath);
    }

    public ExecutionContext setFieldValue(String fieldName, FieldValue fieldValue, Expression expression) {
        this.fieldValue.setOutputValue(expression, fieldName, fieldValue);
        return this;
    }

    public FieldValueAdapter getFieldValue() {
        return this.fieldValue;
    }

    public FieldValue getVariable(String name) {
        return this.variables.get(name);
    }

    public ExecutionContext setVariable(String name, FieldValue value) {
        this.variables.put(name, value);
        return this;
    }

    public FieldValue getCurrentValue() {
        return this.currentValue;
    }

    public ExecutionContext setCurrentValue(FieldValue value) {
        this.currentValue = value;
        return this;
    }

    public Object getCachedValue(Object key) {
        return this.cache.get(key);
    }

    public void putCachedValue(String key, Object value) {
        this.cache.put(key, value);
    }

    public Map<Object, Object> getCache() {
        return this.cache;
    }

    void fillVariableTypes(VerificationContext vctx) {
        for (Map.Entry<String, FieldValue> entry : this.variables.entrySet()) {
            vctx.setVariable(entry.getKey(), entry.getValue().getDataType());
        }
    }

    public Language getLanguage() {
        return this.language;
    }

    public ExecutionContext setLanguage(Language language) {
        this.language = Objects.requireNonNull(language);
        return this;
    }

    public Language resolveLanguage(Linguistics linguistics) {
        if (this.language != Language.UNKNOWN) {
            return this.language;
        }
        if (linguistics == null) {
            return Language.ENGLISH;
        }
        Detection detection = linguistics.getDetector().detect(String.valueOf(this.currentValue), null);
        if (detection == null) {
            return Language.ENGLISH;
        }
        Language detected = detection.getLanguage();
        if (detected == Language.UNKNOWN) {
            return Language.ENGLISH;
        }
        return detected;
    }

    public ExecutionContext clear() {
        this.variables.clear();
        this.currentValue = null;
        return this;
    }
}

