/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import java.io.PrintStream;

public final class EchoExpression
extends Expression {
    private final PrintStream out;

    public EchoExpression() {
        this(System.out);
    }

    public EchoExpression(PrintStream out) {
        super((DataType)UnresolvedDataType.INSTANCE);
        this.out = out;
    }

    public PrintStream getOutputStream() {
        return this.out;
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        this.out.println(context.getCurrentValue());
    }

    @Override
    public DataType createdOutputType() {
        return null;
    }

    public String toString() {
        return "echo";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EchoExpression)) {
            return false;
        }
        EchoExpression rhs = (EchoExpression)((Object)obj);
        return this.out == rhs.out;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + this.out.hashCode();
    }
}

