/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.api;

import java.nio.file.Path;
import java.util.Optional;

public class Deployment {
    private final Optional<String> version;
    private final Path applicationZip;
    private final boolean dryRun;

    private Deployment(Optional<String> version, Path applicationZip, boolean dryRun) {
        this.version = version;
        this.applicationZip = applicationZip;
        this.dryRun = dryRun;
    }

    public static Deployment ofPackage(Path applicationZipFile) {
        return new Deployment(Optional.empty(), applicationZipFile, false);
    }

    public Deployment atVersion(String vespaVersion) {
        return new Deployment(Optional.of(vespaVersion), this.applicationZip, false);
    }

    public Deployment withDryRun() {
        return new Deployment(this.version, this.applicationZip, true);
    }

    public Optional<String> version() {
        return this.version;
    }

    public Path applicationZip() {
        return this.applicationZip;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }
}

