/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.fsa;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicReference;

public class FSA
implements Closeable {
    private final boolean _ok;
    private final Charset _charset;
    private final AtomicReference<Maps> maps = new AtomicReference();

    public State getState() {
        return new State(this);
    }

    public Iterator iterator() {
        return new Iterator(this.getState());
    }

    public Iterator iterator(State state) {
        return new Iterator(state);
    }

    public static FSA loadFromResource(String resourceFileName, Class<?> loadingClass) {
        URL fsaUrl = loadingClass.getResource(resourceFileName);
        if (!"file".equals(fsaUrl.getProtocol())) {
            throw new RuntimeException("Could not open non-file url '" + String.valueOf(fsaUrl) + "' as a file input stream: The classloader of " + String.valueOf(loadingClass) + "' does not return file urls");
        }
        return new FSA(fsaUrl.getFile());
    }

    private static FileInputStream createInputStream(String filename) {
        try {
            return new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Could not find FSA file '" + filename + "'", e);
        }
    }

    public FSA(String filename) {
        this(filename, "utf-8");
    }

    public FSA(String filename, String charsetname) {
        this(FSA.createInputStream(filename), charsetname, true);
    }

    public FSA(FileInputStream file) {
        this(file, "utf-8");
    }

    public FSA(FileInputStream file, String charsetname) {
        this(file, charsetname, false);
    }

    private FSA(FileInputStream file, String charsetname, boolean closeInput) {
        try {
            this._charset = Charset.forName(charsetname);
            this.maps.set(new Maps(file));
            this._ok = true;
        }
        catch (IOException e) {
            throw new RuntimeException("IO error while reading FSA file", e);
        }
        finally {
            if (closeInput) {
                try {
                    file.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void close() throws IOException {
        Maps m = this.map();
        this.maps.set(null);
        m.close();
    }

    private Maps map() {
        return this.maps.get();
    }

    private ByteBuffer encode(String str) {
        return this._charset.encode(str);
    }

    private ByteBuffer encode(CharBuffer chrbuf) {
        return this._charset.encode(chrbuf);
    }

    private String decode(ByteBuffer buf) {
        return this._charset.decode(buf).toString();
    }

    public boolean isOk() {
        return this._ok;
    }

    public boolean hasPerfectHash() {
        return this._ok && this.map().h_has_phash() == 1;
    }

    public int version() {
        if (this._ok) {
            return this.map().h_version();
        }
        return 0;
    }

    public int serial() {
        if (this._ok) {
            return this.map().h_serial();
        }
        return 0;
    }

    protected int start() {
        if (this._ok) {
            return this.map().h_start();
        }
        return 0;
    }

    protected int delta(int state, byte symbol) {
        return this.map().delta(state, symbol);
    }

    protected int hashDelta(int state, byte symbol) {
        return this.map().hashDelta(state, symbol);
    }

    protected boolean isFinal(int state) {
        return this._ok && this.map().isFinal(state);
    }

    protected ByteBuffer data(int state) {
        Maps m = this.maps.get();
        if (this._ok && m.isFinal(state)) {
            int length;
            int offset = m._state_tab.getInt(4 * (state + 255));
            if (m.h_data_type() == 1) {
                length = m.h_fixed_data_size();
            } else {
                length = m._data.getInt(offset);
                offset += 4;
            }
            ByteBuffer meta = ByteBuffer.allocate(length);
            meta.order(ByteOrder.LITTLE_ENDIAN);
            byte[] dst = meta.array();
            for (int i = 0; i < length; ++i) {
                dst[i] = m._data.get(i + offset);
            }
            return meta;
        }
        return null;
    }

    protected String dataString(int state) {
        ByteBuffer meta = this.data(state);
        if (meta != null) {
            String data = this.decode(meta);
            if (data.endsWith("\u0000")) {
                data = data.substring(0, data.length() - 1);
            }
            return data;
        }
        return null;
    }

    public String lookup(String str) {
        State s = this.getState();
        s.lookup(str);
        return s.dataString();
    }

    public static void main(String[] args) {
        String test = "sour cherry";
        if (args.length >= 1) {
            test = args[0];
        }
        String fsafile = "/home/gv/fsa/test/__testfsa__.__fsa__";
        FSA fsa = new FSA(fsafile);
        System.out.println("Loading FSA file " + fsafile + ": " + fsa.isOk());
        System.out.println("    version: " + fsa.version() / 1000000 + "." + fsa.version() / 1000 % 1000 + "." + fsa.version() % 1000);
        System.out.println("    serial:  " + fsa.serial());
        System.out.println("    phash:   " + fsa.hasPerfectHash());
        State s = fsa.getState();
        s.start();
        for (int i = 0; i < test.length(); ++i) {
            s.delta(test.charAt(i));
        }
        System.out.println("\ndelta() char test " + test + ": " + s.isFinal() + ", info: " + s.dataString() + ", hash value: " + s.hash());
        s.start();
        s.delta(test);
        System.out.println("\ndelta() test " + test + ": " + s.isFinal() + ", info: " + s.dataString() + ", hash value: " + s.hash());
        s.lookup(test);
        String data = s.dataString();
        System.out.println("\nlookup() test \"" + test + "\": " + (s.lookup(test) != null) + ", info: " + data + ", hash value: " + s.hash());
        String data2 = fsa.lookup(test);
        System.out.println("\nFSA.lookup() test \"" + test + "\": " + data2);
    }

    public static class State {
        FSA fsa;
        int state = 0;
        int hash = 0;

        private State(FSA fsa) {
            this.fsa = fsa;
            this.start();
        }

        public void start() {
            this.state = this.fsa.start();
            this.hash = 0;
        }

        public void delta(byte symbol) {
            this.delta(this.fsa.map(), symbol);
        }

        private void delta(Maps m, byte symbol) {
            this.hash += m.hashDelta(this.state, symbol);
            this.state = m.delta(this.state, symbol);
        }

        public boolean peekDelta(byte symbol) {
            return this.fsa.delta(this.state, symbol) != 0;
        }

        public boolean tryDelta(byte symbol) {
            int lastHash = this.hash;
            int lastState = this.state;
            this.delta(symbol);
            if (this.isValid()) {
                return true;
            }
            this.hash = lastHash;
            this.state = lastState;
            return false;
        }

        public void delta(char chr) {
            CharBuffer chrbuf = CharBuffer.allocate(1);
            chrbuf.put(0, chr);
            ByteBuffer buf = this.fsa.encode(chrbuf);
            Maps m = this.fsa.map();
            while (this.state > 0 && buf.position() < buf.limit()) {
                this.delta(m, buf.get());
            }
        }

        public void delta(String string) {
            ByteBuffer buf = this.fsa.encode(string);
            Maps m = this.fsa.map();
            while (this.state > 0 && buf.position() < buf.limit()) {
                this.delta(m, buf.get());
            }
        }

        public boolean tryDelta(String string) {
            int lastHash = this.hash;
            int lastState = this.state;
            this.delta(string);
            if (this.isValid()) {
                return true;
            }
            this.hash = lastHash;
            this.state = lastState;
            return false;
        }

        public void deltaWord(String string) {
            if (this.state != this.fsa.start()) {
                this.delta((byte)32);
            }
            this.delta(string);
        }

        public boolean tryDeltaWord(String string) {
            int lastHash = this.hash;
            int lastState = this.state;
            this.tryDelta((byte)32);
            this.delta(string);
            if (this.isValid() && this.peekDelta((byte)32)) {
                return true;
            }
            if (this.isFinal()) {
                return true;
            }
            this.hash = lastHash;
            this.state = lastState;
            return false;
        }

        public boolean isFinal() {
            return this.fsa.isFinal(this.state);
        }

        public boolean isStartState() {
            return this.fsa.start() == this.state;
        }

        public boolean isValid() {
            return this.state != 0;
        }

        public ByteBuffer data() {
            return this.fsa.data(this.state);
        }

        public String dataString() {
            return this.fsa.dataString(this.state);
        }

        public int hash() {
            return this.hash;
        }

        public ByteBuffer lookup(String str) {
            this.start();
            this.delta(str);
            return this.fsa.data(this.state);
        }

        public boolean hasPerfectHash() {
            return this.fsa.hasPerfectHash();
        }
    }

    public static class Iterator
    implements java.util.Iterator<Item> {
        private Item item;
        boolean useInitState = false;

        public Iterator(State state) {
            this.item = new Item(state.fsa, state.state);
            if (state.isFinal()) {
                this.useInitState = true;
            } else {
                this.findNext();
            }
        }

        private void findNext() {
            block4: {
                if (this.item.symbol == 256 || this.item.fsa == null) {
                    throw new NoSuchElementException();
                }
                if (this.useInitState) {
                    this.useInitState = false;
                }
                while (true) {
                    ++this.item.symbol;
                    if (this.item.symbol < 256) {
                        byte symbol = (byte)this.item.symbol;
                        int nextState = this.item.fsa.delta(this.item.state, (byte)this.item.symbol);
                        if (nextState == 0) continue;
                        this.item.string.push((byte)this.item.symbol);
                        this.item.stack.push(this.item.state);
                        this.item.state = nextState;
                        this.item.symbol = 0;
                        if (!this.item.fsa.isFinal(nextState)) continue;
                        break block4;
                    }
                    int depth = this.item.string.size();
                    if (depth <= 0) break;
                    int b = this.item.string.pop().byteValue();
                    this.item.symbol = b < 0 ? b + 256 : b;
                    this.item.state = this.item.stack.pop();
                }
                this.item.state = 0;
            }
        }

        @Override
        public boolean hasNext() {
            return this.item.state != 0 || this.useInitState;
        }

        @Override
        public Item next() {
            Item retval = new Item(this.item);
            this.findNext();
            return retval;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public static class Item {
            private FSA fsa;
            private Stack<Byte> string;
            private int symbol;
            private int state;
            private Stack<Integer> stack;

            public Item(FSA fsa, int state) {
                this.fsa = fsa;
                this.string = new Stack();
                this.symbol = 0;
                this.state = state;
                this.stack = new Stack();
            }

            public Item(Item item) {
                this.fsa = item.fsa;
                this.string = new Stack();
                java.util.Iterator itr = item.string.iterator();
                while (itr.hasNext()) {
                    byte b = (Byte)itr.next();
                    this.string.push(b);
                }
                this.symbol = item.symbol;
                this.state = item.state;
                this.stack = null;
            }

            public String getString() {
                ByteBuffer buffer = ByteBuffer.allocate(this.string.size());
                java.util.Iterator itr = this.string.iterator();
                while (itr.hasNext()) {
                    byte b = (Byte)itr.next();
                    buffer.put(b);
                }
                buffer.flip();
                return this.fsa.decode(buffer);
            }

            public ByteBuffer getData() {
                return this.fsa.data(this.state);
            }

            public String getDataString() {
                return this.fsa.dataString(this.state);
            }

            public String toString() {
                return "string: " + String.valueOf(this.string) + "(" + this.getString() + "), symbol: " + this.symbol + ", state: " + this.state;
            }
        }
    }

    private static class Maps
    implements Closeable {
        private final MappedByteBuffer _header;
        private final MappedByteBuffer _symbol_tab;
        private final MappedByteBuffer _state_tab;
        private final MappedByteBuffer _data;
        private final MappedByteBuffer _phash;
        private final boolean _ok;

        Maps(FileInputStream file) throws IOException {
            this._header = file.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, 256L);
            this._header.order(ByteOrder.LITTLE_ENDIAN);
            if (this.h_magic() != 2038637673) {
                throw new IOException("Stream does not contain an FSA: Wrong file magic number " + this.h_magic());
            }
            this._symbol_tab = file.getChannel().map(FileChannel.MapMode.READ_ONLY, 256L, this.h_size());
            this._symbol_tab.order(ByteOrder.LITTLE_ENDIAN);
            this._state_tab = file.getChannel().map(FileChannel.MapMode.READ_ONLY, 256 + this.h_size(), 4 * this.h_size());
            this._state_tab.order(ByteOrder.LITTLE_ENDIAN);
            this._data = file.getChannel().map(FileChannel.MapMode.READ_ONLY, 256 + 5 * this.h_size(), this.h_data_size());
            this._data.order(ByteOrder.LITTLE_ENDIAN);
            if (this.h_has_phash() > 0) {
                this._phash = file.getChannel().map(FileChannel.MapMode.READ_ONLY, 256 + 5 * this.h_size() + this.h_data_size(), 4 * this.h_size());
                this._phash.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                this._phash = null;
            }
            this._ok = true;
        }

        private int h_magic() {
            return this._header.getInt(0);
        }

        private int h_version() {
            return this._header.getInt(4);
        }

        private int h_checksum() {
            return this._header.getInt(8);
        }

        private int h_size() {
            return this._header.getInt(12);
        }

        private int h_start() {
            return this._header.getInt(16);
        }

        private int h_data_size() {
            return this._header.getInt(20);
        }

        private int h_data_type() {
            return this._header.getInt(24);
        }

        private int h_fixed_data_size() {
            return this._header.getInt(28);
        }

        private int h_has_phash() {
            return this._header.getInt(32);
        }

        private int h_serial() {
            return this._header.getInt(36);
        }

        private int hashDelta(int state, byte symbol) {
            int s = symbol;
            if (s < 0) {
                s += 256;
            }
            if (this._ok && this.h_has_phash() == 1 && s > 0 && s < 255 && this.getSymbol(state + s) == s) {
                return this._phash.getInt(4 * (state + s));
            }
            return 0;
        }

        private int delta(int state, byte symbol) {
            int s = symbol;
            if (s < 0) {
                s += 256;
            }
            if (this._ok && s > 0 && s < 255 && this.getSymbol(state + s) == s) {
                return this._state_tab.getInt(4 * (state + s));
            }
            return 0;
        }

        private int getSymbol(int index) {
            int symbol = this._symbol_tab.get(index);
            if (symbol < 0) {
                symbol += 256;
            }
            return symbol;
        }

        private boolean isFinal(int state) {
            return this._ok && this.getSymbol(state + 255) == 255;
        }

        private static void clean(MappedByteBuffer mmap) {
            if (mmap == null || !mmap.isDirect()) {
                return;
            }
            try {
                Class<?> unsafeClass;
                try {
                    unsafeClass = Class.forName("sun.misc.Unsafe");
                }
                catch (Exception ex) {
                    unsafeClass = Class.forName("jdk.internal.misc.Unsafe");
                }
                Method clean = unsafeClass.getMethod("invokeCleaner", ByteBuffer.class);
                clean.setAccessible(true);
                Field theUnsafeField = unsafeClass.getDeclaredField("theUnsafe");
                theUnsafeField.setAccessible(true);
                Object theUnsafe = theUnsafeField.get(null);
                clean.invoke(theUnsafe, mmap);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed unmapping ", e);
            }
        }

        @Override
        public void close() {
            Maps.clean(this._header);
            Maps.clean(this._data);
            Maps.clean(this._phash);
            Maps.clean(this._state_tab);
            Maps.clean(this._symbol_tab);
        }
    }
}

