/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.documentapi.messagebus.protocol.DocumentReply;
import com.yahoo.documentapi.messagebus.protocol.VisitorMessage;
import com.yahoo.documentapi.messagebus.protocol.VisitorReply;
import java.util.Map;
import java.util.TreeMap;

public class MapVisitorMessage
extends VisitorMessage {
    private final Map<String, String> data = new TreeMap<String, String>();

    MapVisitorMessage() {
    }

    public MapVisitorMessage(MapVisitorMessage cmd) {
        this.data.putAll(cmd.data);
    }

    public Map<String, String> getData() {
        return this.data;
    }

    @Override
    public DocumentReply createReply() {
        return new VisitorReply(200015);
    }

    public int getType() {
        return 100015;
    }

    @Override
    public int getApproxSize() {
        int length = super.getApproxSize() + 4;
        for (Map.Entry<String, String> pairs : this.data.entrySet()) {
            length += 8;
            length += pairs.getKey().length() + pairs.getValue().length();
        }
        return length;
    }

    public String toString() {
        return "MapVisitorMessage(" + this.data.toString() + ")";
    }
}

