/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.document.BucketId;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.TestAndSetCondition;
import com.yahoo.document.serialization.DocumentDeserializer;
import com.yahoo.document.serialization.DocumentReader;
import com.yahoo.document.serialization.DocumentSerializer;
import com.yahoo.document.serialization.DocumentUpdateReader;
import com.yahoo.document.serialization.DocumentUpdateWriter;
import com.yahoo.document.serialization.DocumentWriter;
import com.yahoo.documentapi.messagebus.protocol.AbstractRoutableFactory;
import com.yahoo.documentapi.messagebus.protocol.CreateVisitorMessage;
import com.yahoo.documentapi.messagebus.protocol.CreateVisitorReply;
import com.yahoo.documentapi.messagebus.protocol.DestroyVisitorMessage;
import com.yahoo.documentapi.messagebus.protocol.DocumentIgnoredReply;
import com.yahoo.documentapi.messagebus.protocol.DocumentListEntry;
import com.yahoo.documentapi.messagebus.protocol.DocumentListMessage;
import com.yahoo.documentapi.messagebus.protocol.DocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.documentapi.messagebus.protocol.DocumentReply;
import com.yahoo.documentapi.messagebus.protocol.DocumentState;
import com.yahoo.documentapi.messagebus.protocol.EmptyBucketsMessage;
import com.yahoo.documentapi.messagebus.protocol.GetBucketListMessage;
import com.yahoo.documentapi.messagebus.protocol.GetBucketListReply;
import com.yahoo.documentapi.messagebus.protocol.GetBucketStateMessage;
import com.yahoo.documentapi.messagebus.protocol.GetBucketStateReply;
import com.yahoo.documentapi.messagebus.protocol.GetDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.GetDocumentReply;
import com.yahoo.documentapi.messagebus.protocol.LazyDecoder;
import com.yahoo.documentapi.messagebus.protocol.MapVisitorMessage;
import com.yahoo.documentapi.messagebus.protocol.PutDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.QueryResultMessage;
import com.yahoo.documentapi.messagebus.protocol.RemoveDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.RemoveDocumentReply;
import com.yahoo.documentapi.messagebus.protocol.RemoveLocationMessage;
import com.yahoo.documentapi.messagebus.protocol.StatBucketMessage;
import com.yahoo.documentapi.messagebus.protocol.StatBucketReply;
import com.yahoo.documentapi.messagebus.protocol.TestAndSetMessage;
import com.yahoo.documentapi.messagebus.protocol.UpdateDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.UpdateDocumentReply;
import com.yahoo.documentapi.messagebus.protocol.VisitorInfoMessage;
import com.yahoo.documentapi.messagebus.protocol.VisitorReply;
import com.yahoo.documentapi.messagebus.protocol.WriteDocumentReply;
import com.yahoo.documentapi.messagebus.protocol.WrongDistributionReply;
import com.yahoo.messagebus.Routable;
import com.yahoo.vdslib.DocumentSummary;
import com.yahoo.vdslib.SearchResult;
import com.yahoo.vdslib.VisitorStatistics;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Serializer;
import java.util.Map;

public abstract class RoutableFactories60 {
    static void decodeTasCondition(TestAndSetMessage msg, DocumentDeserializer buf) {
        msg.setCondition(new TestAndSetCondition(AbstractRoutableFactory.decodeString((Deserializer)buf)));
    }

    static void encodeTasCondition(DocumentSerializer buf, TestAndSetMessage msg) {
        AbstractRoutableFactory.encodeString(msg.getCondition().getSelection(), (Serializer)buf);
    }

    public static class WrongDistributionReplyFactory
    extends DocumentReplyFactory {
        @Override
        protected DocumentReply doDecode(DocumentDeserializer buf) {
            WrongDistributionReply reply = new WrongDistributionReply();
            reply.setSystemState(WrongDistributionReplyFactory.decodeString((Deserializer)buf));
            return reply;
        }

        @Override
        protected boolean doEncode(DocumentReply obj, DocumentSerializer buf) {
            WrongDistributionReply reply = (WrongDistributionReply)obj;
            WrongDistributionReplyFactory.encodeString(reply.getSystemState(), (Serializer)buf);
            return true;
        }
    }

    public static class VisitorInfoReplyFactory
    extends DocumentReplyFactory {
        @Override
        protected DocumentReply doDecode(DocumentDeserializer buf) {
            return new VisitorReply(200009);
        }

        @Override
        protected boolean doEncode(DocumentReply obj, DocumentSerializer buf) {
            return true;
        }
    }

    public static class VisitorInfoMessageFactory
    extends DocumentMessageFactory {
        @Override
        protected DocumentMessage doDecode(DocumentDeserializer buf) {
            VisitorInfoMessage msg = new VisitorInfoMessage();
            int size = buf.getInt(null);
            for (int i = 0; i < size; ++i) {
                long reversed = buf.getLong(null);
                long rawid = reversed >>> 56 & 0xFFL | reversed >>> 40 & 0xFF00L | reversed >>> 24 & 0xFF0000L | reversed >>> 8 & 0xFF000000L | reversed << 8 & 0xFF00000000L | reversed << 24 & 0xFF0000000000L | reversed << 40 & 0xFF000000000000L | reversed << 56 & 0xFF00000000000000L;
                msg.getFinishedBuckets().add(new BucketId(rawid));
            }
            msg.setErrorMessage(VisitorInfoMessageFactory.decodeString((Deserializer)buf));
            return msg;
        }

        @Override
        protected boolean doEncode(DocumentMessage obj, DocumentSerializer buf) {
            VisitorInfoMessage msg = (VisitorInfoMessage)obj;
            buf.putInt(null, msg.getFinishedBuckets().size());
            for (BucketId id : msg.getFinishedBuckets()) {
                long rawid = id.getRawId();
                long reversed = rawid >>> 56 & 0xFFL | rawid >>> 40 & 0xFF00L | rawid >>> 24 & 0xFF0000L | rawid >>> 8 & 0xFF000000L | rawid << 8 & 0xFF00000000L | rawid << 24 & 0xFF0000000000L | rawid << 40 & 0xFF000000000000L | rawid << 56 & 0xFF00000000000000L;
                buf.putLong(null, reversed);
            }
            VisitorInfoMessageFactory.encodeString(msg.getErrorMessage(), (Serializer)buf);
            return true;
        }
    }

    public static class UpdateDocumentReplyFactory
    extends DocumentReplyFactory {
        @Override
        protected DocumentReply doDecode(DocumentDeserializer buf) {
            UpdateDocumentReply rep = new UpdateDocumentReply();
            byte flag = buf.getByte(null);
            rep.setWasFound(flag != 0);
            rep.setHighestModificationTimestamp(buf.getLong(null));
            return rep;
        }

        @Override
        protected boolean doEncode(DocumentReply obj, DocumentSerializer buf) {
            UpdateDocumentReply rep = (UpdateDocumentReply)obj;
            buf.putByte(null, (byte)(rep.wasFound() ? 1 : 0));
            buf.putLong(null, rep.getHighestModificationTimestamp());
            return true;
        }
    }

    public static class UpdateDocumentMessageFactory
    extends DocumentMessageFactory {
        protected void decodeInto(UpdateDocumentMessage msg, DocumentDeserializer buf) {
            msg.setDocumentUpdate(new DocumentUpdate((DocumentUpdateReader)buf));
            msg.setOldTimestamp(buf.getLong(null));
            msg.setNewTimestamp(buf.getLong(null));
            RoutableFactories60.decodeTasCondition(msg, buf);
        }

        @Override
        protected DocumentMessage doDecode(DocumentDeserializer buffer) {
            LazyDecoder decoder = (obj, buf) -> this.decodeInto((UpdateDocumentMessage)obj, buf);
            return new UpdateDocumentMessage(decoder, buffer);
        }

        @Override
        protected boolean doEncode(DocumentMessage obj, DocumentSerializer buf) {
            UpdateDocumentMessage msg = (UpdateDocumentMessage)obj;
            if (msg.getSerializedBuffer() != null) {
                buf.put(null, msg.getSerializedBuffer());
            } else {
                msg.getDocumentUpdate().serialize((DocumentUpdateWriter)buf);
                buf.putLong(null, msg.getOldTimestamp());
                buf.putLong(null, msg.getNewTimestamp());
                RoutableFactories60.encodeTasCondition(buf, (TestAndSetMessage)obj);
            }
            return true;
        }
    }

    public static class StatBucketReplyFactory
    extends DocumentReplyFactory {
        @Override
        protected DocumentReply doDecode(DocumentDeserializer buf) {
            StatBucketReply reply = new StatBucketReply();
            reply.setResults(StatBucketReplyFactory.decodeString((Deserializer)buf));
            return reply;
        }

        @Override
        protected boolean doEncode(DocumentReply obj, DocumentSerializer buf) {
            StatBucketReply reply = (StatBucketReply)obj;
            StatBucketReplyFactory.encodeString(reply.getResults(), (Serializer)buf);
            return true;
        }
    }

    public static class StatBucketMessageFactory
    extends DocumentMessageFactory {
        protected String decodeBucketSpace(Deserializer deserializer) {
            return StatBucketMessageFactory.decodeString(deserializer);
        }

        @Override
        protected DocumentMessage doDecode(DocumentDeserializer buf) {
            StatBucketMessage msg = new StatBucketMessage();
            msg.setBucketId(new BucketId(buf.getLong(null)));
            msg.setDocumentSelection(StatBucketMessageFactory.decodeString((Deserializer)buf));
            msg.setBucketSpace(this.decodeBucketSpace((Deserializer)buf));
            return msg;
        }

        protected boolean encodeBucketSpace(String bucketSpace, DocumentSerializer buf) {
            StatBucketMessageFactory.encodeString(bucketSpace, (Serializer)buf);
            return true;
        }

        @Override
        protected boolean doEncode(DocumentMessage obj, DocumentSerializer buf) {
            StatBucketMessage msg = (StatBucketMessage)obj;
            buf.putLong(null, msg.getBucketId().getRawId());
            StatBucketMessageFactory.encodeString(msg.getDocumentSelection(), (Serializer)buf);
            return this.encodeBucketSpace(msg.getBucketSpace(), buf);
        }
    }

    public static class QueryResultReplyFactory
    extends DocumentReplyFactory {
        @Override
        protected DocumentReply doDecode(DocumentDeserializer buf) {
            return new VisitorReply(200025);
        }

        @Override
        protected boolean doEncode(DocumentReply obj, DocumentSerializer buf) {
            return true;
        }
    }

    public static class QueryResultMessageFactory
    extends DocumentMessageFactory {
        @Override
        protected DocumentMessage doDecode(DocumentDeserializer buf) {
            QueryResultMessage msg = new QueryResultMessage();
            msg.setSearchResult(new SearchResult((Deserializer)buf));
            msg.setSummary(new DocumentSummary((Deserializer)buf));
            return msg;
        }

        @Override
        protected boolean doEncode(DocumentMessage obj, DocumentSerializer buf) {
            return false;
        }
    }

    public static class RemoveLocationReplyFactory
    extends DocumentReplyFactory {
        @Override
        protected DocumentReply doDecode(DocumentDeserializer buf) {
            return new DocumentReply(200024);
        }

        @Override
        protected boolean doEncode(DocumentReply obj, DocumentSerializer buf) {
            return true;
        }
    }

    public static class RemoveLocationMessageFactory
    extends DocumentMessageFactory {
        @Override
        protected DocumentMessage doDecode(DocumentDeserializer buf) {
            return new RemoveLocationMessage(RemoveLocationMessageFactory.decodeString((Deserializer)buf));
        }

        @Override
        protected boolean doEncode(DocumentMessage obj, DocumentSerializer buf) {
            RemoveLocationMessage msg = (RemoveLocationMessage)obj;
            RemoveLocationMessageFactory.encodeString(msg.getDocumentSelection(), (Serializer)buf);
            return true;
        }
    }

    public static class RemoveDocumentReplyFactory
    extends DocumentReplyFactory {
        @Override
        protected DocumentReply doDecode(DocumentDeserializer buf) {
            RemoveDocumentReply reply = new RemoveDocumentReply();
            byte flag = buf.getByte(null);
            reply.setWasFound(flag != 0);
            reply.setHighestModificationTimestamp(buf.getLong(null));
            return reply;
        }

        @Override
        protected boolean doEncode(DocumentReply obj, DocumentSerializer buf) {
            RemoveDocumentReply reply = (RemoveDocumentReply)obj;
            buf.putByte(null, (byte)(reply.wasFound() ? 1 : 0));
            buf.putLong(null, reply.getHighestModificationTimestamp());
            return true;
        }
    }

    public static class RemoveDocumentMessageFactory
    extends DocumentMessageFactory {
        protected void decodeInto(RemoveDocumentMessage msg, DocumentDeserializer buf) {
            msg.setDocumentId(new DocumentId((Deserializer)buf));
            RoutableFactories60.decodeTasCondition(msg, buf);
        }

        @Override
        protected DocumentMessage doDecode(DocumentDeserializer buf) {
            RemoveDocumentMessage msg = new RemoveDocumentMessage();
            this.decodeInto(msg, buf);
            return msg;
        }

        @Override
        protected boolean doEncode(DocumentMessage obj, DocumentSerializer buf) {
            RemoveDocumentMessage msg = (RemoveDocumentMessage)obj;
            msg.getDocumentId().serialize((Serializer)buf);
            RoutableFactories60.encodeTasCondition(buf, (TestAndSetMessage)obj);
            return true;
        }
    }

    public static class PutDocumentReplyFactory
    extends DocumentReplyFactory {
        @Override
        protected DocumentReply doDecode(DocumentDeserializer buf) {
            WriteDocumentReply rep = new WriteDocumentReply(200004);
            rep.setHighestModificationTimestamp(buf.getLong(null));
            return rep;
        }

        @Override
        protected boolean doEncode(DocumentReply obj, DocumentSerializer buf) {
            WriteDocumentReply rep = (WriteDocumentReply)obj;
            buf.putLong(null, rep.getHighestModificationTimestamp());
            return true;
        }
    }

    public static class PutDocumentMessageFactory
    extends DocumentMessageFactory {
        protected void decodeInto(PutDocumentMessage msg, DocumentDeserializer buf) {
            msg.setDocumentPut(new DocumentPut(Document.createDocument((DocumentReader)buf)));
            msg.setTimestamp(buf.getLong(null));
            RoutableFactories60.decodeTasCondition(msg, buf);
            if (buf.getBuf().hasRemaining()) {
                byte value = buf.getBuf().get();
                msg.setCreateIfNonExistent(value != 0);
            }
        }

        @Override
        protected DocumentMessage doDecode(DocumentDeserializer buffer) {
            LazyDecoder decoder = (obj, buf) -> this.decodeInto((PutDocumentMessage)obj, buf);
            return new PutDocumentMessage(decoder, buffer);
        }

        @Override
        protected boolean doEncode(DocumentMessage obj, DocumentSerializer buf) {
            PutDocumentMessage msg = (PutDocumentMessage)obj;
            if (msg.getSerializedBuffer() != null) {
                buf.put(null, msg.getSerializedBuffer());
            } else {
                msg.getDocumentPut().getDocument().serialize((DocumentWriter)buf);
                buf.putLong(null, msg.getTimestamp());
                RoutableFactories60.encodeTasCondition(buf, (TestAndSetMessage)obj);
                if (msg.getCreateIfNonExistent()) {
                    buf.getBuf().put((byte)1);
                } else {
                    buf.getBuf().put((byte)0);
                }
            }
            return true;
        }
    }

    public static class MapVisitorReplyFactory
    extends DocumentReplyFactory {
        @Override
        protected DocumentReply doDecode(DocumentDeserializer buf) {
            return new VisitorReply(200015);
        }

        @Override
        protected boolean doEncode(DocumentReply obj, DocumentSerializer buf) {
            return true;
        }
    }

    public static class MapVisitorMessageFactory
    extends DocumentMessageFactory {
        @Override
        protected DocumentMessage doDecode(DocumentDeserializer buf) {
            MapVisitorMessage msg = new MapVisitorMessage();
            int size = buf.getInt(null);
            for (int i = 0; i < size; ++i) {
                String key = MapVisitorMessageFactory.decodeString((Deserializer)buf);
                String value = MapVisitorMessageFactory.decodeString((Deserializer)buf);
                msg.getData().put(key, value);
            }
            return msg;
        }

        @Override
        protected boolean doEncode(DocumentMessage obj, DocumentSerializer buf) {
            MapVisitorMessage msg = (MapVisitorMessage)obj;
            buf.putInt(null, msg.getData().size());
            for (Map.Entry<String, String> pairs : msg.getData().entrySet()) {
                MapVisitorMessageFactory.encodeString(pairs.getKey(), (Serializer)buf);
                MapVisitorMessageFactory.encodeString(pairs.getValue(), (Serializer)buf);
            }
            return true;
        }
    }

    public static class GetDocumentReplyFactory
    extends DocumentReplyFactory {
        private final LazyDecoder decoder = new LazyDecoder(){

            @Override
            public void decode(Routable obj, DocumentDeserializer buf) {
                GetDocumentReply reply = (GetDocumentReply)obj;
                Document doc = null;
                byte flag = buf.getByte(null);
                if (flag != 0) {
                    doc = Document.createDocument((DocumentReader)buf);
                    reply.setDocument(doc);
                }
                long lastModified = buf.getLong(null);
                reply.setLastModified(lastModified);
                if (doc != null) {
                    doc.setLastModified(Long.valueOf(lastModified));
                }
            }
        };

        @Override
        protected DocumentReply doDecode(DocumentDeserializer buf) {
            GetDocumentReply reply = new GetDocumentReply(this.decoder, buf);
            return reply;
        }

        @Override
        protected boolean doEncode(DocumentReply obj, DocumentSerializer buf) {
            GetDocumentReply reply = (GetDocumentReply)obj;
            if (reply.getSerializedBuffer() != null) {
                buf.put(null, reply.getSerializedBuffer());
            } else {
                Document document = reply.getDocument();
                buf.putByte(null, (byte)(document != null ? 1 : 0));
                if (document != null) {
                    document.serialize((DocumentWriter)buf);
                }
                buf.putLong(null, reply.getLastModified());
            }
            return true;
        }
    }

    public static class GetDocumentMessageFactory
    extends DocumentMessageFactory {
        @Override
        protected DocumentMessage doDecode(DocumentDeserializer buf) {
            return new GetDocumentMessage(new DocumentId((Deserializer)buf), GetDocumentMessageFactory.decodeString((Deserializer)buf));
        }

        @Override
        protected boolean doEncode(DocumentMessage obj, DocumentSerializer buf) {
            GetDocumentMessage msg = (GetDocumentMessage)obj;
            msg.getDocumentId().serialize((Serializer)buf);
            GetDocumentMessageFactory.encodeString(msg.getFieldSet(), (Serializer)buf);
            return true;
        }
    }

    public static class GetBucketStateReplyFactory
    extends DocumentReplyFactory {
        @Override
        protected DocumentReply doDecode(DocumentDeserializer buf) {
            GetBucketStateReply reply = new GetBucketStateReply();
            int size = buf.getInt(null);
            for (int i = 0; i < size; ++i) {
                reply.getBucketState().add(new DocumentState((Deserializer)buf));
            }
            return reply;
        }

        @Override
        protected boolean doEncode(DocumentReply obj, DocumentSerializer buf) {
            GetBucketStateReply reply = (GetBucketStateReply)obj;
            buf.putInt(null, reply.getBucketState().size());
            for (DocumentState stat : reply.getBucketState()) {
                stat.serialize((Serializer)buf);
            }
            return true;
        }
    }

    public static class GetBucketStateMessageFactory
    extends DocumentMessageFactory {
        @Override
        protected DocumentMessage doDecode(DocumentDeserializer buf) {
            GetBucketStateMessage msg = new GetBucketStateMessage();
            msg.setBucketId(new BucketId(buf.getLong(null)));
            return msg;
        }

        @Override
        protected boolean doEncode(DocumentMessage obj, DocumentSerializer buf) {
            GetBucketStateMessage msg = (GetBucketStateMessage)obj;
            buf.putLong(null, msg.getBucketId().getRawId());
            return true;
        }
    }

    public static class GetBucketListReplyFactory
    extends DocumentReplyFactory {
        @Override
        protected DocumentReply doDecode(DocumentDeserializer buf) {
            GetBucketListReply reply = new GetBucketListReply();
            int len = buf.getInt(null);
            for (int i = 0; i < len; ++i) {
                GetBucketListReply.BucketInfo info = new GetBucketListReply.BucketInfo();
                info.bucket = new BucketId(buf.getLong(null));
                info.bucketInformation = GetBucketListReplyFactory.decodeString((Deserializer)buf);
                reply.getBuckets().add(info);
            }
            return reply;
        }

        @Override
        protected boolean doEncode(DocumentReply obj, DocumentSerializer buf) {
            GetBucketListReply reply = (GetBucketListReply)obj;
            buf.putInt(null, reply.getBuckets().size());
            for (GetBucketListReply.BucketInfo info : reply.getBuckets()) {
                buf.putLong(null, info.bucket.getRawId());
                GetBucketListReplyFactory.encodeString(info.bucketInformation, (Serializer)buf);
            }
            return true;
        }
    }

    public static class GetBucketListMessageFactory
    extends DocumentMessageFactory {
        protected String decodeBucketSpace(Deserializer deserializer) {
            return GetBucketListMessageFactory.decodeString(deserializer);
        }

        @Override
        protected DocumentMessage doDecode(DocumentDeserializer buf) {
            GetBucketListMessage msg = new GetBucketListMessage();
            msg.setBucketId(new BucketId(buf.getLong(null)));
            msg.setBucketSpace(this.decodeBucketSpace((Deserializer)buf));
            return msg;
        }

        protected boolean encodeBucketSpace(String bucketSpace, DocumentSerializer buf) {
            GetBucketListMessageFactory.encodeString(bucketSpace, (Serializer)buf);
            return true;
        }

        @Override
        protected boolean doEncode(DocumentMessage obj, DocumentSerializer buf) {
            GetBucketListMessage msg = (GetBucketListMessage)obj;
            buf.putLong(null, msg.getBucketId().getRawId());
            return this.encodeBucketSpace(msg.getBucketSpace(), buf);
        }
    }

    public static class EmptyBucketsReplyFactory
    extends DocumentReplyFactory {
        @Override
        protected DocumentReply doDecode(DocumentDeserializer buf) {
            return new VisitorReply(200023);
        }

        @Override
        protected boolean doEncode(DocumentReply obj, DocumentSerializer buf) {
            return true;
        }
    }

    public static class EmptyBucketsMessageFactory
    extends DocumentMessageFactory {
        @Override
        protected DocumentMessage doDecode(DocumentDeserializer buf) {
            EmptyBucketsMessage msg = new EmptyBucketsMessage();
            int size = buf.getInt(null);
            for (int i = 0; i < size; ++i) {
                msg.getBucketIds().add(new BucketId(buf.getLong(null)));
            }
            return msg;
        }

        @Override
        protected boolean doEncode(DocumentMessage obj, DocumentSerializer buf) {
            EmptyBucketsMessage msg = (EmptyBucketsMessage)obj;
            buf.putInt(null, msg.getBucketIds().size());
            for (BucketId bid : msg.getBucketIds()) {
                buf.putLong(null, bid.getRawId());
            }
            return true;
        }
    }

    public static class DocumentListReplyFactory
    extends DocumentReplyFactory {
        @Override
        protected DocumentReply doDecode(DocumentDeserializer buf) {
            return new VisitorReply(200021);
        }

        @Override
        protected boolean doEncode(DocumentReply obj, DocumentSerializer buf) {
            return true;
        }
    }

    public static class DocumentListMessageFactory
    extends DocumentMessageFactory {
        @Override
        protected DocumentMessage doDecode(DocumentDeserializer buf) {
            DocumentListMessage msg = new DocumentListMessage();
            msg.setBucketId(new BucketId(buf.getLong(null)));
            int len = buf.getInt(null);
            for (int i = 0; i < len; ++i) {
                msg.getDocuments().add(new DocumentListEntry(buf));
            }
            return msg;
        }

        @Override
        protected boolean doEncode(DocumentMessage obj, DocumentSerializer buf) {
            DocumentListMessage msg = (DocumentListMessage)obj;
            buf.putLong(null, msg.getBucketId().getRawId());
            buf.putInt(null, msg.getDocuments().size());
            for (int i = 0; i < msg.getDocuments().size(); ++i) {
                msg.getDocuments().get(i).serialize((Serializer)buf);
            }
            return true;
        }
    }

    public static class DocumentIgnoredReplyFactory
    extends DocumentReplyFactory {
        @Override
        protected DocumentReply doDecode(DocumentDeserializer buf) {
            return new DocumentIgnoredReply();
        }

        @Override
        protected boolean doEncode(DocumentReply obj, DocumentSerializer buf) {
            return true;
        }
    }

    public static class DestroyVisitorReplyFactory
    extends DocumentReplyFactory {
        @Override
        protected DocumentReply doDecode(DocumentDeserializer buf) {
            return new VisitorReply(200008);
        }

        @Override
        protected boolean doEncode(DocumentReply obj, DocumentSerializer buf) {
            return true;
        }
    }

    public static class DestroyVisitorMessageFactory
    extends DocumentMessageFactory {
        @Override
        protected DocumentMessage doDecode(DocumentDeserializer buf) {
            DestroyVisitorMessage msg = new DestroyVisitorMessage();
            msg.setInstanceId(DestroyVisitorMessageFactory.decodeString((Deserializer)buf));
            return msg;
        }

        @Override
        protected boolean doEncode(DocumentMessage obj, DocumentSerializer buf) {
            DestroyVisitorMessage msg = (DestroyVisitorMessage)obj;
            DestroyVisitorMessageFactory.encodeString(msg.getInstanceId(), (Serializer)buf);
            return true;
        }
    }

    public static class CreateVisitorReplyFactory
    extends DocumentReplyFactory {
        @Override
        protected DocumentReply doDecode(DocumentDeserializer buf) {
            CreateVisitorReply reply = new CreateVisitorReply(200007);
            reply.setLastBucket(new BucketId(buf.getLong(null)));
            VisitorStatistics vs = new VisitorStatistics();
            vs.setBucketsVisited(buf.getInt(null));
            vs.setDocumentsVisited(buf.getLong(null));
            vs.setBytesVisited(buf.getLong(null));
            vs.setDocumentsReturned(buf.getLong(null));
            vs.setBytesReturned(buf.getLong(null));
            buf.getLong(null);
            buf.getLong(null);
            reply.setVisitorStatistics(vs);
            return reply;
        }

        @Override
        protected boolean doEncode(DocumentReply obj, DocumentSerializer buf) {
            CreateVisitorReply reply = (CreateVisitorReply)obj;
            buf.putLong(null, reply.getLastBucket().getRawId());
            buf.putInt(null, reply.getVisitorStatistics().getBucketsVisited());
            buf.putLong(null, reply.getVisitorStatistics().getDocumentsVisited());
            buf.putLong(null, reply.getVisitorStatistics().getBytesVisited());
            buf.putLong(null, reply.getVisitorStatistics().getDocumentsReturned());
            buf.putLong(null, reply.getVisitorStatistics().getBytesReturned());
            buf.putLong(null, 0L);
            buf.putLong(null, 0L);
            return true;
        }
    }

    public static class CreateVisitorMessageFactory
    extends DocumentMessageFactory {
        protected String decodeBucketSpace(Deserializer deserializer) {
            return CreateVisitorMessageFactory.decodeString(deserializer);
        }

        @Override
        protected DocumentMessage doDecode(DocumentDeserializer buf) {
            int i;
            CreateVisitorMessage msg = new CreateVisitorMessage();
            msg.setLibraryName(CreateVisitorMessageFactory.decodeString((Deserializer)buf));
            msg.setInstanceId(CreateVisitorMessageFactory.decodeString((Deserializer)buf));
            msg.setControlDestination(CreateVisitorMessageFactory.decodeString((Deserializer)buf));
            msg.setDataDestination(CreateVisitorMessageFactory.decodeString((Deserializer)buf));
            msg.setDocumentSelection(CreateVisitorMessageFactory.decodeString((Deserializer)buf));
            msg.setMaxPendingReplyCount(buf.getInt(null));
            int size = buf.getInt(null);
            for (i = 0; i < size; ++i) {
                long reversed = buf.getLong(null);
                long rawid = reversed >>> 56 & 0xFFL | reversed >>> 40 & 0xFF00L | reversed >>> 24 & 0xFF0000L | reversed >>> 8 & 0xFF000000L | reversed << 8 & 0xFF00000000L | reversed << 24 & 0xFF0000000000L | reversed << 40 & 0xFF000000000000L | reversed << 56 & 0xFF00000000000000L;
                msg.getBuckets().add(new BucketId(rawid));
            }
            msg.setFromTimestamp(buf.getLong(null));
            msg.setToTimestamp(buf.getLong(null));
            msg.setVisitRemoves(buf.getByte(null) == 1);
            msg.setFieldSet(CreateVisitorMessageFactory.decodeString((Deserializer)buf));
            msg.setVisitInconsistentBuckets(buf.getByte(null) == 1);
            size = buf.getInt(null);
            for (i = 0; i < size; ++i) {
                String key = CreateVisitorMessageFactory.decodeString((Deserializer)buf);
                int sz = buf.getInt(null);
                msg.getParameters().put(key, buf.getBytes(null, sz));
            }
            buf.getInt(null);
            msg.setMaxBucketsPerVisitor(buf.getInt(null));
            msg.setBucketSpace(this.decodeBucketSpace((Deserializer)buf));
            return msg;
        }

        protected boolean encodeBucketSpace(String bucketSpace, DocumentSerializer buf) {
            CreateVisitorMessageFactory.encodeString(bucketSpace, (Serializer)buf);
            return true;
        }

        @Override
        protected boolean doEncode(DocumentMessage obj, DocumentSerializer buf) {
            CreateVisitorMessage msg = (CreateVisitorMessage)obj;
            CreateVisitorMessageFactory.encodeString(msg.getLibraryName(), (Serializer)buf);
            CreateVisitorMessageFactory.encodeString(msg.getInstanceId(), (Serializer)buf);
            CreateVisitorMessageFactory.encodeString(msg.getControlDestination(), (Serializer)buf);
            CreateVisitorMessageFactory.encodeString(msg.getDataDestination(), (Serializer)buf);
            CreateVisitorMessageFactory.encodeString(msg.getDocumentSelection(), (Serializer)buf);
            buf.putInt(null, msg.getMaxPendingReplyCount());
            buf.putInt(null, msg.getBuckets().size());
            for (BucketId bucketId : msg.getBuckets()) {
                long rawid = bucketId.getRawId();
                long reversed = rawid >>> 56 & 0xFFL | rawid >>> 40 & 0xFF00L | rawid >>> 24 & 0xFF0000L | rawid >>> 8 & 0xFF000000L | rawid << 8 & 0xFF00000000L | rawid << 24 & 0xFF0000000000L | rawid << 40 & 0xFF000000000000L | rawid << 56 & 0xFF00000000000000L;
                buf.putLong(null, reversed);
            }
            buf.putLong(null, msg.getFromTimestamp());
            buf.putLong(null, msg.getToTimestamp());
            buf.putByte(null, msg.getVisitRemoves() ? (byte)1 : 0);
            CreateVisitorMessageFactory.encodeString(msg.getFieldSet(), (Serializer)buf);
            buf.putByte(null, msg.getVisitInconsistentBuckets() ? (byte)1 : 0);
            buf.putInt(null, msg.getParameters().size());
            for (Map.Entry entry : msg.getParameters().entrySet()) {
                CreateVisitorMessageFactory.encodeString((String)entry.getKey(), (Serializer)buf);
                byte[] b = (byte[])entry.getValue();
                buf.putInt(null, b.length);
                buf.put(null, b);
            }
            buf.putInt(null, 0);
            buf.putInt(null, msg.getMaxBucketsPerVisitor());
            return this.encodeBucketSpace(msg.getBucketSpace(), buf);
        }
    }

    public static abstract class DocumentReplyFactory
    extends AbstractRoutableFactory {
        protected abstract boolean doEncode(DocumentReply var1, DocumentSerializer var2);

        protected abstract DocumentReply doDecode(DocumentDeserializer var1);

        @Override
        public boolean encode(Routable obj, DocumentSerializer out) {
            if (!(obj instanceof DocumentReply)) {
                throw new AssertionError((Object)("Document reply factory (" + this.getClass().getName() + ") registered for incompatible routable type " + obj.getType() + "(" + obj.getClass().getName() + ")."));
            }
            DocumentReply reply = (DocumentReply)obj;
            out.putByte(null, (byte)reply.getPriority().getValue());
            return this.doEncode(reply, out);
        }

        @Override
        public Routable decode(DocumentDeserializer in) {
            byte pri = in.getByte(null);
            DocumentReply reply = this.doDecode(in);
            if (reply != null) {
                reply.setPriority(DocumentProtocol.getPriority(pri));
            }
            return reply;
        }
    }

    public static abstract class DocumentMessageFactory
    extends AbstractRoutableFactory {
        protected abstract boolean doEncode(DocumentMessage var1, DocumentSerializer var2);

        protected abstract DocumentMessage doDecode(DocumentDeserializer var1);

        @Override
        public boolean encode(Routable obj, DocumentSerializer out) {
            if (!(obj instanceof DocumentMessage)) {
                throw new AssertionError((Object)("Document message factory (" + this.getClass().getName() + ") registered for incompatible routable type " + obj.getType() + "(" + obj.getClass().getName() + ")."));
            }
            DocumentMessage msg = (DocumentMessage)obj;
            out.putByte(null, (byte)msg.getPriority().getValue());
            out.putInt(null, 0);
            return this.doEncode(msg, out);
        }

        @Override
        public Routable decode(DocumentDeserializer in) {
            byte pri = in.getByte(null);
            in.getInt(null);
            DocumentMessage msg = this.doDecode(in);
            if (msg != null) {
                msg.setPriority(DocumentProtocol.getPriority(pri));
            }
            return msg;
        }
    }
}

