// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.documentapi.messagebus.protocol;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of documentrouteselectorpolicy
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class DocumentrouteselectorpolicyConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "8c9f66e2e55e8863aea07acdf1ab654e";
  public final static String CONFIG_DEF_NAME = "documentrouteselectorpolicy";
  public final static String CONFIG_DEF_NAMESPACE = "documentapi.messagebus.protocol";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=documentapi.messagebus.protocol",
    "route[].name string",
    "route[].selector string",
    "route[].feed string default=\"\""
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Route.Builder> route = new ArrayList<>();

    public Builder() { }

    public Builder(DocumentrouteselectorpolicyConfig config) {
      for (Route r : config.route()) {
        route(new Route.Builder(r));
      }
    }

    private Builder override(Builder __superior) {
      if (!__superior.route.isEmpty())
        route.addAll(__superior.route);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Route builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder route(Route.Builder __builder) {
      route.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder route(java.util.function.Consumer<Route.Builder> __func) {
      Route.Builder __inner = new Route.Builder();
      __func.accept(__inner);
      route.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Route builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder route(List<Route.Builder> __builders) {
      route = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public DocumentrouteselectorpolicyConfig build() {
      return new DocumentrouteselectorpolicyConfig(this);
    }

  }

  private final InnerNodeVector<Route> route;

  public DocumentrouteselectorpolicyConfig(Builder builder) {
    this(builder, true);
  }

  private DocumentrouteselectorpolicyConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "documentrouteselectorpolicy must be initialized: " + builder.__uninitialized);

    route = Route.createVector(builder.route);
  }

  /**
   * @return documentrouteselectorpolicy.route[]
   */
  public List<Route> route() {
    return route;
  }

  /**
   * @param i the index of the value to return
   * @return documentrouteselectorpolicy.route[]
   */
  public Route route(int i) {
    return route.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(DocumentrouteselectorpolicyConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("documentrouteselectorpolicy");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents documentrouteselectorpolicy.route[]
   */
  public final static class Route extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "name",
        "selector"
        ));

      private String name = null;
      private String selector = null;
      private String feed = null;

      public Builder() { }

      public Builder(Route config) {
        name(config.name());
        selector(config.selector());
        feed(config.feed());
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (__superior.selector != null)
          selector(__superior.selector);
        if (__superior.feed != null)
          feed(__superior.feed);
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder selector(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        selector = __value;
        __uninitialized.remove("selector");
        return this;
      }


      public Builder feed(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        feed = __value;
        return this;
      }


      public Route build() {
        return new Route(this);
      }

    }

    // The name of the route.
    private final StringNode name;
    // The document selector for this route.
    private final StringNode selector;
    // The feeds that this route accepts.
    private final StringNode feed;

    public Route(Builder builder) {
      this(builder, true);
    }

    private Route(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "documentrouteselectorpolicy.route[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      selector = (builder.selector == null) ?
          new StringNode() : new StringNode(builder.selector);
      feed = (builder.feed == null) ?
          new StringNode("") : new StringNode(builder.feed);
    }

    /**
     * @return documentrouteselectorpolicy.route[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return documentrouteselectorpolicy.route[].selector
     */
    public String selector() {
      return selector.value();
    }

    /**
     * @return documentrouteselectorpolicy.route[].feed
     */
    public String feed() {
      return feed.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Route newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("route");
      return changes;
    }

    private static InnerNodeVector<Route> createVector(List<Builder> builders) {
        List<Route> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Route(b));
        }
        return new InnerNodeVector<Route>(elems);
    }
  }

}
